/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <activemq/wireformat/openwire/marshal/generated/ActiveMQBlobMessageMarshaller.h>

#include <activemq/commands/ActiveMQBlobMessage.h>
#include <activemq/exceptions/ActiveMQException.h>
#include <decaf/lang/Pointer.h>

//
//     NOTE!: This file is autogenerated - do not modify!
//            if you need to make a change, please see the Java Classes in the
//            activemq-core module
//

using namespace std;
using namespace activemq;
using namespace activemq::exceptions;
using namespace activemq::commands;
using namespace activemq::wireformat;
using namespace activemq::wireformat::openwire;
using namespace activemq::wireformat::openwire::marshal;
using namespace activemq::wireformat::openwire::utils;
using namespace activemq::wireformat::openwire::marshal::generated;
using namespace decaf;
using namespace decaf::io;
using namespace decaf::lang;

///////////////////////////////////////////////////////////////////////////////
DataStructure* ActiveMQBlobMessageMarshaller::createObject() const {
    return new ActiveMQBlobMessage();
}

///////////////////////////////////////////////////////////////////////////////
unsigned char ActiveMQBlobMessageMarshaller::getDataStructureType() const {
    return ActiveMQBlobMessage::ID_ACTIVEMQBLOBMESSAGE;
}

///////////////////////////////////////////////////////////////////////////////
void ActiveMQBlobMessageMarshaller::tightUnmarshal(OpenWireFormat* wireFormat, DataStructure* dataStructure, DataInputStream* dataIn, BooleanStream* bs) {

    try {

        MessageMarshaller::tightUnmarshal(wireFormat, dataStructure, dataIn, bs);

        ActiveMQBlobMessage* info =
            dynamic_cast<ActiveMQBlobMessage*>(dataStructure);

        int wireVersion = wireFormat->getVersion();

        if (wireVersion >= 3) {
            info->setRemoteBlobUrl(tightUnmarshalString(dataIn, bs));
        }
        if (wireVersion >= 3) {
            info->setMimeType(tightUnmarshalString(dataIn, bs));
        }
        if (wireVersion >= 3) {
            info->setDeletedByBroker(bs->readBoolean());
        }
    }
    AMQ_CATCH_RETHROW(decaf::io::IOException)
    AMQ_CATCH_EXCEPTION_CONVERT(exceptions::ActiveMQException, decaf::io::IOException)
    AMQ_CATCHALL_THROW(decaf::io::IOException)
}

///////////////////////////////////////////////////////////////////////////////
int ActiveMQBlobMessageMarshaller::tightMarshal1(OpenWireFormat* wireFormat, DataStructure* dataStructure, BooleanStream* bs) {

    try {

        ActiveMQBlobMessage* info =
            dynamic_cast<ActiveMQBlobMessage*>(dataStructure);

        int rc = MessageMarshaller::tightMarshal1(wireFormat, dataStructure, bs);

        int wireVersion = wireFormat->getVersion();

        if (wireVersion >= 3) {
            rc += tightMarshalString1(info->getRemoteBlobUrl(), bs);
        }
        if (wireVersion >= 3) {
            rc += tightMarshalString1(info->getMimeType(), bs);
        }
        if (wireVersion >= 3) {
            bs->writeBoolean(info->isDeletedByBroker());
        }

        return rc + 0;
    }
    AMQ_CATCH_RETHROW(decaf::io::IOException)
    AMQ_CATCH_EXCEPTION_CONVERT(exceptions::ActiveMQException, decaf::io::IOException)
    AMQ_CATCHALL_THROW(decaf::io::IOException)
}

///////////////////////////////////////////////////////////////////////////////
void ActiveMQBlobMessageMarshaller::tightMarshal2(OpenWireFormat* wireFormat, DataStructure* dataStructure, DataOutputStream* dataOut, BooleanStream* bs) {

    try {

        MessageMarshaller::tightMarshal2(wireFormat, dataStructure, dataOut, bs );

        ActiveMQBlobMessage* info =
            dynamic_cast<ActiveMQBlobMessage*>(dataStructure);

        int wireVersion = wireFormat->getVersion();

        if (wireVersion >= 3) {
            tightMarshalString2(info->getRemoteBlobUrl(), dataOut, bs);
        }
        if (wireVersion >= 3) {
            tightMarshalString2(info->getMimeType(), dataOut, bs);
        }
        if (wireVersion >= 3) {
            bs->readBoolean();
        }
    }
    AMQ_CATCH_RETHROW(decaf::io::IOException)
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException)
    AMQ_CATCHALL_THROW(decaf::io::IOException)
}

///////////////////////////////////////////////////////////////////////////////
void ActiveMQBlobMessageMarshaller::looseUnmarshal(OpenWireFormat* wireFormat, DataStructure* dataStructure, DataInputStream* dataIn) {

    try {

        MessageMarshaller::looseUnmarshal(wireFormat, dataStructure, dataIn);
        ActiveMQBlobMessage* info =
            dynamic_cast<ActiveMQBlobMessage*>(dataStructure);

        int wireVersion = wireFormat->getVersion();

        if (wireVersion >= 3) {
            info->setRemoteBlobUrl(looseUnmarshalString(dataIn));
        }
        if (wireVersion >= 3) {
            info->setMimeType(looseUnmarshalString(dataIn));
        }
        if (wireVersion >= 3) {
            info->setDeletedByBroker(dataIn->readBoolean());
        }
    }
    AMQ_CATCH_RETHROW(decaf::io::IOException)
    AMQ_CATCH_EXCEPTION_CONVERT(exceptions::ActiveMQException, decaf::io::IOException)
    AMQ_CATCHALL_THROW(decaf::io::IOException)
}

///////////////////////////////////////////////////////////////////////////////
void ActiveMQBlobMessageMarshaller::looseMarshal(OpenWireFormat* wireFormat, DataStructure* dataStructure, DataOutputStream* dataOut) {

    try {

        ActiveMQBlobMessage* info =
            dynamic_cast<ActiveMQBlobMessage*>(dataStructure);
        MessageMarshaller::looseMarshal(wireFormat, dataStructure, dataOut);

        int wireVersion = wireFormat->getVersion();

        if (wireVersion >= 3) {
            looseMarshalString(info->getRemoteBlobUrl(), dataOut);
        }
        if (wireVersion >= 3) {
            looseMarshalString(info->getMimeType(), dataOut);
        }
        if (wireVersion >= 3) {
            dataOut->writeBoolean(info->isDeletedByBroker());
        }
    }
    AMQ_CATCH_RETHROW(decaf::io::IOException)
    AMQ_CATCH_EXCEPTION_CONVERT(exceptions::ActiveMQException, decaf::io::IOException)
    AMQ_CATCHALL_THROW(decaf::io::IOException)
}

