/**
 * CSFP (CrazySumForPasswords) v.2 (c)opyleft Robert Fahy, August 2009
 * 
 * This little program computes the checksum of the input then "hashes" it by rotation, kinda.
 * You must remember the desired max value you used for your password if you prefer
 * the regeneration-on-the-fly-cause-i'm-too-paranoid-to-just-simply-save-my-passwords method.
 *
 * This program is intended to be used as a password generator, and nothing more.
 * Stay tuned for version 2, which will have SHA512 built in! Someday.
 *
 * Finally, I'm not a professional so I'm sorry if you feel appaled by my code.
 * Tell me about it via:
 *						rfahy@ymail.com
 *
 * NEW SINCE VERSION 1:
 * - max password length raised from 128 to 2048 characters, for the extra paranoid types
 **/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/wait.h>

/** functions-content */
void encrypt (char *, int, char *);					// encrypts first string into second, middle is max length of result
void print_usage (char *, char *);					// prints usage and custom error
int check_programs (char *);						// verifies for hash generators
void m1_stdin_no_max (char *);						// verifies stdin for data, max defaulted to 128
void m2_stdin_or_max (char *, char *);				// verifies stdin for data ->Yes: take argument as max, ->No: take argument as filename
void m3_stdin_and_max (char *, char *, char *);		// don't verify stdin, argument1 filename, argument2 max
	// as the names suggest for the last 3, it's pretty much copy-pasta, and with only slightly different seasoning

void encrypt (char *what, int trim, char *result) // this generates 256 bytes * original value of multiplier (so yeah 2048 bytes heh heh)
{
	// below are the possible encryption charsets - feel free to select or change; in some cases, certain symbols
	// won't be allowed in your password, so you'll Want to edit this part

	// (1) full features, next step would be /dev/random ;)
	//	char symbol_pool[]="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ/\\'`\"[]{}()<>*+-=?!_^&$#@~|;:., ";
	// (2) full features, except Space - I personally prefer this one
	char symbol_pool[]="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ/\\'`\"[]{}()<>*+-=?!_^&$#@~|;:.,";
	// (3) most places where you can use a password
	//	char symbol_pool[]="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ[]{}()<>?!_-";
	// (4) most places where you can use a password, but restrictive special symbol -wise
	//	char symbol_pool[]="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";

	int i, res_increment=0, ok=0, multiplier=8, salt_thing=0, sympool_len = strlen(symbol_pool);

	while (multiplier--)
	{
		for (i=0; i < strlen(what); i++)
		{
			ok=0;
			salt_thing += (int)what[i];
			salt_thing += trim;

			while (!ok)
			{
				if (salt_thing >= sympool_len) // added ASCII codes determine position
				{
					salt_thing -= sympool_len;
				}
				else // we found one
				{
					result[res_increment++] = symbol_pool[salt_thing];
					ok=1;
				}
			}
		}

		for (i = (strlen(what) - 1); i >= 0; i--) // here we go again
		{
			ok=0;
			salt_thing += (int)what[i];
			salt_thing *= 7;

			while (!ok)
			{
				if (salt_thing >= sympool_len)
				{
					salt_thing -= sympool_len;
				}
				else
				{
					result[res_increment++] = symbol_pool[salt_thing];
					ok=1;
				}
			}
		}
	}

	result[trim] = '\0'; // boom. security experts horrified.
}


void print_usage (char *name, char *error)
{
	printf ("CSFP v.2 usage:\n %s <[file_to_be_checksumed] [desired_length_of_result]>\n"
			"Also accepting standard input (stdin) and providing length is not compulsory\n (default is \"128\", maximum is \"2048\").\n\nERROR: %s\n\n\n", name, error);
}

int check_programs (char *chksumprg) // this, until I integrate SHA512 I suppose
{
#if 0
/*
	FILE *ls_usr_bin;

	ls_usr_bin = popen ("ls /usr/bin/sha512sum /usr/bin/sha256sum /usr/bin/sha1sum /usr/bin/md5sum -f", "w");

	if (ls_usr_bin == NULL)
	{
		return 0;
	}
	else
	{
		fscanf (ls_usr_bin, chksumprg);
		pclose (ls_usr_bin);

		return 1;
	}
*/
#endif
	strcpy (chksumprg, "sha512sum");
	return 1; // presume that we have sha512sum, dun matter
}

void m1_stdin_no_max (char *program)
{
	char comm[64], checksum[128], crypted_checksum[2048];
	int csum2prog[2], pid;

	pipe (csum2prog);
	sprintf (comm, "%s", program);

	if ((pid=fork()) < 0)
	{
		perror ("m1_stdin_no_max()->fork()");
		exit (-7);
	}
	else
	{
		if (!pid) // child process
		{
			close (csum2prog[0]);
			dup2 (csum2prog[1], 1); // always read the manpages - LPG 0.4 lied about dup2
			execlp (comm, comm, NULL);

			exit (7);
		}
		else // parent process
		{
			close (csum2prog[1]);
			read (csum2prog[0], checksum, sizeof(checksum));
			encrypt (checksum, 128, crypted_checksum);
			printf (crypted_checksum);
			wait (NULL);
		}
	}
}

void m2_stdin_or_max (char *program, char *argument)
{
	char comm[64], checksum[128], crypted_checksum[2048];
	int csum2prog[2], pid;
	char test[256];

	pipe (csum2prog);
	sprintf (comm, "%s", program);
	sprintf (test, "%d", atoi(argument));

	if (strncmp(argument, test, strlen(test)))
	{	// cheap way to presume filename
		if ((pid=fork()) < 0)
		{
			perror  ("m2_stdin_or_max()->fork() #1");
			exit (-7); // "no luck"
		}
		else
		{
			if (!pid) // child process
			{
				close (csum2prog[0]);
				dup2 (csum2prog[1], 1); // always read the manpages - LPG 0.4 lied about dup2
				execlp (comm, comm, argument, NULL);

				exit (7);
			}
			else // parent process
			{
				close (csum2prog[1]);
				read (csum2prog[0], checksum, sizeof(checksum));
				encrypt (checksum, 128, crypted_checksum);
				printf (crypted_checksum);
				wait (NULL);
			}
		}
	}
	else // presume max
	{
		if ((pid=fork()) < 0)
		{
			perror ("m2_stdin_or_max()->fork() #2");
			exit (-7);
		}
		else
		{
			if (!pid) // child process
			{
				close (csum2prog[0]);
				dup2 (csum2prog[1], 1); // always read the manpages - LPG 0.4 lied about dup2
				execlp (comm, comm, NULL);

				exit (7);
			}
			else // parent process
			{
				close (csum2prog[1]);
				read (csum2prog[0], checksum, sizeof(checksum));
				encrypt (checksum, atoi(argument), crypted_checksum);
				printf (crypted_checksum);
				wait (NULL);
			}
		}
	}
}

void m3_stdin_and_max (char *program, char *file, char *max)
{
	char comm[64], checksum[128], crypted_checksum[2048];
	int csum2prog[2], pid;

	pipe (csum2prog);
	sprintf (comm, "%s", program);

	if ((pid=fork()) < 0)
	{
		perror ("m3_stdin_and_max()->fork()");
		exit (-7);
	}
	else
	{
		if (!pid) // child process
		{
			close (csum2prog[0]);
			dup2 (csum2prog[1], 1); // always read the manpages - LPG 0.4 lied about dup2
			execlp (comm, comm, file, NULL);

			exit (7);
		}
		else // parent process
		{
			close (csum2prog[1]);
			read (csum2prog[0], checksum, sizeof(checksum));
			encrypt (checksum, atoi(max), crypted_checksum);
			printf (crypted_checksum);
			wait (NULL);
		}
	}
}

int main (int argc, char **argv)
{
	char checksumprogram[10];

#if 0 // because check_programs() doesn't actually check anymore :P
/*
	if (!check_programs(checksumprogram))
	{
	//	print_usage (argv[0], "At least one of the following must be installed:\n sha512sum, sha256sum, sha1sum, md5sum.");
		print_usage (argv[0], "sha512sum program was not found.");
		exit (1);
	}
*/
#endif

	check_programs(checksumprogram);

	if (argc > 3)
	{
		print_usage (argv[0], "Too many arguments.");
		exit (2);
	}

	switch (argc)
	{
		case 1: m1_stdin_no_max(checksumprogram); break;
		case 2: m2_stdin_or_max(checksumprogram, argv[1]); break;
		case 3: m3_stdin_and_max(checksumprogram, argv[1], argv[2]); break;
		default: print_usage (argv[0], "Unknown. Email <rfahy@ymail.com> and include detail please."); exit (3);
	};

	printf ("\n");

	return 0;
}
