/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/* radmin: Administration of References installation */


// mode for mkdir: (S_IRUSR | S_IWUSR | S_IXUSR)
// alternative mode for mkdir: (S_IRUSR | S_IWUSR | S_IXUSR | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH)

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
/* for mkdir: */
#ifdef REFS_USES_LINUXGCC
#include <sys/types.h>
#include <sys/stat.h>
#endif

#include "refs.h"
#include "rglobal.h"
#include "str_fun.h"
#include "fl_ut.h"
#include "interf.h"
#include "initial.h"

#define LANG_PFAD_LEN 1024
#define HELP_PDFFILE_NAME "refsdok.pdf"

 char rad_textpfad[PFAD_LEN+1];
 char rad_exepfad[PFAD_LEN+1];
 char rad_rdbpfad[PFAD_LEN+1];
 char rad_docpfad[PFAD_LEN+1];
 char rad_installationspfad[PFAD_LEN+1];
 
 int verzeichnisse_testen(void);
 int hauptmenu(void);
 int check_correct_paths(void);
 int create_database(void);
 int filename_ok(char * name);
 
 
int main(int argc, char * argv[])
{
   
#ifdef REFS_USES_LINUXGCC
  static char ein[INPUT_BU_LEN+1];
  int option;
  option=0;
  strcpy(ein,"menu");
#endif
  signal(SIGINT,SIG_IGN);
  strcpy(one_config_set.prompt,": ");
#ifdef REFS_USES_LINUXGCC
  option=0;
  strcpy(ein,"menu");
  strcpy(one_config_set.textfile_encoding,ENC_UTF8);
  wrtxt("\nPlease enter text file encoding on your Linux system [1/2/q]\n");
  option = menu_wahl(ein,
  "[1] utf-8\n"
  "[2] latin-1 (ISO-8859-1) or latin-9 (ISO-8859-15)\n"
  "[q] quit"
  );
  if (option==3)
  {
    wrtxt("\n(Radmin closed)\n");
    wrtxt("\n"); 
    return 0;
  }
  if (option==2)
  {
    strcpy(one_config_set.textfile_encoding,ENC_ISO8859);
  }
  if (option==1)
  {
    strcpy(one_config_set.textfile_encoding,ENC_UTF8);
  }
#endif
  wrtxt("\nRadmin.exe -- tool for administration of References Bibliographic "
     "Software\n");
  if (verzeichnisse_testen() == 1)
  {
     hauptmenu();
  }
  wrtxt("\n(Radmin closed)\n");
#ifdef REFS_USES_LINUXGCC
  wrtxt("\n"); 
#endif
  return 0;
}


int verzeichnisse_testen(void)
{
   char aktuelles_verzeichnis[LANG_PFAD_LEN +1];
   getcwd(aktuelles_verzeichnis,PFAD_LEN);
   rtrim(aktuelles_verzeichnis,'\\');
   rtrim(aktuelles_verzeichnis,'/');
   backslash_to_slash(aktuelles_verzeichnis);
   
   wrtxt("\nCurrent directory (folder) is:\n   `");
   wrtxt(aktuelles_verzeichnis);
   wrtxt("'");
   /* anhalten(); */

   if (locate_substring(" ",aktuelles_verzeichnis)> -1)
   {
      wrtxt("\nProblem: Path to References installation directory "
        "must not contain spaces\n");
      anhalten();
   }
   if (strlen(aktuelles_verzeichnis)> (PFAD_LEN - 5))
   {
      wrtxt("\nProblem: Path to References installation directory "
        "too long\n");
      anhalten();
   }
   
   strlimcpy(rad_installationspfad,aktuelles_verzeichnis,PFAD_LEN);
   strlimcpy(rad_exepfad,rad_installationspfad,PFAD_LEN);
   strlimcat(rad_exepfad,"/",PFAD_LEN);
   strlimcat(rad_exepfad,"bin",PFAD_LEN);
   strlimcpy(rad_docpfad,rad_installationspfad,PFAD_LEN);
   strlimcat(rad_docpfad,"/",PFAD_LEN);
   strlimcat(rad_docpfad,"doc",PFAD_LEN);
   if (chdir(rad_exepfad)!=0)
   {
      wrtxt("\nProblem: Executable files directory (folder) not found\n");
      anhalten();
      return 0;
   }
   /* begin new v4.1j */
   /* emporarily removed with v4.2
   if (isfile(REFSRUN_DOLLAR))
   {
      static char ein[INPUT_BU_LEN+1];
      int option;
      
      sprintf(wrtxtbu,"\n\nFile `%s' found, delete [y/n]\n",REFSRUN_DOLLAR);
      wrtxt(wrtxtbu);
      strcpy(ein,"menu");
      option = menu_wahl(ein,
        "[y] yes delete \n"
        "[n] no do not delete");
       if (option==1)
       {
          remove(REFSRUN_DOLLAR);
       }
   }
   */
   /* end v4.1j */
   getcwd(aktuelles_verzeichnis,LANG_PFAD_LEN);
   rtrim(aktuelles_verzeichnis,'\\');
   rtrim(aktuelles_verzeichnis,'/');
   backslash_to_slash(aktuelles_verzeichnis);
   wrtxt("\nExecutable files directory (folder) is:\n   `");
   wrtxt(aktuelles_verzeichnis);
   wrtxt("'\n");
   /* anhalten(); */

   if (chdir(rad_installationspfad)!=0)
   {
      wrtxt("\nProblem: Installation directory (folder) not found\n");
      anhalten();
      return 0;
   }
   
   return 1;
}
int hauptmenu(void)
{
  static char ein[INPUT_BU_LEN+1];
  int option;
  option=0;
  strcpy(ein,"menu");
  while (option < 4)
  {
    wrtxt("\nRadmin menu -- [p/n/a/q] -- [Enter] shows menu options \n");
    option = menu_wahl(ein,
      "[p] check/correct path entries \n"
      "[n] create a new References database\n"
      "[a] about Radmin\n"
      "[q] quit"
      );
     if (option==1) /* [p] */
     {
        check_correct_paths();
     }
     if (option==2) /* [n] */
     {
        create_database();
     }
     if (option==3) /* [a] */
     {
        wrtxt(VERSION_INFO);
        /* sprintf(wrtxtbu,"\nRadmin for References v%s\n",REFS_SUB_VERSION); */ 
        sprintf(wrtxtbu,"\nRadmin for References v%s\n",REFS_SUB_VERSION);
        wrtxt(wrtxtbu);
     }
    
    strcpy(ein,"menu");
  }
  return 1;
}

int check_correct_paths(void)
{
   int anzahl_datenbanken, i;
   FILE * fptextfiles;
   char eingabe[INPUT_BU_LEN+1];
   char ex_zeile[INPUT_BU_LEN+1];
   char datenbank[PFAD_LEN+1];
   char startdatei[PFAD_LEN+1];   /* name of starting batch/script file */
   char e_startdatei[PFAD_LEN+1]; /* name of starting batch/script file */
   char textfiles[PFAD_LEN+1];
   char pfad[PFAD_LEN+1];
#if defined(REFS_USES_LINUXGCC)
  char * ep;
#endif   

#if defined(REFS_USES_MINGW)
   strlimcpy(textfiles,rad_exepfad,PFAD_LEN);
   strlimcat(textfiles,"/refs.cfg",PFAD_LEN);
   if ((fptextfiles=fopen(textfiles,"a"))==NULL)
   {
     wrtxt("\nProblem: cannot open configuration file for writing\n");
     return 0;
   }
#endif   
#if defined(REFS_USES_LINUXGCC)
  ep = getenv("HOME");
  if (ep!=NULL)
  {
     strlimcpy(textfiles,ep,PFAD_LEN);
     strlimcat(textfiles,"/",PFAD_LEN);
     strlimcat(textfiles,REFS_CFG_NAME,PFAD_LEN);
     if ((fptextfiles=fopen(textfiles,"a"))==NULL)
     {
       wrtxt("\nProblem: cannot open configuration file for writing\n");
       return 0;
     }
  } else
  {
     wrtxt("\nProblem: cannot find configuration file!\n");
  }
#endif   
#if defined(REFS_USES_MINGW)
   fprintf(fptextfiles,"\n\nAWK=%s/awk.exe\n",rad_exepfad);
#endif   
#if defined(REFS_USES_LINUXGCC)
   fprintf(fptextfiles,"\n\nAWK=gawk\n");
   fprintf(fptextfiles,"TEXTFILE_ENCODING=%s\n",
       one_config_set.textfile_encoding);
#endif   
   fprintf(fptextfiles,"PATH_TO_SCRIPTS=%s/\n",rad_exepfad);
   fprintf(fptextfiles,"HELP_FILE=%s/%s\n",rad_docpfad,HELP_PDFFILE_NAME);
   fclose(fptextfiles);


   sprintf(wrtxtbu,"\nConfiguration file `%s' updated\n",textfiles);
   wrtxt(wrtxtbu);
   wrtxt("\nPlease enter now the References databases to be updated with\n"
         "their starting script files. Database names should be separated with\n"
         "spaces. For the default installation enter: `data tutorial'\n");
  
   
   ein_zeile(eingabe,"Database names",INPUT_BU_LEN);
   anzahl_datenbanken = countitem(eingabe," ");

   for (i=1;i<=anzahl_datenbanken;i++)
   {
      extractitem(i,eingabe," ",ex_zeile);
      strlimcpy(datenbank,ex_zeile,PFAD_LEN);
      strlimcpy(startdatei,datenbank,PFAD_LEN);
#if defined(REFS_USES_MINGW)
      strlimcat(startdatei,".bat",PFAD_LEN);
#endif
#if defined(REFS_USES_LINUXGCC)
      strlimcat(startdatei,".sh",PFAD_LEN);
#endif
      if (!isfile(startdatei))
      {
         sprintf(wrtxtbu,"\nProblem: `%s' does not exist, assume that `%s' is not a database\n",
           startdatei,datenbank);
         wrtxt(wrtxtbu);
         continue;
      }
      strlimcpy(e_startdatei,"e-",PFAD_LEN);
      strlimcat(e_startdatei,datenbank,PFAD_LEN);
#if defined(REFS_USES_MINGW)
      strlimcat(e_startdatei,".bat",PFAD_LEN);
#endif
#if defined(REFS_USES_LINUXGCC)
      strlimcat(e_startdatei,".sh",PFAD_LEN);
#endif
      if (!isfile(e_startdatei))
      {
         sprintf(wrtxtbu,"\nProblem: `%s' does not exist, assume that `%s' is not a database\n",
           e_startdatei,datenbank);
         wrtxt(wrtxtbu);
         continue;
         // return 0;
      }
      if ((fptextfiles=fopen(startdatei,"w"))==NULL)
      {
        sprintf(wrtxtbu,"\nProblem: cannot open `%s' for writing\n",startdatei);
        wrtxt(wrtxtbu);
        return 0;
      }
#if defined(REFS_USES_MINGW)
      fprintf(fptextfiles,"@echo off\n");
      fprintf(fptextfiles,"set REFS_CFG_PATH=%s/\n",rad_exepfad);
      strlimcpy(pfad,rad_installationspfad,PFAD_LEN);
      strlimcat(pfad,"/",PFAD_LEN);
      strlimcat(pfad,datenbank,PFAD_LEN);
        slash_to_backslash(pfad);
      fprintf(fptextfiles,"cd %s\n",pfad);
      strlimcpy(pfad,rad_exepfad,PFAD_LEN);
      strlimcat(pfad,"/refs43.exe",PFAD_LEN);
        slash_to_backslash(pfad);
      fprintf(fptextfiles,"%s %%1 %%2 %%3 %%4\n",pfad);
      // neu
      strlimcpy(pfad,rad_installationspfad,PFAD_LEN);
        slash_to_backslash(pfad);
      fprintf(fptextfiles,"cd %s\n",pfad);
      fprintf(fptextfiles,"set REFS_CFG_PATH=\n");
      fprintf(fptextfiles,"rem\n");
      fprintf(fptextfiles,"rem This batch/script file was generated by radmin.exe\n");
      fprintf(fptextfiles,"rem\n");
#endif      
#if defined(REFS_USES_LINUXGCC)
      fprintf(fptextfiles,"#!/bin/sh\n");
      strlimcpy(pfad,rad_installationspfad,PFAD_LEN);
      strlimcat(pfad,"/",PFAD_LEN);
      strlimcat(pfad,datenbank,PFAD_LEN);
      fprintf(fptextfiles,"cd %s\n",pfad);
      
      strlimcpy(pfad,rad_exepfad,PFAD_LEN);
      strlimcat(pfad,"/refs43",PFAD_LEN);
        // slash_to_backslash(pfad);
      fprintf(fptextfiles,"%s $1\n",pfad);
      fprintf(fptextfiles,"#\n");
      fprintf(fptextfiles,"# This script file was generated by radmin\n");
      fprintf(fptextfiles,"#\n");
#endif      
      fclose(fptextfiles);
      sprintf(wrtxtbu,"  `%s' written\n",startdatei);
      wrtxt(wrtxtbu); 
      /*  */

      if ((fptextfiles=fopen(e_startdatei,"w"))==NULL)
      {
        sprintf(wrtxtbu,"\nProblem: cannot open `%s' for writing\n",e_startdatei);
        wrtxt(wrtxtbu);
        return 0;
      }

#if defined(REFS_USES_MINGW)
      fprintf(fptextfiles,"@echo off\n");
      fprintf(fptextfiles,"set REFS_CFG_PATH=%s/\n",rad_exepfad);
      strlimcpy(pfad,rad_installationspfad,PFAD_LEN);
      strlimcat(pfad,"/",PFAD_LEN);
      strlimcat(pfad,datenbank,PFAD_LEN);
        slash_to_backslash(pfad);
      fprintf(fptextfiles,"cd %s\n",pfad);
      strlimcpy(pfad,rad_exepfad,PFAD_LEN);
      strlimcat(pfad,"/etext.exe",PFAD_LEN);
        slash_to_backslash(pfad);
      fprintf(fptextfiles,"%s %%1 %%2 %%3 %%4\n",pfad);
      // neu
      strlimcpy(pfad,rad_installationspfad,PFAD_LEN);
        slash_to_backslash(pfad);
      fprintf(fptextfiles,"cd %s\n",pfad);
      fprintf(fptextfiles,"set REFS_CFG_PATH=\n");
      fprintf(fptextfiles,"rem\n");
      fprintf(fptextfiles,"rem This batch/script file was generated by radmin.exe\n");
      fprintf(fptextfiles,"rem\n");
#endif      
#if defined(REFS_USES_LINUXGCC)
      fprintf(fptextfiles,"#!/bin/sh\n");
      strlimcpy(pfad,rad_installationspfad,PFAD_LEN);
      strlimcat(pfad,"/",PFAD_LEN);
      strlimcat(pfad,datenbank,PFAD_LEN);
      fprintf(fptextfiles,"cd %s\n",pfad);

      strlimcpy(pfad,rad_exepfad,PFAD_LEN);
      strlimcat(pfad,"/etext",PFAD_LEN);
        // slash_to_backslash(pfad);
      fprintf(fptextfiles,"%s $1\n",pfad);
      fprintf(fptextfiles,"#\n");
      fprintf(fptextfiles,"# This script file was generated by radmin\n");
      fprintf(fptextfiles,"#\n");

#endif      
      
      fclose(fptextfiles);
      sprintf(wrtxtbu,"  `%s' written\n",e_startdatei);
      wrtxt(wrtxtbu); 

   } /* for (i=1;i<=anzahl_datenbanken;i++) */   
   
   return 1;
}


int create_database(void)
{
   char eingabe[INPUT_BU_LEN+1];
   char datenbank[PFAD_LEN+1];
   char startdatei[PFAD_LEN+1]; /* name of starting batch  */
   char e_startdatei[PFAD_LEN+1]; /* name of starting batch  */
   // char textfiles[PFAD_LEN+1];
   char pfad[PFAD_LEN+1];
   FILE * fptextfiles;
   
   
   wrtxt("\nPlease enter the name of a new database (max. 8 characters)\n");
   ein_zeile(eingabe,"Database name",INPUT_BU_LEN);
   
   if (strlen(eingabe)<1)
   {
      wrtxt("\nNothing done\n");
      return 0;
   }
   if (strlen(eingabe)>8)
   {
      wrtxt("\nDatabase name too long -- nothing done\n");
      return 0;
   }
   if (locate_substring(" ",eingabe)>-1)
   {
      wrtxt("\nDatabase name must not contain spaces -- nothing done\n");
      return 0;
   }
   if ((locate_substring("e-",eingabe)==0)||(locate_substring("E-",eingabe)==0))
   {
      wrtxt("\nDatabase name must not begin with `e-' -- nothing done\n");
      return 0;
   }
   if (!filename_ok(eingabe))
   {
      wrtxt("\nDatabase name has illegal characters -- nothing done\n");
      return 0;
   }
   if (chdir(eingabe)==0)
   {
       sprintf(wrtxtbu,"\nDirectory/folder `%s/%s' already exists -- nothing done\n",
         rad_installationspfad,eingabe);
       wrtxt(wrtxtbu);
       chdir("..");
       return 0;
   }
   anhalten();

   strlimcpy(datenbank,eingabe,PFAD_LEN); 
   strlimcpy(pfad,rad_installationspfad,PFAD_LEN);
   strlimcat(pfad,"/",PFAD_LEN);
   strlimcat(pfad,datenbank,PFAD_LEN);
#ifdef REFS_USES_MINGW
   if (mkdir(pfad)==0)
#endif
#ifdef REFS_USES_LINUXGCC
   if (mkdir(pfad, (S_IRUSR | S_IWUSR | S_IXUSR))==0)
#endif
   {
     sprintf(wrtxtbu,"\n  `%s' created",pfad);
     wrtxt(wrtxtbu);
   }
   strlimcat(pfad,"/rdb",PFAD_LEN);
#ifdef REFS_USES_MINGW
   if (mkdir(pfad)==0)
#endif
#ifdef REFS_USES_LINUXGCC
   if (mkdir(pfad, (S_IRUSR | S_IWUSR | S_IXUSR))==0)
#endif
   {
     sprintf(wrtxtbu,"\n  `%s' created\n",pfad);
     wrtxt(wrtxtbu);
   }


      strlimcpy(startdatei,datenbank,PFAD_LEN);
#ifdef REFS_USES_MINGW
      strlimcat(startdatei,".bat",PFAD_LEN);
#endif
#ifdef REFS_USES_LINUXGCC
      strlimcat(startdatei,".sh",PFAD_LEN);
#endif
      if (isfile(startdatei))
      {
         sprintf(wrtxtbu,"\nProblem: `%s' already exists\n",startdatei);
         wrtxt(wrtxtbu);
         return 0;
      }
      strlimcpy(e_startdatei,"e-",PFAD_LEN);
      strlimcat(e_startdatei,datenbank,PFAD_LEN);
#ifdef REFS_USES_MINGW
      strlimcat(e_startdatei,".bat",PFAD_LEN);
#endif
#ifdef REFS_USES_LINUXGCC
      strlimcat(e_startdatei,".sh",PFAD_LEN);
#endif
      if (isfile(e_startdatei))
      {
         sprintf(wrtxtbu,"\nProblem: `%s' already exists\n",e_startdatei);
         wrtxt(wrtxtbu);
         return 0;
      }
      if ((fptextfiles=fopen(startdatei,"w"))==NULL)
      {
        sprintf(wrtxtbu,"\nProblem: cannot open `%s' for writing\n",startdatei);
        wrtxt(wrtxtbu);
        return 0;
      }

#ifdef REFS_USES_MINGW
      fprintf(fptextfiles,"@echo off\n");
      fprintf(fptextfiles,"set REFS_CFG_PATH=%s/\n",rad_exepfad);
      strlimcpy(pfad,rad_installationspfad,PFAD_LEN);
      strlimcat(pfad,"/",PFAD_LEN);
      strlimcat(pfad,datenbank,PFAD_LEN);
        slash_to_backslash(pfad);
      fprintf(fptextfiles,"cd %s\n",pfad);
      strlimcpy(pfad,rad_exepfad,PFAD_LEN);
      strlimcat(pfad,"/refs43.exe",PFAD_LEN);
        slash_to_backslash(pfad);
      fprintf(fptextfiles,"%s %%1 %%2 %%3 %%4\n",pfad);
      // neu
      strlimcpy(pfad,rad_installationspfad,PFAD_LEN);
        slash_to_backslash(pfad);
      fprintf(fptextfiles,"cd %s\n",pfad);
      fprintf(fptextfiles,"set REFS_CFG_PATH=\n");
      fprintf(fptextfiles,"rem\n");
      fprintf(fptextfiles,"rem This batch/script file was generated by radmin.exe\n");
      fprintf(fptextfiles,"rem\n");
#endif      
#ifdef REFS_USES_LINUXGCC
      fprintf(fptextfiles,"#!/bin/sh\n");
      strlimcpy(pfad,rad_installationspfad,PFAD_LEN);
      strlimcat(pfad,"/",PFAD_LEN);
      strlimcat(pfad,datenbank,PFAD_LEN);
      fprintf(fptextfiles,"cd %s\n",pfad);
      
      strlimcpy(pfad,rad_exepfad,PFAD_LEN);
      strlimcat(pfad,"/refs43",PFAD_LEN);
        // slash_to_backslash(pfad);
      fprintf(fptextfiles,"%s $1\n",pfad);
      fprintf(fptextfiles,"#\n");
      fprintf(fptextfiles,"# This script file was generated by radmin\n");
      fprintf(fptextfiles,"#\n");
#endif      
      fclose(fptextfiles);
      sprintf(wrtxtbu,"  `%s' written\n",startdatei);
      wrtxt(wrtxtbu); 
      /*  */

      if ((fptextfiles=fopen(e_startdatei,"w"))==NULL)
      {
        sprintf(wrtxtbu,"\nProblem: cannot open `%s' for writing\n",e_startdatei);
        wrtxt(wrtxtbu);
        return 0;
      }
#ifdef REFS_USES_MINGW
      fprintf(fptextfiles,"@echo off\n");
      fprintf(fptextfiles,"set REFS_CFG_PATH=%s/\n",rad_exepfad);
      strlimcpy(pfad,rad_installationspfad,PFAD_LEN);
      strlimcat(pfad,"/",PFAD_LEN);
      strlimcat(pfad,datenbank,PFAD_LEN);
        slash_to_backslash(pfad);
      fprintf(fptextfiles,"cd %s\n",pfad);
      strlimcpy(pfad,rad_exepfad,PFAD_LEN);
      strlimcat(pfad,"/etext.exe",PFAD_LEN);
        slash_to_backslash(pfad);
      fprintf(fptextfiles,"%s %%1 %%2 %%3 %%4\n",pfad);
      // neu
      strlimcpy(pfad,rad_installationspfad,PFAD_LEN);
        slash_to_backslash(pfad);
      fprintf(fptextfiles,"cd %s\n",pfad);
      fprintf(fptextfiles,"set REFS_CFG_PATH=\n");
      fprintf(fptextfiles,"rem\n");
      fprintf(fptextfiles,"rem This batch/script file was generated by radmin.exe\n");
      fprintf(fptextfiles,"rem\n");
#endif      
#if defined(REFS_USES_LINUXGCC)
      fprintf(fptextfiles,"#!/bin/sh\n");
      strlimcpy(pfad,rad_installationspfad,PFAD_LEN);
      strlimcat(pfad,"/",PFAD_LEN);
      strlimcat(pfad,datenbank,PFAD_LEN);
      fprintf(fptextfiles,"cd %s\n",pfad);

      strlimcpy(pfad,rad_exepfad,PFAD_LEN);
      strlimcat(pfad,"/etext",PFAD_LEN);
        // slash_to_backslash(pfad);
      fprintf(fptextfiles,"%s $1\n",pfad);
      fprintf(fptextfiles,"#\n");
      fprintf(fptextfiles,"# This script file was generated by radmin\n");
      fprintf(fptextfiles,"#\n");
#endif      
      fclose(fptextfiles);
      sprintf(wrtxtbu,"  `%s' written\n",e_startdatei);
      wrtxt(wrtxtbu);

#if defined(REFS_USES_MINGW)
      wrtxt("\nTo complete installation of the new database:");
      wrtxt("\n  1. Create database and index files: [main-f r c].");
      wrtxt("\n  2. Run the database.bat script.");
      wrtxt("\n  3. Import minimal database (.arr file).");
      wrtxt("\nDetails are described in the documentation.\n");
#endif
#if defined(REFS_USES_LINUXGCC)
      wrtxt("\nTo complete installation of the new database:");
      wrtxt("\n  1. Copy (and optionally rename) [e-]<database>.sh");
      wrtxt("\n     script files to a bin directory included in");
      wrtxt("\n     PATH. Make it executable (e. g. with `chmod').");
      wrtxt("\n  2. Run the <database>.sh script.");
      wrtxt("\n  3. Create database and index files: [main-f r c].");
      wrtxt("\n  4. Import a minimal database (.arr file).");
      wrtxt("\nDetails are described in the documentation.\n");
#endif
   
  return 1;
}

int filename_ok(char * name)
{
   int i, laenge;
   
   const char charmenge[] = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz"
                     "1234567890_-";
   laenge=strlen(name);
   for (i=0;i<laenge;i++)
   {
      if ((strrchr(charmenge,name[i]))==NULL)
      {
         return 0;
      }
   }
   return 1;
}
