/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.hello;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.Component;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;

public class HelloPanel
extends IzPanel {
    private static final long serialVersionUID = 3257848774955905587L;

    public HelloPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        this(panel, parent, installData, new IzPanelLayout(log), resources);
    }

    public HelloPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, LayoutManager2 layout, Resources resources) {
        super(panel, parent, installData, layout, resources);
        String welcomeText = this.getString("HelloPanel.welcome1") + installData.getInfo().getAppName() + " " + installData.getInfo().getAppVersion() + this.getString("HelloPanel.welcome2");
        JLabel welcomeLabel = LabelFactory.create(welcomeText, (Icon)parent.getIcons().get("host"), 10);
        welcomeLabel.setName(GuiId.HELLO_PANEL_LABEL.id);
        this.add((Component)welcomeLabel, "nextLine");
        this.add(IzPanelLayout.createParagraphGap());
        ArrayList<Info.Author> authors = installData.getInfo().getAuthors();
        if (!authors.isEmpty()) {
            String authorText = this.getString("HelloPanel.authors");
            JLabel appAuthorsLabel = LabelFactory.create(authorText, (Icon)parent.getIcons().get("information"), 10);
            this.add((Component)appAuthorsLabel, "nextLine");
            for (Info.Author author : authors) {
                String email = author.getEmail() != null && author.getEmail().length() > 0 ? " <" + author.getEmail() + ">" : "";
                JLabel label = LabelFactory.create(" - " + author.getName() + email, (Icon)parent.getIcons().get("empty"), 10);
                this.add((Component)label, "nextLine");
            }
            this.add(IzPanelLayout.createParagraphGap());
        }
        if (installData.getInfo().getAppURL() != null) {
            String urlText = this.getString("HelloPanel.url") + installData.getInfo().getAppURL();
            JLabel appURLLabel = LabelFactory.create(urlText, (Icon)parent.getIcons().get("bookmark"), 10);
            this.add((Component)appURLLabel, "nextLine");
        }
        this.getLayoutHelper().completeLayout();
    }

    @Override
    public boolean isValidated() {
        return true;
    }
}

