/*
 * AddTalkGUI.java
 *
 * Created on 15. November 2005, 08:58
 */

/**
 *
 *  There is no reason why this class' name should be AddTalkGUI.
 *  This class implements a dialogue where the user can determine
 *  how the commands' or tags' syntax defining slides is.
 *
 * @author  Olle Nebendahl
 */
 
import javax.swing.*;

public class AddTalkGUI extends javax.swing.JDialog {

    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel titleLabel;
    private javax.swing.JLabel bodyLabel;
    
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JSpinner argCountSpinner;
    private javax.swing.JSpinner titleSpinner;
    private javax.swing.JSpinner bodySpinner;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextField  frameSyntaxTextField;
    
    private javax.swing.JTextField  frameBeginTagTextField;
    private javax.swing.JTextField  frameEndTagTextField;

    String frameSyntax;

    private boolean noTagVersion=false;
    
    public boolean approved=false;

    public AddTalkGUI(java.awt.Frame parent, boolean modal, boolean noTags) 
    {
        super(parent, modal);
        noTagVersion = noTags;
        initComponents();
    }

    public AddTalkGUI(javax.swing.JDialog parent, boolean modal, boolean noTags) 
    {
        super(parent, modal);
        noTagVersion = noTags;
        initComponents();
    }

    public AddTalkGUI(java.awt.Frame parent, boolean modal) 
    {
        super(parent, modal);
                
        initComponents();
    }
    
    Object[][] input = { { "\\","begin","{","slide","}"},
                         { "\\","end","{","slide","}"} }; ;
    String[] inputnames = { "a","a","c","d","e"};

        
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {
        
        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel2 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jRadioButton1 = new javax.swing.JRadioButton();
        jLabel2 = new javax.swing.JLabel();
        argCountSpinner = new javax.swing.JSpinner();
        argCountSpinner.setValue(1);
        titleLabel = new javax.swing.JLabel();
        titleSpinner = new javax.swing.JSpinner();
        bodyLabel = new javax.swing.JLabel();
        bodySpinner = new javax.swing.JSpinner();
        jPanel5 = new javax.swing.JPanel();
        jRadioButton2 = new javax.swing.JRadioButton();
        jLabel1 = new javax.swing.JLabel();
        jTable1 = new javax.swing.JTable();
        jButton1 = new javax.swing.JButton();
        
        frameBeginTagTextField= new javax.swing.JTextField();
        frameEndTagTextField= new javax.swing.JTextField();
        
        frameSyntaxTextField = new javax.swing.JTextField(frameSyntax);

        getContentPane().setLayout(new javax.swing.BoxLayout(getContentPane(), javax.swing.BoxLayout.Y_AXIS));

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.X_AXIS));

        jPanel4.setLayout(new java.awt.BorderLayout());

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.Y_AXIS));

        buttonGroup1.add(jRadioButton1);
        jRadioButton1.setText("frames in brackets");
        jRadioButton1.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jRadioButton1ItemStateChanged(evt);
            }
        });

        if(!noTagVersion)jPanel1.add(jRadioButton1);
        
        
        
        jPanel1.add(frameSyntaxTextField);
        frameSyntaxTextField.addKeyListener(new java.awt.event.KeyAdapter()
        {
            public void keyReleased(java.awt.event.KeyEvent evt)
            {
                frameSyntaxTextFieldKeyReleased(evt);
            }
        });

        jLabel2.setText("\\"+frameSyntax+"{...}");
        
        
        
        jPanel1.add(jLabel2);

        argCountSpinner.setEnabled(false);
        argCountSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                argCountSpinnerStateChanged(evt);
            }
        });
        

        jPanel1.add(argCountSpinner);

        titleLabel.setText("title:");
        jPanel1.add(titleLabel);

        titleSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                titleSpinnerStateChanged(evt);
            }
        });

        jPanel1.add(titleSpinner);

        bodyLabel.setText("body:");
        jPanel1.add(bodyLabel);

        bodySpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                bodySpinnerStateChanged(evt);
            }
        });

        jPanel1.add(bodySpinner);

        jPanel4.add(jPanel1, java.awt.BorderLayout.WEST);

        jPanel2.add(jPanel4);

        jPanel5.setLayout(new javax.swing.BoxLayout(jPanel5, javax.swing.BoxLayout.Y_AXIS));

        buttonGroup1.add(jRadioButton2);
        jRadioButton2.setText("frames within tags");
        jRadioButton2.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jRadioButton2ItemStateChanged(evt);
            }
        });

        jPanel5.add(jRadioButton2);

        jLabel1.setText("specify tags");
        jPanel5.add(jLabel1);

        /*
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            input,inputnames
        ));*/
        
        /*jTable1.setModel(new FrameTagTableModel());
        
        jTable1.setEnabled(false);
        jPanel5.add(jTable1);
        */
        
        frameBeginTagTextField.setText("\\begin{frame}");
        jPanel5.add(frameBeginTagTextField);
        frameEndTagTextField.setText("\\end{frame}");
        jPanel5.add(frameEndTagTextField);

        jPanel2.add(jPanel5);

        getContentPane().add(jPanel2);
        
        if(noTagVersion)jPanel5.removeAll();

        jButton1.setText("scan file");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        getContentPane().add(jButton1);

        if(noTagVersion)jRadioButton1.doClick();
        //bodySpinner.setValue(1);
        setFrameSyntax(Constants.prefCommand);
        setFrameSyntax(Constants.prefTag);
        jRadioButton2.setSelected(Constants.prefTagOrCommand);
        jRadioButton1.setSelected(!Constants.prefTagOrCommand);        
        pack();
    }
    
    public void frameSyntaxTextFieldKeyReleased(java.awt.event.KeyEvent evt)    
    {
        setFrameSyntax(frameSyntaxTextField.getText());
        System.out.println(evt.getKeyCode());
    }
    
    public void hideTargetSpinners()
    {
        jPanel1.remove(bodySpinner);
        jPanel1.remove(bodyLabel);
        jPanel1.remove(titleSpinner);
        jPanel1.remove(titleLabel);
    }
    
    public void setScanButtontext(String s) { jButton1.setText(s); }
    
    public void setFrameSyntax(String syntax)
    {
        frameSyntax=syntax.trim();
        String s = new String("\\"+frameSyntax);        
        int i = ((Integer)argCountSpinner.getValue()).intValue();
        while(i>0)
        {
            s+="{...}";
            i--;
        }
        jLabel2.setText(s);
        frameSyntaxTextField.setText(frameSyntax);
        pack();
    }
    
    public void setFrameSyntax(CommandRepresentation syntax)
    {
        argCountSpinner.setValue(syntax.i);
        titleSpinner.setValue(syntax.titleTarget);
        bodySpinner.setValue(syntax.bodyTarget);
        setFrameSyntax(syntax.s.substring(1));
    }
    
    public void setFrameSyntax(TagRepresentation syntax)
    {
        frameBeginTagTextField.setText(syntax.getStartTag());
        frameEndTagTextField.setText(syntax.getStopTag());
    }
    
    
    public CommandRepresentation getCommandRepresentation()
    {
        return new CommandRepresentation(((Integer)argCountSpinner.getValue()).intValue(),"\\"+frameSyntax,
                                         ((Integer)titleSpinner.getValue()).intValue(),
                                         ((Integer)bodySpinner.getValue()).intValue()  );
    }
    
    public TagRepresentation getTagRepresentation()
    {
        return new TagRepresentation(frameBeginTagTextField.getText(),frameEndTagTextField.getText());
    }
    
    final static int TAG = 1;
    final static int COMMAND = 2;
    final static int NOT_APPROVED = 0;
    
    public int getChoice()
    {
        if(jRadioButton1.isSelected()==jRadioButton2.isSelected())return NOT_APPROVED;
        if(jRadioButton2.isSelected())return TAG; else return COMMAND;
    }

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) 
    {
        
        if(jRadioButton1.isSelected()!=jRadioButton2.isSelected())
        {
            approved=true;
            setVisible(false);
        }
        else
        {
            Object[] options = { "OK","cancel scan" };
            int n = JOptionPane.showOptionDialog(this,"Please, specify how slides are definded.","Note:",JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE,null,options,options[0]);
            if(n==1)
            {
                approved=false;
                setVisible(false);
            }
        }
        Constants.prefTag=getTagRepresentation();
        Constants.prefCommand=getCommandRepresentation();
        Constants.prefTagOrCommand=jRadioButton2.isSelected();
        Constants.savePreferences();    
    }

    private void bodySpinnerStateChanged(javax.swing.event.ChangeEvent evt) 
    {
       int i = ((Integer)argCountSpinner.getValue()).intValue();
       int j = ((Integer)bodySpinner.getValue()).intValue();
       if(j<1)bodySpinner.setValue(1); 
       if(j>i)bodySpinner.setValue(i);
    }

    private void titleSpinnerStateChanged(javax.swing.event.ChangeEvent evt) 
    {
       int i = ((Integer)argCountSpinner.getValue()).intValue();
       int j = ((Integer)titleSpinner.getValue()).intValue();
       if(j<0)titleSpinner.setValue(0); 
       if(j>i)titleSpinner.setValue(i);
    }

    private void argCountSpinnerStateChanged(javax.swing.event.ChangeEvent evt) 
    {
        String s="\\"+frameSyntax;
        int i = ((Integer)argCountSpinner.getValue()).intValue();
        int titleValue = ((Integer)titleSpinner.getValue()).intValue();
        int k = ((Integer)bodySpinner.getValue()).intValue();
        if(i<1)
        {
            argCountSpinner.setValue(3);
            i=3;
        } 
        if(titleValue<1)titleSpinner.setValue(0); 
        if(titleValue>i)titleSpinner.setValue(i);
        if(k<1)bodySpinner.setValue(1); 
        if(k>i)bodySpinner.setValue(i);
        
        while(i>0)
        {
            s+="{...}";
            i--;
        }
        jLabel2.setText(s);
        pack();
    }

    private void jRadioButton1ItemStateChanged(java.awt.event.ItemEvent evt) 
    {
        if(Constants.DBG)System.out.println("jRadioButton1ItemStateChanged jRadioButton1.isSelected()"+jRadioButton1.isSelected());
        argCountSpinner.setEnabled(jRadioButton1.isSelected());
    }

    private void jRadioButton2ItemStateChanged(java.awt.event.ItemEvent evt) 
    {
        if(Constants.DBG)System.out.println("jRadioButton1ItemStateChanged jRadioButton2.isSelected()"+jRadioButton2.isSelected());
        
        jTable1.setEnabled(jRadioButton2.isSelected());
    }

    public void setVisible(boolean b)
    {
        if(!b)
        {
            getLocation(Constants.prefAddTalkGUICoordinates);
            Constants.savePreferences();
            Logger.log("saved position");
        }
        else setLocation(Constants.prefAddTalkGUICoordinates);
        super.setVisible(b);
    }
    
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) 
    {
        final AddTalkGUI ag=new AddTalkGUI(null, true);
        ag.setVisible(true);
        if(ag.approved)
        {
            if(ag.getChoice()==COMMAND)System.out.println(ag.getCommandRepresentation());
            if(ag.getChoice()==TAG)System.out.println(ag.getTagRepresentation());
        }

        
        
    }
}


class FrameTagTableModel extends javax.swing.table.AbstractTableModel 
{
    String[] columnNames = {"backslash",
                        "begin",
                        "bracket",
                        "name",
                        "bracket"};

    Object[][] rowData = {
        {"\\", "begin",
        "{", "frame", "}"},
        {"\\", "end",
        "{", "frame", "}"}
    };    
    
    FrameTagTableModel()
    {
        super();
    }
    
    FrameTagTableModel(String[] cn, Object[][] data)
    {
        columnNames=cn;
        rowData = data;
    }

    FrameTagTableModel(String[] cn, Object[] data)
    {
        columnNames=cn;
//        rowData[0] = new Object[];
        rowData[0] = data;
    }
    
    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return rowData.length;
    }

    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        return rowData[row][col];
    }

    public Class getColumnClass(int c) {
        return getValueAt(0, c).getClass();
    }

    /*
     * Don't need to implement this method unless your table's
     * editable.
     */
    public boolean isCellEditable(int row, int col) {
        //Note that the data/cell address is constant,
        //no matter where the cell appears onscreen.
        if (col == 3) {
            return true;
        } else {
            return false;
        }
    }

    /*
     * Don't need to implement this method unless your table's
     * data can change.
     */
    public void setValueAt(Object value, int row, int col) {
        rowData[row][col] = value;
        fireTableCellUpdated(row, col);
    };
}


        /*AddTalkGUI ag=new AddTalkGUI(null, true);
        javax.swing.JFileChooser fc = new javax.swing.JFileChooser();
        int returnVal = fc.showOpenDialog(ag);
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                ag.setVisible(true);
            }
        });*/
        /*
        if (returnVal == javax.swing.JFileChooser.APPROVE_OPTION) 
        {
            java.io.File file = fc.getSelectedFile();
            String fileName=file.getName();
            ag.setVisible(true);
            if(ag.approved)
            {
                if(ag.jRadioButton1.isSelected())
                { //PTD
                    try 
                    {
                        PTD wd = new PTD(fileName);
                        wd.showHappen();
                        wd.cleanup();
                    } catch(Exception e) {e.printStackTrace();        }

                }
            }
            
        }*/
