{$IFDEF WINDOWS}
{$N-,V-,W-,G+,C MOVEABLE DISCARDABLE}
{$ELSE}
{$N-,E-,V-,O+,F+}
{$ENDIF}

Unit bibReadT;

Interface

Uses
{$IFDEF WINDOWS}
  wbibdisp, wbibgui, WinTypes, WinProcs, WObjects, rc_id,
{$ELSE}
  objects,bibwindo, BibCrt, bibdisp, bibedit,
{$ENDIF}
  bibstrg, bibtext, bibvars, bibfile, bibutil, bib8bit, bibPchec,
  rc_strng, bibtmplt;


procedure GetTibEntry(Entry: EntryRecPtr; InStrm: PStream; toentry: Word;
                      FileFormat: byte; match: string;
                      Pattern: PatRecPtr; var ok: boolean);

Implementation


procedure GetTibEntry(Entry: EntryRecPtr; InStrm: PStream; toentry: Word;
                      FileFormat: byte; match: string;
                      Pattern: PatRecPtr; var ok: boolean);
type
  AddStringType = string[32];
var
  line, tmp : string;
  j,k,lmatch,count : integer;
  i,pl: word;
  Jind,Vind,TYind,Iind,Tind,Bind,Kind,Aind,Eind,Yind: byte;
  enough,leave,fitstart,fitend,BeginBrace,foundit,ReadBS,ANewLine: boolean;
  RegExp,CaseSen: boolean;
  ifld : byte;
  OldPlace: longint;

function EOF_bib(S: PStream): boolean;
begin
  if S=Nil then EOF_bib:=eof(bib)
  else EOF_Bib:=(S^.Status<>stok) or (S^.GetPos>=S^.GetSize);
end;

procedure Skip;
var
  ch: char;
begin
  if InStrm=Nil then SkipOneLine(bib,UnixBib)
  else begin
    ch:=#0;
    if not ReachedEol then
      while (ch<>#10) and (not eof_bib(InStrm)) do InStrm^.read(ch,1);
    ReachedEol:=false;
  end;
end;            { Skip }

procedure RdString(var line: string);
var
  ch: char;
  i: integer;
begin
  if InStrm=Nil then ReadString(bib,line,UnixBib)
  else begin
    if InStrm^.Status<>stOK then Exit;
    InStrm^.read(ch,1); if InStrm^.Status<>stOK then Exit;
    i:=1;
    while (ch<>#10) and (not eof_bib(InStrm)) and (i<=255) do
    begin
      line[i]:=ch; inc(i); 
      if i<=255 then InStrm^.read(ch,1);
      if InStrm^.Status<>stOK then Exit;
    end;
    i:=i-1;
    if (i>0) and (line[i]=#13) then line[0]:=char(i-1)
    else line[0]:=char(i);
    ReachedEol:=(ch=#10);
  end;
end;              { RdString }

procedure GetLine(var line: string; rln: boolean);
var
  cont: boolean;
begin
  WinYield;
  line:=#0;
  if not Eof_bib(InStrm) then
  begin
    Cont:=true;
    if rln or ReachedEol then
    begin
      Cont:=false;
      if not AtStartOfFile then Skip;
      ANewLine:=true;
    end else ANewLine:=AtStartOfFile;
    RdString(line); if not cont then ChrDelL(line,' ');
    AtStartOfFile:=false;
{    message('"'+line+'" at '+num2str(TextFilePos(bib)));    }
  end;
end;                                 { GetLine }

procedure ReadEntry(entry: EntryRecPtr);
var
  line,tmp,tmp1,Labels: string;
  fld: char;
  i,iii,j,k,pl,CurMaxBig,Blength : word;
  Buffer: BigTypePtr;
  CurrentBuffer,Ind: Byte;
  SBuffer: array[1..256] of char;
  MadeLabel: string[1];
  DoIt,fchanged,retain,BareQuote,Ok1: Boolean;

procedure AddTo(where: string; AddString: AddStringType);
var
  i,j,ifld: word;
  add: string[5];
begin
  StrLwr(where);
  with Entry^ do
  begin
    ifld:=0;
    for i:=1 to FieldLast do if TypeField^[i]=where then ifld:=i;
    if ifld=0 then
    begin
      if fieldlast>=MaxField then Exit;
      Inc(fieldlast); inc(nentry);
      ifld:=fieldlast;
      with FieldParams^[ifld] do
      begin
        authorlike:=false; Capitalize:=false;
        ProtectCase:=false; ProtectCap:=false; Numeric:=false;
        if AltName<>Nil then DisposeStr(AltName); AltName:=Nil;
      end;
      index[ifld]:=nentry;
      field[nentry]:=where;
      typefield^[ifld]:=field[nentry];
      Content[nentry]:='';
      DumpFields[ifld]:=DumpUndecFields;
    end else if index[ifld]=0 then
    begin
      inc(nentry); index[ifld]:=nentry; Content[nentry]:='';
      field[nentry]:=where;
    end;
    add:=''; if Content[index[ifld]]<>'' then add:=AddString;
    if (BigIndex[ifld]=0) and
      (length(content[index[ifld]])+blength+length(add)>255)
      and (CurMaxBig>255) then
    begin
      if add<>'' then
      begin
        j:=length(content[index[ifld]])+length(add);
        for i:=Imin(MaxBig,Blength+j) downto j do
          Buffer^[i]:=Buffer^[i-j];
        Move(content[index[ifld]][1],Buffer^[1],length(content[index[ifld]]));
        Move(add[1],Buffer^[length(content[index[ifld]])+1],length(add));
        Blength:=Blength+j;
      end;
      Entry^.BigFree[CurrentBuffer]:=false;
      BigIndex[ifld]:=CurrentBuffer;
      Blen[CurrentBuffer]:=Blength;
      BigIndex[ifld]:=CurrentBuffer;
      Move(Buffer^[1],content[index[ifld]][1],255);
      content[index[ifld]][0]:=#255;
    end else if BigIndex[ifld]>0 then
    begin
      j:= Imin(length(add),MaxBig-Blen[BigIndex[ifld]]);
      if j>0 then Move(add[1],Big[BigIndex[ifld]]^[Blen[BigIndex[ifld]]],j);
      Blen[BigIndex[ifld]]:=Blen[BigIndex[ifld]]+j;
      j:= Imin(blength,MaxBig-Blen[BigIndex[ifld]]);
      if j>0 then Move(Buffer^[1],Big[BigIndex[ifld]]^[Blen[BigIndex[ifld]]],j);
      Blen[BigIndex[ifld]]:=Blen[BigIndex[ifld]]+j;
      j:=Imin(Blen[BigIndex[ifld]],255);
      Move(Buffer^[1],content[index[ifld]][1],j);
      content[index[ifld]][0]:=chr(j);
    end else
    begin
      content[index[ifld]]:=content[index[ifld]]+add;
      for i:=1 to Imin(blength,255-length(content[index[ifld]])) do
        content[index[ifld]]:=content[index[ifld]]+Buffer^[i];
    end;
  end;
end;                                 { AddTo }

procedure PutInto(where: string);
var
  i,ifld: byte;
begin
  StrLwr(where);
  with Entry^ do
  begin
    ifld:=0;
    for i:=1 to DefFieldLast do if TypeField^[i]=where then ifld:=i;
    if (ifld>0) and (Index[ifld]>0) then Exit;
    inc(nentry);
    Field[nentry]:=where;
    if ifld>0 then index[ifld]:=nentry
    else begin
      if FieldLast>=MaxField then Exit;
      Inc(fieldlast);
      ifld:=fieldlast;
      with FieldParams^[ifld] do
      begin
        authorlike:=false; Capitalize:=false;
        ProtectCase:=false; ProtectCap:=false; Numeric:=false;
        if AltName<>Nil then DisposeStr(AltName); AltName:=Nil;
      end;
      index[ifld]:=nentry;
      typefield^[ifld]:=field[nentry];
      DumpFields[ifld]:=DumpUndecFields;
    end;
    Content[nentry]:='';
    if Blength>255 then
    begin
      Move(Buffer^[1],Content[nentry][1],255);
      Content[nentry][0]:=#255;
      Entry^.BigFree[CurrentBuffer]:=false;
      BigIndex[ifld]:=CurrentBuffer;
      Blen[CurrentBuffer]:=Blength;
    end else
    begin
      Move(Buffer^[1],Content[nentry][1],Blength);
      Content[nentry][0]:=Chr(Blength);
      if RetainNullFields and (Content[nentry]='') then
        Content[nentry]:='~';
    end;
  end;
end;                                    { PutInto }

Procedure Macros(S: BigTypePtr; var Slen: Word; MaxBig: word);
const
  MaxMacroLength = 64;
var
  i,j,nbr: LongInt;
  dollar,ddollar,IsMacro,FirstTime: Boolean;
begin
  if (FileFormat<>TiBFormat) or (TiBMacros=NotImpOrExp)
     or (TibMacros=ExpOnly) or (Slen<3) then Exit;
  FirstTime:=true;
  i:=1;
  repeat
    nbr:=0; dollar:=false; ddollar:=false; IsMacro:=false;
    while (not IsMacro) and (i<Slen) do
    begin
      if (S^[i]='$') and ((i=1) or (S^[i-1]<>'\')) then
      begin
        if (i<Slen) and (S^[i+1]='$') then
        begin
          ddollar:=not ddollar; inc(i);
        end else dollar:=not dollar;
      end else if S^[i]=lbrace then inc(nbr)
      else if S^[i]=lbrace then dec(nbr)
      else if (S^[i]='|') and not (dollar or ddollar)
              and (nbr=0) then IsMacro:=true;
      inc(i);
    end;
    if IsMacro then
    begin
      dec(i);
      j:=i+1;
      while (j<=Slen) and (S^[j]<>'|') do inc(j);
      if (j>Slen) or (j-i>MaxMacroLength) then i:=j+1
      else begin
        if FirstTime then
        begin
          Sinsert(S,Slen,'@',1,MaxBig); inc(i); inc(j);
          if i>2 then
          begin
            Sinsert(S,Slen,lbrace,2,MaxBig); inc(i); inc(j);
          end;
          FirstTime:=false;
        end;
        Sdelete(S,Slen,j,1);
        Sinsert(S,Slen,'#'+lbrace,j,MaxBig);
        Sdelete(S,Slen,i,1);
        if i>2 then
        begin
          Sinsert(S,Slen,rbrace+'#',i,MaxBig);
          i:=j+3;
        end else i:=j+2;
      end;
    end;
    if nbr<0 then nbr:=0;
  until (i>=Slen-2) or (not IsMacro);
  if not FirstTime then
  begin
    while (Slen>0) and (S^[Slen]=' ') do Dec(Slen);
    if (Slen>=2) and (S^[Slen]=lbrace) and (S^[Slen-1]='#') then
      Slen:=Slen-2
    else begin
      if Slen<MaxBig then inc(Slen);
      S^[slen]:=rbrace;
    end;
  end;
end;                                    { Macros }

begin                                   { ReadEntry }
  line:=LastReadLine^;
  MadeLabel:=''; Labels:='';
  if FileFormat=TibFormat then Labels:=TibLabels
  else if FileFormat=ReferFormat then Labels:=ReferLabels;
  with Entry^ do
  begin
    nentry:=0; EntryType:='';
    for i:=1 to maxfield+1 do
    begin
      index[i]:=0;
      BigIndex[i]:=0;
    end;
    for i:=1 to MaxNumberBig do
    begin
      BigFree[i]:=true; Blen[i]:=0;
    end;
    repeat                               { Read fields }
      fld:=line[2]; Delete(line,1,3); ChrDelL(line,' ');
      
      CurrentBuffer:=FindBigFree(Entry,false);
      if CurrentBuffer=0 then                  { All big fields are full }
      begin
        Buffer:=@SBuffer[1]; CurMaxBig:=255;
      end else
      begin
        Buffer:=@Entry^.Big[CurrentBuffer]^[1]; CurMaxBig:=MaxBig;
      end;
      Blength:=0;

      tmp:=line; ChrDelR(tmp,' ');
      if tmp<>'' then Move(tmp[1],Buffer^[1],length(tmp));
      Blength:=length(tmp);
      GetLine(line,false);
      while (line<>#0) and (line<>'') and (line[1]<>'%') do
      begin
        if ANewLine and (Blength>0) and (Blength<CurMaxBig)
           and (Buffer^[Blength]<>' ') then
        begin
          inc(Blength); Buffer^[Blength]:=' '; Buffer^[Blength+1]:=#0;
        end;
        if Blength<CurMaxBig then
        begin
          tmp:=line; ChrDelR(tmp,' ');
          Move(tmp[1],Buffer^[Blength+1],Imin(length(tmp),CurMaxBig-Blength));
          Blength:=Blength+Imin(length(tmp),CurMaxBig-Blength);
        end;      
        GetLine(line,false);
      end;
      Macros(Buffer,Blength,CurMaxBig);
      if not OkField(Buffer^,Blength,3,'','',BareQuote) then
      begin
        if AskIfRC(Str_UnbalancedField,'','','Edit','Discard') then
        begin
{$IFDEF WINDOWS}
          if Application^.ExecDialog(New(PEditAFieldDlg,
            Init(MainW,PChar(rc_EditTibFieldDlg),Nil,true,Buffer,@Blength,CurMaxBig)
              ))<>id_ok then Blength:=0;
{$ELSE}
          MakeWindow(3,2,ScrLen-3,ScrWidth-2,EditNorm,EditNorm,2,RNorm,0,0);
          repeat
            ReadBig('Data: ',Buffer^,Blength,
                 3,2,ScrLen-3,ScrWidth-2,[#0..#31,#255]-[#21],fchanged,retain,
                 CurMaxBig,false,CaseSen,RegExp,Nil,false,false,'');
            Ok1:=OkField(Buffer^,Blength,3,
                 StringRC(Str_UnbalancedBracesInText,''),
                 StringRC(Str_IllegalMacroSyntax,''), BareQuote);
          until Ok1;
          RemoveWindow;
{$ENDIF}
        end else Blength:=0;
      end;
      
                           { Finished reading a field into the buffer }
      { Joint }
      if fld='A' then      AddTo('author',' and ')
      else if fld='B' then PutInto('booktitle')
      else if fld='C' then PutInto('address')
      else if fld='D' then PutInto('year')
      else if fld='E' then AddTo('editor',' and ')
      else if fld='G' then PutInto('ntis')
      else if fld='I' then PutInto('publisher')
      else if fld='J' then PutInto('journal')
      else if fld='K' then AddTo('keywords',', ')
      else if fld='N' then PutInto('number')
      else if fld='O' then PutInto('note')
      else if fld='P' then PutInto('pages')
      else if fld='R' then PutInto('type')
      else if fld='S' then PutInto('series')
      else if fld='T' then PutInto('title')
      else if fld='V' then PutInto('volume');

      if Pos(fld,Labels)>0 then   { A possible "label" field }
      begin
        DoIt:=true;
        if name<>'' then
          for i:=1 to length(MadeLabel) do
            if Pos(fld,Labels)>Pos(MadeLabel[i],Labels) then DoIt:=false;
        if DoIt then
        begin
          j:=Blength; if j>sizeof(name)-1 then j:=sizeof(name)-1;
          Move(Buffer^[1],tmp[1],j); tmp[0]:=Chr(j);
          ChrDelL(tmp,' '); ChrDelR(tmp,' ');
          j:=Pos(' ',tmp); if j>0 then Delete(tmp,j,length(tmp)-j+1);
          if tmp<>'' then
          begin
            name:=tmp;
            MadeLabel:=fld;
          end;
        end;
      end;
      if FileFormat=TibFormat then
      begin
        if fld='M' then      PutInto('mathrevnum')
        else if fld='o' then
        begin
          tmp:=''; i:=1;
          while (i<=Blength) do
          begin
            if (i=Blength) or (Buffer^[i] in [' ',#9,'.',',',';']) then
            begin
              if not (Buffer^[i] in [' ',#9,'.',',',';']) then
              begin
                tmp:=tmp+Buffer^[i]; inc(i);
              end;
              StrLwr(tmp);
              if tmp='edition' then
              begin
                k:=length('edition'); if (i-k-1>0) and (Buffer^[i-k-1]=' ') then
                  inc(k);
                for j:=i to Blength do Buffer^[j-k]:=Buffer^[j];
                Blength:=Blength-k;
                i:=i-k;
              end;
              tmp:='';
            end else tmp:=tmp+Buffer^[i];
            inc(i);
          end;
          PutInto('edition')
        end else if fld='\' then
        begin
          i:=1;
          repeat
            while (i<=Blength-9) and (Buffer^[i]<>'\') do inc(i);
            if Buffer^[i]='\' then
            begin
              inc(i); j:=i;
              while (i<=Blength) and (Buffer^[i] in ['a'..'z']) do inc(i);
              if i-j<25 then
              begin
                Move(Buffer^[j],tmp[1],i-j); tmp[0]:=chr(i-j);
                if tmp='journalarticleformat' then entrytype:='journal'
                else if tmp='conferencereportformat' then entrytype:='conference'
                else if tmp='bookarticleformat' then entrytype:='inbook'
                else if tmp='technicalreportformat' then entrytype:='techreport'
                else if tmp='bookformat' then entrytype:='book'
                else if tmp='otherformat' then entrytype:='misc';
              end;
            end;
          until (i>=Blength-9);
        end;           
      end else if FileFormat=ReferFormat then
      begin
        if fld='M' then      PutInto('belllabsnum')
        else if fld='X' then PutInto('abstract')
      end;
    until Eof_bib(InStrm) or (line='');
    LastReadLine^:=Line;
                                   { Post Process }
    LastField:=FieldLast;
    for i:=1 to FieldLast do
    if index[i]>0 then
    begin
      if Prog8Bit then SConv28Bit(Content[index[i]],FieldParams^[i].Authorlike)
      else if Prog7Bit then SConv27Bit(Content[index[i]],FieldParams^[i].Authorlike);
      if BigIndex[i]>0 then
      begin
        if Prog8Bit then
          Conv28Bit(Big[BigIndex[i]]^,Blen[BigIndex[i]],FieldParams^[i].Authorlike)
        else if Prog7Bit then
          Conv27Bit(Big[BigIndex[i]]^,Blen[BigIndex[i]],FieldParams^[i].Authorlike,MaxBig);
      end;
    end;
                                     { Try to determine type }
    if entrytype='' then
    begin
      if (index[Jind]>0) and (index[Vind]>0) then entrytype:='article'
      else if (index[Jind]>0) and (index[Vind]=0) then entrytype:='conference'
      else if (index[TYind]>0) then entrytype:='techreport'
      else if (index[Iind]>0) and (index[Jind]=0) and (index[TYind]=0) then
           entrytype:='book'
      else if (index[Tind]>0) and (index[Bind]>0) then entrytype:='inbook'
      else if (Index[Aind]=0) and (index[Eind]>0) then entrytype:='proceedings';
    end;
    if entrytype='techreport' then
    begin
      if StrPosLI(content[index[TYind]],'phd')>0 then entrytype:='phdthesis'
      else if StrPosLI(content[index[TYind]],'msc')
           + StrPosLI(content[index[TYind]],'master')>0 then
             entrytype:='mastersthesis'
      else if StrPosLI(content[index[TYind]],'unpublished')>0 then
             entrytype:='unpublished'
    end;
    if entrytype='' then entrytype:='misc';
    if (entrytype='conference') and (index[Jind]>0) and (index[Bind]=0) then
    begin
      field[index[Jind]]:='booktitle';
      index[Bind]:=index[Jind]; index[Jind]:=0;
      BigIndex[Bind]:=BigIndex[Jind]; BigIndex[Jind]:=0;
    end;
    if (index[Iind]>0) then
    begin
      tmp:='';
      if entrytype='techreport' then tmp:='institution'
      else if entrytype='proceedings' then tmp:='organization'
      else if entrytype='phdthesis' then tmp:='school'
      else if entrytype='mastersthesis' then tmp:='school'
      else if entrytype='misc' then tmp:='howpublished'
      else if entrytype='manual' then tmp:='organization'
      else if entrytype='booklet' then tmp:='howpublished';
      if tmp<>'' then
      begin
        j:=0;
        for i:=1 to FieldLast do if tmp=typefield^[i] then j:=i;
        if j>0 then
        begin
          index[j]:=index[Iind];
          field[index[Iind]]:=tmp;
          BigIndex[j]:=BigIndex[Iind];
          index[Iind]:=0; BigIndex[Iind]:=0;
        end;
      end;
    end;

    AutoLabel(Entry,LabelTemplate^,entry^.name);
    AutoLabel(Entry,DefNullLabels^,entry^.name);

    LastField:=FieldLast;
    LastReadLine^:=Line;
    { ending:=TextFilePos(bib); }
    ending:=-1;
  end;
end;                                       { ReadEntry }

procedure GoForward(var Entry: EntryRecPtr; Pattern: PatRecPtr; var ok: boolean);
var
  orig : Word;
  count: integer;
  eofbib,leave,FindOK : boolean;
  atplace: longint;

procedure FindStart(var AtPlace: longint; var ok: boolean);
var
  tmp: string;
begin
  ok:=true;
  tmp:=LastReadLine^; ChrDelR(tmp,' ');
  while (not Eof_bib(InStrm)) and ((tmp='') or (tmp[1]<>'%')) do
  begin
    GetLine(LastReadLine^,true); tmp:=LastReadLine^; ChrDelR(tmp,' ');
  end;
  if Eof_bib(InStrm) then
  begin
    ok:=false; Exit;
  end;
  if InStrm=Nil then
  begin
    atplace:=TextFilePos(bib)-(length(LastReadline^)+1);
    if UnixBib and ReachedEol and (atplace>0) then atplace:=atplace-1;
  end else AtPlace:=InStrm^.GetPos-(length(LastReadline^)+1);
end;                     { FindStart }

begin                                 { GoForward }
  if ok then
  begin
    count:=0;
    if entry^.realnum>0 then orig:=entry^.realnum
    else begin
      orig:=1;
      count:=1;
    end;
    entry^.name:='';
    repeat
      FindStart(atplace,FindOK);
      if entry^.realnum=$ffff then ErrorMessageRC(Str_TooManyEntries,'');
      Inc(entry^.realnum);
      entry^.beginning:=atplace;
      if orig=entry^.realnum then count:=count-1;
      eofbib:=Eof_bib(InStrm);
      if (FindOK) then
      begin
        ReadEntry(Entry);
        if entry^.name='' then
        begin
          ok:=false;
          Dec(entry^.realnum);
        end else if (Pattern<>Nil) and (Pattern^.on) then
          PatternCheck(entry,pattern,ok,true)
        else ok:=true;
      end else ok:=false;
      if ok then entry^.entrynum:=entry^.entrynum+1;
    until (ok) or (Eofbib);
    if Eofbib and (not ok) then
    begin
      ResetBib(Entry);
      repeat
        FindStart(atplace,FindOK);
        entry^.realnum:=entry^.realnum+1;
        entry^.beginning:=atplace;
        if orig=entry^.realnum then count:=count-1;
        eofbib:=Eof_bib(InStrm);
        if (FindOK) then
        begin
          ReadEntry(Entry);
          if entry^.name='' then
          begin
            ok:=false;
            Dec(entry^.realnum);
          end else if (Pattern<>Nil) and (Pattern^.on) then
            PatternCheck(entry,pattern,ok,true)
          else ok:=true;
        end else ok:=false;
      until (ok) or EofBib or (count<0);
      if ok then entry^.entrynum:=entry^.entrynum+1;
    end;
    if not ok then ResetBib(entry);
  end;
end;                                    { GoForward }

begin                                   { GetTibEntry }
  Jind:=0; Vind:=0; TYind:=0; Iind:=0; Tind:=0; Bind:=0; Kind:=0;
  Aind:=0; Eind:=0; YInd:=0;
  for i:=1 to FieldLast do
  begin
    if TypeField^[i]='journal' then Jind:=i
    else if TypeField^[i]='volume' then Vind:=i
    else if TypeField^[i]='type' then TYind:=i
    else if TypeField^[i]='publisher' then Iind:=i
    else if TypeField^[i]='title' then Tind:=i
    else if TypeField^[i]='booktitle' then Bind:=i
    else if TypeField^[i]='keywords' then Kind:=i
    else if TypeField^[i]='author' then Aind:=i
    else if TypeField^[i]='year' then Yind:=i
    else if TypeField^[i]='editor' then Eind:=i;
  end;
  pl:=entry^.entrynum;
  ok:=true; line:=''; foundit:=false;
  if toentry>pl then
  begin
    i:=entry^.entrynum;
    while (entry^.entrynum<toentry) and (entry^.entrynum>=i) and ok do
    begin
      OldPlace:=entry^.beginning;
      GoForward(Entry,pattern,ok);
      Inc(i);
    end;
  end else if toentry<pl then
  begin
    pl:=0;
    i:=entry^.entrynum;
    ResetBib(Entry);
    while (entry^.entrynum<toentry) and (entry^.entrynum>=i) and ok do
    begin
      OldPlace:=entry^.beginning;
      GoForward(Entry,pattern,ok); Inc(i);
    end;
  end;
  foundit:=ok;
  if not foundit then ok:=false;
  if entry^.name='' then ok:=false;
  if (not ok) or (entry^.entrynum=0) then
  with Entry^ do
  begin
    entrynum:=0; realnum:=0; nentry:=0; entrytype:=''; name:='';
  end;
  {
  message('Entry "'+entry^.name+'" begins at '+num2str(entry^.beginning)
          +' and ends at '+num2str(entry^.ending));
  }
end;                       { GetTibEntry }


end.
