/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.Scrollable;

class DviPage
extends JLabel
implements Printable,
Scrollable {
    private DviFile m_File = null;
    private DviStack m_Stack = null;
    private int[] m_Counters = new int[10];
    private int m_Font = -1;
    private DviCommand[] m_Commands = null;
    private int m_CurrentPage = -1;
    private double m_ViewScale = 2.0;
    private boolean m_ViewFlag = true;
    private static final int kFontArrayLength = 128;
    public static final double kScale = 0.1;
    public static final int kPrintCurrentPage = 16;
    public static final int kPrintAllPagesFrontToBack = 17;
    public static final int kPrintAllPagesBackToFront = 18;
    private int m_PrintOption = 16;
    public Graphics2D m_g = null;
    private int[] m_FontCode = null;
    private DviFont[] m_FontVal = null;
    private Hashtable m_Fonts = new Hashtable();
    private DviFont m_CurrentFont = null;

    public DviPage(DviFile dviFile) {
        this.m_File = dviFile;
        this.m_Stack = new DviStack();
        int n = 0;
        while (n < 10) {
            this.m_Counters[n] = 0;
            ++n;
        }
        Dimension dimension = this.m_File.getPaperSize();
        Dimension dimension2 = new Dimension((int)(dimension.getWidth() * this.m_ViewScale), (int)(dimension.getHeight() * this.m_ViewScale));
        this.setPreferredSize(dimension2);
        this.setSize(dimension2);
        this.setVisible(true);
        this.setCommandTable();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        switch (this.m_PrintOption) {
            case 0: 
            case 1: 
            case 12: 
            case 14: {
                n2 = 2 * n;
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 15: {
                n2 = this.m_File.getLastPageNumber() - 2 * n;
                if ((n2 & 1) == 0) break;
                --n2;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                n2 = 2 * n + 1;
                if (n2 != this.m_File.getLastPageNumber() + 1) break;
                return 0;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                n2 = this.m_File.getLastPageNumber() + 1 - 2 * n;
                if ((n2 & 1) == 0) {
                    --n2;
                }
                if (n2 != this.m_File.getLastPageNumber() + 1) break;
                return 0;
            }
            case 16: {
                if (n != 0) {
                    return 1;
                }
                n2 = this.m_CurrentPage;
                break;
            }
            case 17: {
                n2 = n;
                break;
            }
            case 18: {
                n2 = this.m_File.getLastPageNumber() - n;
                break;
            }
            default: {
                return 1;
            }
        }
        if (0 <= n2 && n2 <= this.m_File.getLastPageNumber()) {
            System.out.println("Print method called.  Page=" + n + ", DVI Page = " + n2);
            this.m_g = (Graphics2D)graphics;
            AffineTransform affineTransform = this.m_g.getTransform();
            System.out.println("Graphics Transform: " + affineTransform);
            System.out.println("Translate " + pageFormat.getImageableX() + ", " + pageFormat.getImageableY());
            int n3 = this.m_CurrentPage;
            this.doPage(n2);
            this.m_ViewFlag = false;
            this.paint(graphics);
            this.m_ViewFlag = true;
            this.m_CurrentPage = n3;
            return 0;
        }
        return 1;
    }

    public void doPage(int n) {
        System.out.println("DviPage.doPage " + n);
        this.m_CurrentPage = n;
    }

    public void paint(Graphics graphics) {
        this.m_g = (Graphics2D)graphics;
        this.m_g.scale(0.1, 0.1);
        if (this.m_ViewFlag) {
            this.m_g.scale(this.m_ViewScale, this.m_ViewScale);
        }
        this.m_g.setColor(Color.black);
        this.m_Stack.reset();
        try {
            this.m_File.seek(this.m_File.getPageOffset(this.m_CurrentPage));
            int n = this.m_File.getUnsigned(0);
            if (n != 139) {
                System.out.println("Missing BOP (Beginning Of Page)");
                return;
            }
            this.m_File.seek(this.m_File.getPageOffset(this.m_CurrentPage));
            do {
                n = this.m_File.getUnsigned(0);
                this.m_Commands[n].execute(n);
            } while (n != 140);
        }
        catch (Exception exception) {
            System.out.println("paint exception=" + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public DviFile getFile() {
        return this.m_File;
    }

    public DviStack getStack() {
        return this.m_Stack;
    }

    public void setScale(double d) {
        this.m_Stack.setScale(10.0 * d);
    }

    public void setViewScale(double d) {
        if (d != this.m_ViewScale) {
            this.m_ViewScale = d;
            this.repaint();
        }
    }

    public double getViewScale() {
        return this.m_ViewScale;
    }

    public Graphics2D getGraphics2D() {
        return this.m_g;
    }

    private int simpleSetChar() {
        int n = 140;
        char[] cArray = new char[128];
        try {
            n = this.m_File.getUnsigned(0);
            while (n < 128) {
                int n2 = 0;
                while (n < 128 && n2 < 128) {
                    if (0 <= n && n <= 9) {
                        n += 161;
                    } else if (10 <= n && n <= 32) {
                        if ((n += 163) == 183) {
                            n = 8729;
                        }
                    } else if (n == 127) {
                        n = 196;
                    }
                    cArray[n2] = (char)n;
                    ++n2;
                    n = this.m_File.getUnsigned(0);
                }
                if (n2 <= 0) continue;
                float f = this.m_Stack.gethh();
                float f2 = this.m_Stack.getvv();
                String string = new String(cArray, 0, n2);
                this.m_g.drawString(string, f, f2);
                FontMetrics fontMetrics = this.m_g.getFontMetrics();
                float f3 = fontMetrics.stringWidth(string);
                this.m_Stack.addHoriz(f3);
            }
        }
        catch (IOException iOException) {
            System.err.println("DviPage.simpleSetChar error = " + iOException.getMessage());
            iOException.printStackTrace();
        }
        return n;
    }

    public void defineFont(int n, DviFont dviFont) {
        int n2;
        if (this.m_FontCode == null || this.m_FontVal == null) {
            this.m_FontCode = new int[128];
            this.m_FontVal = new DviFont[128];
            n2 = 0;
            while (n2 < 128) {
                this.m_FontCode[n2] = -1;
                this.m_FontVal[n2] = null;
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.m_FontCode.length) {
            if (this.m_FontCode[n2] == n) {
                if (dviFont.equals(this.m_FontVal[n2])) {
                    return;
                }
                System.out.println("Font " + n + " is " + this.m_FontVal[n2].getName());
                System.out.println("    Being redefined to " + dviFont.getName());
                this.m_FontVal[n2] = dviFont;
                return;
            }
            ++n2;
        }
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.m_FontCode.length) {
            if (this.m_FontCode[n4] < 0) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        if (n3 < 0) {
            n3 = this.m_FontCode.length;
            int[] nArray = new int[n3 + 128];
            DviFont[] dviFontArray = new DviFont[n3 + 128];
            System.arraycopy(this.m_FontCode, 0, nArray, 0, n3);
            System.arraycopy(this.m_FontVal, 0, dviFontArray, 0, n3);
            int n5 = n3;
            while (n5 < n3 + 128) {
                nArray[n5] = -1;
                dviFontArray[n5] = null;
                ++n5;
            }
            this.m_FontCode = nArray;
            this.m_FontVal = dviFontArray;
        }
        this.m_FontCode[n3] = n;
        this.m_FontVal[n3] = dviFont;
    }

    public void setFont(int n) {
        if (n < 0) {
            this.m_CurrentFont = null;
        } else {
            int n2 = 0;
            while (n2 < this.m_FontCode.length) {
                if (this.m_FontCode[n2] == n) {
                    this.m_CurrentFont = this.m_FontVal[n2];
                    this.m_g.setFont(this.m_CurrentFont.getFont());
                    return;
                }
                ++n2;
            }
            Exception exception = new Exception("No such font");
            System.err.println("Invalid font id " + n);
            exception.printStackTrace();
        }
    }

    public DviFont getCurrentFont() {
        return this.m_CurrentFont;
    }

    public void printPage() {
    }

    public void setPrintOption(int n) {
        this.m_PrintOption = n;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.m_File.getPaperSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = n == 0 ? (n2 < 0 ? (rectangle.getX() > 12.0 ? 12 : (int)rectangle.getX()) : (rectangle.getX() + rectangle.getWidth() + 12.0 < (double)this.getWidth() ? 12 : (int)((double)this.getWidth() - rectangle.getX() - rectangle.getWidth()))) : (n2 < 0 ? (rectangle.getY() > 12.0 ? 12 : (int)rectangle.getY()) : (rectangle.getY() + rectangle.getHeight() + 12.0 < (double)this.getHeight() ? 12 : (int)((double)this.getHeight() - rectangle.getY() - rectangle.getHeight())));
        return n3;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        int n3;
        if (n == 0) {
            double d = 0.75 * rectangle.getWidth();
            if (n2 < 0) {
                if (rectangle.getX() - d < 0.0) {
                    d = rectangle.getX();
                }
            } else if (rectangle.getX() + d > (double)this.getWidth()) {
                d = (double)this.getWidth() - rectangle.getX();
            }
            n3 = (int)d;
        } else {
            double d = 0.75 * rectangle.getHeight();
            if (n2 < 0) {
                if (rectangle.getY() - d < 0.0) {
                    d = rectangle.getY();
                }
            } else if (rectangle.getY() + d > (double)this.getHeight()) {
                d = (double)this.getHeight() - rectangle.getY();
            }
            n3 = (int)d;
        }
        return n3;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    private void setCommandTable() {
        this.m_Commands = new DviCommand[256];
        DviCommandTable dviCommandTable = new DviCommandTable(this.m_Commands, this);
    }
}

