import java.awt.*;
import java.awt.event.*;

//
// AskDialog is a modified version of the OKDialog which asks
// the user to press one of two buttons, OK or cancel.  There
// must therefore be a function which returns true for OK and
// false for cancel.
//
// I will use the create method, but unlike for the OKDialog,
// this one returns a value.
//

public class AskDialog extends Dialog implements ActionListener
{
    protected Button okButton;
    protected Button CancelBut;
    protected Panel butpan;
    protected static boolean m_choice;
    protected static Frame createdFrame;

    public AskDialog(Frame parent, String message, String OKBut, String CBut)
    {
        super(parent, true); // call parent constructor, set modal
        setBackground(Color.lightGray);
        setLayout(new GridLayout(0,1));
        // create the buttons
        okButton = new Button(OKBut);
        okButton.addActionListener(this);
        CancelBut = new Button(CBut);
        CancelBut.addActionListener(this);
        // add to a panel
        Label messageLabel = new Label(message);

        Panel topPan = new Panel(new FlowLayout());
        Panel botPan = new Panel(new FlowLayout());
        topPan.add(messageLabel);
        botPan.add(okButton);
        botPan.add(CancelBut);
        add(topPan);
        add(botPan);

        // make the window compact, to fit its components only and
        // no more
        pack();
    }

    // now do the listening.  I am using the new methods
    public void actionPerformed(ActionEvent event)
    {
        String arg = event.getActionCommand();
        if((arg.equals(okButton.getLabel())) || (arg.equals(CancelBut.getLabel())))
        {
            setVisible(false);
            if(createdFrame != null)
            {
                createdFrame.setVisible(false);
            }
            if(arg.equals(okButton.getLabel()))
            {
                setChoice(true);
            }
            else
            {
                setChoice(false);
            }
        }
    }


    // method to set the choice.  Declare private, as
    // noone else needs to know it.
    private void setChoice(boolean choice)
    {
        m_choice = choice;
    }

    // method to get the choice
    public static boolean getChoice()
    {
        return m_choice;
    }

    // method to create the frame automatically
    public static boolean createAskDialog(String dialogString, String OKBut, String CBut)
    {
        if(createdFrame == null)
        {
            createdFrame = new Frame("Dialog");
        }
        AskDialog askDialog = new AskDialog(createdFrame, dialogString, OKBut, CBut);
        int width = askDialog.getSize().width;
        int height = askDialog.getSize().height;
        createdFrame.setSize(width, height);
        askDialog.setVisible(true);
        return getChoice();
    }

    // method to create the frame automatically, with the reference to
    // a container passed to act as the parent.  If null is passed, then
    // control is passed to the simple creator
    public static boolean createAskDialog(String dialogString, String OKBut, String CBut, Container parent)
    {
        if(!(parent instanceof Container)) createAskDialog(dialogString, OKBut, CBut);
        if(!parent.isVisible()) createAskDialog(dialogString, OKBut, CBut);
        if(createdFrame == null)
        {
            createdFrame = new Frame("Dialog");
        }
        AskDialog askDialog = new AskDialog(createdFrame, dialogString, OKBut, CBut);
        int width = askDialog.getSize().width;
        int height = askDialog.getSize().height;
        createdFrame.setSize(width, height);
        int parentScreenX = parent.getLocationOnScreen().x;
        int parentScreenY = parent.getLocationOnScreen().y;
        int parentWidth = parent.getBounds().width;
        int parentHeight = parent.getBounds().height;
        int screenX = Math.max(0, parentScreenX + parentWidth / 2 - width / 2);
        int screenY = Math.max(0, parentScreenY + parentHeight / 2 - height / 2);
        askDialog.setLocation(screenX, screenY);
        askDialog.setVisible(true);
        return getChoice();
    }
}
