% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg_load.R
\name{pkg_load}
\alias{pkg_load}
\title{loads or reloads if needed a source package, taking care of its dependencies}
\usage{
pkg_load(
  pkgid,
  src_pkgs = get_srcpkgs(),
  attach = TRUE,
  suggests = FALSE,
  roxygen = TRUE,
  helpers = FALSE,
  export_all = FALSE,
  quiet = FALSE,
  dry_run = FALSE,
  ...
)
}
\arguments{
\item{pkgid}{a package name, path or package object}

\item{src_pkgs}{a collection of source packages as a \code{srckgs} object.}

\item{attach}{Whether to attach a package environment to the search
path. If \code{FALSE} \code{load_all()} behaves like \code{loadNamespace()}. If
\code{TRUE} (the default), it behaves like \code{library()}. If \code{FALSE},
the \code{export_all}, \code{export_imports}, and \code{helpers} arguments have
no effect.}

\item{suggests}{whether to load suggested packages. if TRUE, the suggested are processed
like imports}

\item{roxygen}{whether to automatically roxygenise packages (if needed)}

\item{helpers}{if \code{TRUE} loads \pkg{testthat} test helpers.}

\item{export_all}{If \code{TRUE} (the default), export all objects.
If \code{FALSE}, export only the objects that are listed as exports
in the NAMESPACE file.}

\item{quiet}{whether to be quiet/silent}

\item{dry_run}{whether not to actually execute any action having side-effects}

\item{...}{
  Arguments passed on to \code{\link[devtools:load_all]{devtools::load_all}}
  \describe{
    \item{\code{path}}{Path to a package, or within a package.}
    \item{\code{reset}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This is no longer supported
because preserving the namespace requires unlocking its environment, which
is no longer possible in recent versions of R.}
    \item{\code{recompile}}{DEPRECATED. force a recompile of DLL from source code, if
present. This is equivalent to running \code{\link[pkgbuild:clean_dll]{pkgbuild::clean_dll()}} before
\code{load_all()}}
  }}
}
\value{
the load plan as a data frame, or NULL if there is nothing to do.
}
\description{
N.B: the defaults are different from \code{\link[devtools:load_all]{devtools::load_all()}}: the helpers are not loaded, only
the functions tagged as \emph{exported} are actually exported. The intended goal is to make it as similar
to the behaviour of the R loaders.
}
\details{
This the workhorse function of the package, called by \code{\link[=library]{library()}} and \code{\link[=loadNamespace]{loadNamespace()}}
when hacked (cf \code{\link[=hack_r_loaders]{hack_r_loaders()}}.

This function will check that all dependent packages are up-to-date, and
document and reload them as needed.

To be able to properly load a package, its dependent source packages
must be loaded in proper order.
i.e. if A-->B-->C, the load order must be C, B, A
}
\examples{
 pkg <- setup_and_get_dummy_srcpkg()
# load and attach a package
pkg_load(pkg)

# just load, do not attach it (~ loadNamespace())
pkg_unload(pkg)
pkg_load(pkg, attach = FALSE)

# do some changes, to a source package or any of its depencies or dependents
pkg_unload(pkg)
plan <- pkg_load(pkg, dry_run = TRUE)
# then you can inspect the plan actions
}
