% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDWD.R
\name{readDWD.data}
\alias{readDWD.data}
\title{read regular dwd data}
\usage{
readDWD.data(
  file,
  fread = FALSE,
  varnames = FALSE,
  format = NA,
  tz = "GMT",
  hr = 0,
  quiet = rdwdquiet(),
  ...
)
}
\arguments{
\item{file}{Name of file on harddrive, like e.g.
DWDdata/daily_kl_recent_tageswerte_KL_03987_akt.zip}

\item{fread}{Logical: read faster with \link[data.table:fread]{data.table::fread}?
When reading many large historical files, speedup is significant.
When called from \code{\link[=readDWD]{readDWD()}}, \code{fread=NA} can also be used, which means
TRUE if R package \code{data.table} and system command \code{unzip} are available.
Hint for Windows users: \code{unzip} comes with Rtools.
See \url{https://brry.github.io/rdwd/fread.html}
DEFAULT: FALSE}

\item{varnames}{Logical (vector): add a short description to the DWD variable
abbreviations in the column names?
E.g. change \verb{FX,TNK} to \verb{FX.Windspitze,TNK.Lufttemperatur_Min},
see \code{\link[=newColumnNames]{newColumnNames()}}.
DEFAULT: FALSE (for backwards compatibility)}

\item{format}{Char (vector): Format passed to \code{\link[=as.POSIXct]{as.POSIXct()}} (see \code{\link[=strptime]{strptime()}})
to convert the date/time column to POSIX time format.\cr
If NA (the default), \code{readDWD} tries to find a suitable format
based on the number of characters.
Since rdwd version 1.8.7 (2024-05-14), timestamps with 8 digits
(e.g. in daily data) is converted with \code{\link[=as.Date]{as.Date()}}.
If NULL, no conversion is performed (date stays a factor).
DEFAULT: NA}

\item{tz}{Char (vector): time zone for \code{\link[=as.POSIXct]{as.POSIXct()}}.
"" is the current time zone, and "GMT" is UTC (Universal Time,
Coordinated). DEFAULT: "GMT"}

\item{hr}{Integer code to automatically merge historical and recent datasets.
If set, \code{readDWD} returns a data.frame instead of a list.
If multiple historical files are present,
the longest date range (per file name) is used.
This is not actually used in \code{readDWD.data}, but in \code{\link[=readDWD]{readDWD()}}.\cr
0 (default): ignore this argument\cr
1: sort by hr (if given) + merge\cr
2: also remove duplicated dates from recent\cr
3: also remove columns QN3,QN4,eor\cr
4: also remove column STATIONS_ID\cr
DEFAULT: 0}

\item{quiet}{Suppress empty file warnings?
DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[=read.table]{read.table()}} or \code{\link[data.table:fread]{data.table::fread()}}}
}
\value{
data.frame
}
\description{
Read regular dwd data.
Intended to be called via \code{\link[=readDWD]{readDWD()}}.
}
\seealso{
\code{\link[=readDWD]{readDWD()}}, Examples in \code{\link[=dataDWD]{dataDWD()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}
}
