% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_error}
\alias{plot_error}
\title{Utility function}
\usage{
plot_error(
  x,
  fit,
  se.fit,
  se.fit2 = NULL,
  shade = FALSE,
  f = 1,
  col = "black",
  ci.lty = NULL,
  ci.lwd = NULL,
  border = FALSE,
  alpha = 0.25,
  ...
)
}
\arguments{
\item{x}{Vector with values on x-axis.}

\item{fit}{Vector with values on y-axis.}

\item{se.fit}{Vector with standard error; or when \code{se.fit2}
is provided, \code{se.fit} specifies upper values confidence
interval.}

\item{se.fit2}{Optional: lower values confidence interval.}

\item{shade}{Logical: whether or not to produce shaded regions as 
confidence bands.}

\item{f}{Factor for converting standard error in confidence intervals. 
Defaults to 1. Use 1.96 for 95\% CI, and 2.58 for 99\% CI.}

\item{col}{Color for lines and confindence bands.}

\item{ci.lty}{Line type to be used for the error lines, see 
\code{\link[graphics]{par}}.}

\item{ci.lwd}{Line type to be used for the error lines, see 
\code{\link[graphics]{par}}.}

\item{border}{The color to draw the border for the shaded confidence 
interval. The default, FALSE, omits borders.}

\item{alpha}{Transparency of shaded area. Number between 0 
(completely transparent) and 1 (not transparent).}

\item{...}{Optional arguments for the lines and shaded area.}
}
\description{
Plot line with confidence intervals.
}
\examples{

# generate some data:
x <- -10:20
y <- 0.3*(x - 3)^2 + rnorm(length(x))
s <- 0.2*abs(100-y + rnorm(length(x)))

# Plot line and standard deviation:
emptyPlot(range(x), range(y), h0=0)
plot_error(x, y, s)
# Change layout:
emptyPlot(range(x), range(y), h0=0)
plot_error(x, y, s, shade=TRUE, lty=3, lwd=3)

# Use of se.fit2 for asymmetrical error bars:
cu <- y + .65*s
cl <- y - s
emptyPlot(range(x), range(y), h0=0)
plot_error(x, y, s, shade=TRUE)
plot_error(x, y, se.fit=cu, se.fit2=cl, col='red', shade=TRUE)

# Some layout options:
emptyPlot(range(x), range(y), h0=0)
plot_error(x, y, s, lty=3, lwd=1, ci.lty=1, ci.lwd=3)
emptyPlot(range(x), range(y), h0=0)
plot_error(x, y, s, shade=TRUE, lty=3, lwd=3)
emptyPlot(range(x), range(y), h0=0)
plot_error(x, y, s, shade=TRUE, lty=1, lwd=3, ci.lwd=3, border='red')
emptyPlot(range(x), range(y), h0=0)
plot_error(x, y, s, shade=TRUE, lty=1, lwd=3, density=10, ci.lwd=3)

}
\seealso{
Other Functions for plotting: 
\code{\link{addInterval}()},
\code{\link{add_bars}()},
\code{\link{add_n_points}()},
\code{\link{alpha}()},
\code{\link{alphaPalette}()},
\code{\link{check_normaldist}()},
\code{\link{color_contour}()},
\code{\link{dotplot_error}()},
\code{\link{drawDevArrows}()},
\code{\link{emptyPlot}()},
\code{\link{errorBars}()},
\code{\link{fill_area}()},
\code{\link{getCoords}()},
\code{\link{getFigCoords}()},
\code{\link{getProps}()},
\code{\link{gradientLegend}()},
\code{\link{legend_margin}()},
\code{\link{marginDensityPlot}()},
\code{\link{plot_image}()},
\code{\link{plotsurface}()},
\code{\link{sortBoxplot}()}
}
\author{
Jacolien van Rij
}
\concept{Functions for plotting}
