% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Steepest_Descent.R
\name{Steepest_Desc}
\alias{Steepest_Desc}
\title{Stand-alone version of steepest descent algorithm. This is similar to the
CHEMTAX steepest descent algorithm. It is not required to use this
function, and as results are not bound by minimum and maximum, results may
be unrealistic.}
\usage{
Steepest_Desc(Fmat, S, num.loops)
}
\arguments{
\item{Fmat}{Pigment to Chl a matrix}

\item{S}{Sample data matrix – a matrix of pigment samples}

\item{num.loops}{Number of loops/iterations to perform (no default)}
}
\value{
A list containing
\enumerate{
\item The F matrix (pigment: Chl \emph{a}) ratios
\item RMSE (Root Mean Square Error)
\item Condition number
\item class abundances
\item Figure (plot of results)
\item MAE (Mean Absolute Error)
}
}
\description{
Stand-alone version of steepest descent algorithm. This is similar to the
CHEMTAX steepest descent algorithm. It is not required to use this
function, and as results are not bound by minimum and maximum, results may
be unrealistic.
}
\examples{
MC <- Matrix_checks(Sm,Fm)
Snew <- MC$Snew
Fnew <- MC$Fnew
SDRes <- Steepest_Desc(Fnew,Snew, num.loops = 20)

}
