% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive_Bayes.R
\name{naive_Bayes}
\alias{naive_Bayes}
\title{Naive Bayes models}
\usage{
naive_Bayes(
  mode = "classification",
  smoothness = NULL,
  Laplace = NULL,
  engine = "klaR"
)
}
\arguments{
\item{mode}{A single character string for the prediction outcome mode.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{smoothness}{An non-negative number representing the the relative
smoothness of the class boundary. Smaller examples result in model flexible
boundaries and larger values generate class boundaries that are less
adaptable}

\item{Laplace}{A non-negative value for the Laplace correction to smoothing
low-frequency counts.}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}
}
\description{
\code{naive_Bayes()} defines a model that uses Bayes' theorem to compute the
probability of each class, given the predictor values. This function can fit
classification models.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("naive_Bayes")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.

Each of the arguments in this function other than \code{mode} and \code{engine} are
captured as \link[rlang:topic-quosure]{quosures}. To pass values
programmatically, use the \link[rlang:injection-operator]{injection operator} like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{value <- 1
naive_Bayes(argument = !!value)
}\if{html}{\out{</div>}}
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("naive_Bayes")}
}
