% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_multi_predict.R
\name{has_multi_predict}
\alias{has_multi_predict}
\alias{has_multi_predict.default}
\alias{has_multi_predict.model_fit}
\alias{has_multi_predict.workflow}
\alias{multi_predict_args}
\alias{multi_predict_args.default}
\alias{multi_predict_args.model_fit}
\alias{multi_predict_args.workflow}
\title{Tools for models that predict on sub-models}
\usage{
has_multi_predict(object, ...)

\method{has_multi_predict}{default}(object, ...)

\method{has_multi_predict}{model_fit}(object, ...)

\method{has_multi_predict}{workflow}(object, ...)

multi_predict_args(object, ...)

\method{multi_predict_args}{default}(object, ...)

\method{multi_predict_args}{model_fit}(object, ...)

\method{multi_predict_args}{workflow}(object, ...)
}
\arguments{
\item{object}{An object to test.}

\item{...}{Not currently used.}
}
\value{
\code{has_multi_predict()} returns single logical value while
\code{multi_predict_args()} returns a character vector of argument names (or \code{NA}
if none exist).
}
\description{
\code{has_multi_predict()} tests to see if an object can make multiple
predictions on submodels from the same object. \code{multi_predict_args()}
returns the names of the arguments to \code{multi_predict()} for this model
(if any).
}
\examples{
\dontshow{if (!parsnip:::is_cran_check() & rlang::is_installed("kknn")) withAutoprint(\{ # examplesIf}
lm_model_idea <- linear_reg() |> set_engine("lm")
has_multi_predict(lm_model_idea)
lm_model_fit <- fit(lm_model_idea, mpg ~ ., data = mtcars)
has_multi_predict(lm_model_fit)

multi_predict_args(lm_model_fit)

library(kknn)

knn_fit <-
  nearest_neighbor(mode = "regression", neighbors = 5) |>
  set_engine("kknn") |>
  fit(mpg ~ ., mtcars)

multi_predict_args(knn_fit)

multi_predict(knn_fit, mtcars[1, -1], neighbors = 1:4)$.pred
\dontshow{\}) # examplesIf}
}
\keyword{internal}
