% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_forest_partykit.R
\name{details_rand_forest_partykit}
\alias{details_rand_forest_partykit}
\title{Random forests via partykit}
\description{
\code{\link[partykit:cforest]{partykit::cforest()}} fits a model that creates a large number of decision
trees, each independent of the others. The final prediction uses all
predictions from the individual trees and combines them.
}
\details{
For this engine, there are multiple modes: censored regression,
regression, and classification
\subsection{Tuning Parameters}{

This model has 3 tuning parameters:
\itemize{
\item \code{trees}: # Trees (type: integer, default: 500L)
\item \code{min_n}: Minimal Node Size (type: integer, default: 20L)
\item \code{mtry}: # Randomly Selected Predictors (type: integer, default: 5L)
}
}

\subsection{Translation from parsnip to the original package (regression)}{

The \strong{bonsai} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(bonsai)

rand_forest() |> 
  set_engine("partykit") |> 
  set_mode("regression") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Random Forest Model Specification (regression)
## 
## Computational engine: partykit 
## 
## Model fit template:
## parsnip::cforest_train(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg())
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (classification)}{

The \strong{bonsai} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(bonsai)

rand_forest() |> 
  set_engine("partykit") |> 
  set_mode("classification") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Random Forest Model Specification (classification)
## 
## Computational engine: partykit 
## 
## Model fit template:
## parsnip::cforest_train(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg())
}\if{html}{\out{</div>}}

\code{parsnip::cforest_train()} is a wrapper around
\code{\link[partykit:cforest]{partykit::cforest()}} (and other functions) that
makes it easier to run this model.
}
}
\section{Translation from parsnip to the original package (censored regression)}{
The \strong{censored} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(censored)

rand_forest() |> 
  set_engine("partykit") |> 
  set_mode("censored regression") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Random Forest Model Specification (censored regression)
## 
## Computational engine: partykit 
## 
## Model fit template:
## parsnip::cforest_train(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg())
}\if{html}{\out{</div>}}

\code{censored::cond_inference_surv_cforest()} is a wrapper around
\code{\link[partykit:cforest]{partykit::cforest()}} (and other functions) that
makes it easier to run this model.
\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{Prediction types}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{parsnip:::get_from_env("rand_forest_predict") |>
  dplyr::filter(engine == "partykit") |>
  dplyr::select(mode, type)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 5 x 2
##   mode                type    
##   <chr>               <chr>   
## 1 censored regression time    
## 2 censored regression survival
## 3 regression          numeric 
## 4 classification      class   
## 5 classification      prob
}\if{html}{\out{</div>}}
}

\subsection{Other details}{

Predictions of type \code{"time"} are predictions of the median survival
time.
}

\subsection{References}{
\itemize{
\item \href{https://jmlr.org/papers/v16/hothorn15a.html}{partykit: A Modular Toolkit for Recursive Partytioning in R}
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}
}

\keyword{internal}
