% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrim_linear_sda.R
\name{details_discrim_linear_sda}
\alias{details_discrim_linear_sda}
\title{Linear discriminant analysis via James-Stein-type shrinkage estimation}
\description{
\code{\link[sda:sda]{sda::sda()}} can fit a linear discriminant analysis model that can fit models
between classical discriminant analysis and diagonal discriminant analysis.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This engine has no tuning parameter arguments in
\code{\link[=discrim_linear]{discrim_linear()}}.

However, there are a few engine-specific parameters that can be set or
optimized when calling \code{\link[=set_engine]{set_engine()}}:
\itemize{
\item \code{lambda}: the shrinkage parameters for the correlation matrix. This
maps to the parameter
\code{\link[dials:shrinkage_correlation]{dials::shrinkage_correlation()}}.
\item \code{lambda.var}: the shrinkage parameters for the predictor variances.
This maps to
\code{\link[dials:shrinkage_correlation]{dials::shrinkage_variance()}}.
\item \code{lambda.freqs}: the shrinkage parameters for the class frequencies.
This maps to
\code{\link[dials:shrinkage_correlation]{dials::shrinkage_frequencies()}}.
\item \code{diagonal}: a logical to make the model covariance diagonal or not.
This maps to
\code{\link[dials:shrinkage_correlation]{dials::diagonal_covariance()}}.
}
}

\subsection{Translation from parsnip to the original package}{

The \strong{discrim} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(discrim)

discrim_linear() |> 
  set_engine("sda") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Linear Discriminant Model Specification (classification)
## 
## Computational engine: sda 
## 
## Model fit template:
## sda::sda(Xtrain = missing_arg(), L = missing_arg(), verbose = FALSE)
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Variance calculations are used in these computations so \emph{zero-variance}
predictors (i.e., with a single unique value) should be eliminated
before fitting the model.
}

\subsection{Case weights}{

The underlying model implementation does not allow for case weights.
}

\subsection{Prediction types}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{parsnip:::get_from_env("discrim_linear_predict") |>
  dplyr::filter(engine == "sda") |>
  dplyr::select(mode, type)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 3 x 2
##   mode           type 
##   <chr>          <chr>
## 1 classification class
## 2 classification prob 
## 3 classification raw
}\if{html}{\out{</div>}}
}

\subsection{References}{
\itemize{
\item Ahdesmaki, A., and K. Strimmer. 2010. Feature selection in omics
prediction problems using cat scores and false non-discovery rate
control. Ann. Appl. Stat. 4: 503-519.
\href{https://arxiv.org/abs/0903.2003}{Preprint}.
}
}
}
\keyword{internal}
