% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connections.R
\name{db_connect}
\alias{db_connect}
\title{Get a database connection}
\usage{
db_connect(name)
}
\arguments{
\item{name}{Character. Name of the connection in config.yml (e.g., "postgres")}
}
\value{
A database connection object (DBIConnection)
}
\description{
Gets a database connection based on the connection name in config.yml.
For most use cases, prefer \code{db_query()} or \code{db_execute()} which handle
connection lifecycle automatically.
}
\examples{
\donttest{
if (FALSE) {
# Preferred: use db_query() which auto-disconnects
users <- db_query("SELECT * FROM users", "postgres")

# Manual connection management (remember to disconnect!)
conn <- db_connect("postgres")
DBI::dbListTables(conn)
DBI::dbDisconnect(conn)
}
}

}
