% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_from_con.R
\name{dm_from_src}
\alias{dm_from_src}
\title{Load a dm from a remote data source}
\usage{
dm_from_src(src = NULL, table_names = NULL, learn_keys = NULL, ...)
}
\arguments{
\item{src}{A dbplyr source, DBI connection object or a Pool object.}

\item{table_names}{A character vector of the names of the tables to include.}

\item{learn_keys}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Set to \code{TRUE} to query the definition of primary and
foreign keys from the database.
Currently works for Postgres/Redshift, MariaDB/MySQL, SQLite, SQL Server, and DuckDB databases.
The default attempts to query and issues an informative message.}

\item{...}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Additional parameters for the schema learning query.
\itemize{
\item \code{schema}: supported for MSSQL (default: \code{"dbo"}), Postgres/Redshift (default: \code{"public"}), MariaDB/MySQL
(default: current database) and SQLite (default: main schema).
Learn the tables in a specific schema (or database for MariaDB/MySQL).
\item \code{dbname}: supported for MSSQL. Access different databases on the connected MSSQL-server;
default: active database.
\item \code{table_type}: supported for Postgres/Redshift (default: \code{"BASE TABLE"}). Specify the table type. Options are:
\enumerate{
\item \code{"BASE TABLE"} for a persistent table (normal table type)
\item \code{"VIEW"} for a view
\item \code{"FOREIGN TABLE"} for a foreign table
\item \code{"LOCAL TEMPORARY"} for a temporary table
}
}}
}
\description{
Deprecated  in dm 0.3.0 in favor of \code{\link[=dm_from_con]{dm_from_con()}}.
}
\keyword{internal}
