% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_interface.R, R/pca_methods.R
\name{pca_bigmatrix}
\alias{pca_bigmatrix}
\alias{resolve_big_pointer}
\alias{pca_scores_bigmatrix}
\alias{pca_variable_loadings}
\alias{pca_variable_correlations}
\alias{pca_variable_contributions}
\alias{pca_individual_contributions}
\alias{pca_individual_cos2}
\alias{pca_variable_cos2}
\alias{summary.bigpca}
\alias{print.summary.bigpca}
\alias{plot.bigpca}
\title{Principal component analysis for \code{bigmemory::big.matrix} inputs}
\usage{
resolve_big_pointer(x, arg, allow_null = FALSE)

pca_scores_bigmatrix(
  xpMat,
  rotation,
  center,
  scale,
  ncomp = -1L,
  block_size = 1024L
)

pca_variable_loadings(rotation, sdev)

pca_variable_correlations(rotation, sdev, column_sd, scale = NULL)

pca_variable_contributions(loadings)

pca_individual_contributions(scores, sdev, total_weight = NA_real_)

pca_individual_cos2(scores)

pca_variable_cos2(correlations)

\method{summary}{bigpca}(object, ...)

\method{print}{summary.bigpca}(x, digits = max(3, getOption("digits") - 3), ...)

\method{plot}{bigpca}(
  x,
  y,
  type = c("scree", "contributions", "correlation_circle", "biplot"),
  max_components = 25L,
  component = 1L,
  top_n = 20L,
  components = c(1L, 2L),
  data = NULL,
  draw = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{\link{summary.bigpca}} object.}

\item{arg}{Character string naming the argument being validated. Used to
construct informative error messages.}

\item{allow_null}{Logical flag indicating whether \code{NULL} is accepted for the
argument. When \code{TRUE}, a \code{NULL} input is returned unchanged.}

\item{xpMat}{Either a \code{\link[bigmemory:big.matrix]{bigmemory::big.matrix}} or an external pointer such
as \code{mat@address} that references the source \code{big.matrix}.}

\item{rotation}{A rotation matrix such as the \code{rotation} element returned by
\code{\link[=pca_bigmatrix]{pca_bigmatrix()}}.}

\item{center}{For \code{pca_scores_bigmatrix()}, a numeric vector of column means
(optional).}

\item{scale}{Optional numeric vector of scaling factors returned by
\code{\link[=pca_bigmatrix]{pca_bigmatrix()}}. If supplied, it indicates the PCA was performed on
standardised variables.}

\item{ncomp}{Number of components to retain. Use a non-positive value to keep
all components returned by the decomposition.}

\item{block_size}{Number of rows to process per block when streaming data
through BLAS kernels. Larger values improve throughput at the cost of
additional memory.}

\item{sdev}{A numeric vector of component standard deviations, typically the
\code{sdev} element from \code{\link[=pca_bigmatrix]{pca_bigmatrix()}}.}

\item{column_sd}{A numeric vector with the marginal standard deviation of
each original variable. When \code{scale} is supplied, correlations are computed
on the standardised scale without rescaling by \code{column_sd}.}

\item{loadings}{A numeric matrix such as the result of
\code{\link[=pca_variable_loadings]{pca_variable_loadings()}}.}

\item{scores}{For \code{pca_individual_contributions()} and
\code{pca_individual_cos2()}, a numeric matrix of component scores where rows
correspond to observations and columns to components.}

\item{total_weight}{Optional positive scalar giving the effective number of
observations to use when computing contributions. Defaults to the number of
rows in \code{scores}.}

\item{correlations}{For \code{pca_variable_cos2()}, a numeric matrix of
correlations between variables and components.}

\item{object}{A \code{\link{bigpca}} object created by \code{\link[=pca_bigmatrix]{pca_bigmatrix()}},
\code{\link[=pca_stream_bigmatrix]{pca_stream_bigmatrix()}}, or related helpers.}

\item{...}{Additional arguments passed to plotting helpers.}

\item{digits}{Number of significant digits to display when printing
importance metrics.}

\item{y}{Currently unused.}

\item{type}{The plot to draw. Options include "scree" (variance explained),
"contributions" (top contributing variables), "correlation_circle" (variable
correlations with selected components), and "biplot" (joint display of
scores and loadings).}

\item{max_components}{Maximum number of components to display in scree plots.}

\item{component}{Component index to highlight when drawing contribution plots.}

\item{top_n}{Number of variables to display in contribution plots.}

\item{components}{Length-two integer vector selecting the components for
correlation circle and biplot views.}

\item{data}{Optional data source (matrix, data frame, \code{bigmemory::big.matrix},
or external pointer) used to compute scores for biplots when
\code{x$scores} is unavailable.}

\item{draw}{Logical; if \code{FALSE}, return the data prepared for the selected
plot instead of drawing it.}
}
\value{
For \code{pca_bigmatrix()}, a \code{bigpca} object mirroring a \code{prcomp} result
with elements \code{sdev}, \code{rotation}, optional \code{center} and \code{scale} vectors,
\code{column_sd}, \code{eigenvalues}, \code{explained_variance}, \code{cumulative_variance}, and
the sample covariance matrix. The object participates in S3 generics such as
\code{\link[=summary]{summary()}} and \code{\link[=plot]{plot()}}.

A numeric matrix of scores with rows corresponding to observations
and columns to retained components.

A numeric matrix containing variable loadings for each component.

A numeric matrix of correlations between variables and components.

A numeric matrix where each entry represents the contribution of a
variable to a component.

For \code{summary.bigpca()}, a \code{\link{summary.bigpca}} object containing
component importance measures.
}
\description{
Perform principal component analysis (PCA) directly on a
\code{\link[bigmemory:big.matrix]{bigmemory::big.matrix}} without copying the data into R memory. The
exported helpers mirror the structure of base R's \code{prcomp()} while avoiding
the need to materialise large matrices.
}
\section{Functions}{
\itemize{
\item \code{pca_scores_bigmatrix()}: Project observations into principal component
space while streaming from a \code{big.matrix}.

\item \code{pca_variable_loadings()}: Compute variable loadings (covariances between
original variables and components).

\item \code{pca_variable_correlations()}: Compute variable-component correlations given
column standard deviations.

\item \code{pca_variable_contributions()}: Derive the relative contribution of each variable
to the retained components.

\item \code{pca_individual_contributions()}: Compute the relative contribution of individual
observations to each component.

\item \code{pca_individual_cos2()}: Compute squared cosine values measuring the quality
of representation for individual observations.

\item \code{pca_variable_cos2()}: Compute squared cosine values measuring the quality
of representation for variables.

\item \code{summary(bigpca)}: Summarise the component importance metrics for a
\code{\link{bigpca}} result.

\item \code{print(summary.bigpca)}: Print the component importance summary produced by
\code{\link[=summary.bigpca]{summary.bigpca()}}.

\item \code{plot(bigpca)}: Visualise PCA diagnostics such as scree, correlation
circle, contribution, and biplot displays.

}}
\examples{
\dontshow{if (requireNamespace("bigmemory", quietly = TRUE)) withAutoprint(\{ # examplesIf}
set.seed(123)
mat <- bigmemory::as.big.matrix(matrix(rnorm(40), nrow = 10))
pca <- pca_bigmatrix(mat, center = TRUE, scale = TRUE, ncomp = 3)
scores <- pca_scores_bigmatrix(mat, pca$rotation, pca$center, pca$scale, ncomp = 3)
loadings <- pca_variable_loadings(pca$rotation, pca$sdev)
correlations <- pca_variable_correlations(pca$rotation, pca$sdev, pca$column_sd, pca$scale)
contributions <- pca_variable_contributions(loadings)
list(scores = scores, loadings = loadings, correlations = correlations,
     contributions = contributions)
\dontshow{\}) # examplesIf}
}
\seealso{
\link{bigpca}, \code{\link[=pca_scores_bigmatrix]{pca_scores_bigmatrix()}}, \code{\link[=pca_variable_loadings]{pca_variable_loadings()}},
\code{\link[=pca_variable_correlations]{pca_variable_correlations()}}, \code{\link[=pca_variable_contributions]{pca_variable_contributions()}}, and the
streaming variants \code{\link[=pca_stream_bigmatrix]{pca_stream_bigmatrix()}} and companions.

\link{bigpca}

\link{bigpca}

\link{bigpca}
}
