#' Benchmark timings for bigPCAcpp methods
#'
#' A dataset summarising wall-clock performance for the main PCA entry points
#' in **bigPCAcpp** across matrices of increasing size. The benchmarks compare
#' the classical block-based decomposition, the streaming variant that writes
#' rotations as it progresses, the scalable stochastic PCA implementation, and
#' the base R [stats::prcomp()] routine for reference.
#'
#' @name benchmark_results
#' @docType data
#' @format A data frame with 360 rows and 14 columns:
#' \describe{
#'   \item{dataset}{Human-readable size label ("small", "medium", "large",
#'   "xlarge").}
#'   \item{rows}{Number of rows in the simulated matrix.}
#'   \item{cols}{Number of columns in the simulated matrix.}
#'   \item{ncomp}{Number of components requested.}
#'   \item{method}{Computation strategy ("classical", "streaming",
#'   "scalable", or "prcomp").}
#'   \item{replicate}{Replication index for repeated runs.}
#'   \item{user_time}{User CPU time in seconds returned by [base::system.time()].}
#'   \item{system_time}{System CPU time in seconds.}
#'   \item{elapsed}{Elapsed (wall-clock) time in seconds.}
#'   \item{success}{Logical flag indicating whether the run completed without
#'   errors.}
#'   \item{backend}{Name of the backend reported by the result object when the
#'   computation succeeded.}
#'   \item{iterations}{Recorded iteration count for iterative methods when
#'   available (otherwise `NA`).}
#'   \item{converged}{Logical convergence flag for iterative methods when
#'   available.}
#'   \item{error}{Error message captured for failed runs (otherwise `NA`).}
#' }
#'
#' @keywords datasets
#' @examples
#' 
#' data(benchmark_results)
#'
#' @source Generated by `scripts/run_benchmark.R` using randomly simulated
#'   in-memory matrices (no file-backed storage).
NULL
