% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage.R
\name{SQLiteStorage}
\alias{SQLiteStorage}
\title{SQLite Storage}
\description{
Persistent SQLite storage backend
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{db_path}}{Database file path}

\item{\code{conn}}{Database connection}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SQLiteStorage-new}{\code{SQLiteStorage$new()}}
\item \href{#method-SQLiteStorage-set}{\code{SQLiteStorage$set()}}
\item \href{#method-SQLiteStorage-get}{\code{SQLiteStorage$get()}}
\item \href{#method-SQLiteStorage-delete}{\code{SQLiteStorage$delete()}}
\item \href{#method-SQLiteStorage-exists}{\code{SQLiteStorage$exists()}}
\item \href{#method-SQLiteStorage-keys}{\code{SQLiteStorage$keys()}}
\item \href{#method-SQLiteStorage-clear}{\code{SQLiteStorage$clear()}}
\item \href{#method-SQLiteStorage-count}{\code{SQLiteStorage$count()}}
\item \href{#method-SQLiteStorage-close}{\code{SQLiteStorage$close()}}
\item \href{#method-SQLiteStorage-clone}{\code{SQLiteStorage$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SQLiteStorage-new"></a>}}
\if{latex}{\out{\hypertarget{method-SQLiteStorage-new}{}}}
\subsection{Method \code{new()}}{
Create new SQLite storage
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SQLiteStorage$new(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Database file path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SQLiteStorage-set"></a>}}
\if{latex}{\out{\hypertarget{method-SQLiteStorage-set}{}}}
\subsection{Method \code{set()}}{
Store a value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SQLiteStorage$set(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Storage key}

\item{\code{value}}{Value to store}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SQLiteStorage-get"></a>}}
\if{latex}{\out{\hypertarget{method-SQLiteStorage-get}{}}}
\subsection{Method \code{get()}}{
Retrieve a value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SQLiteStorage$get(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Storage key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Stored value or NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SQLiteStorage-delete"></a>}}
\if{latex}{\out{\hypertarget{method-SQLiteStorage-delete}{}}}
\subsection{Method \code{delete()}}{
Delete a value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SQLiteStorage$delete(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Storage key}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SQLiteStorage-exists"></a>}}
\if{latex}{\out{\hypertarget{method-SQLiteStorage-exists}{}}}
\subsection{Method \code{exists()}}{
Check if key exists
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SQLiteStorage$exists(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Storage key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SQLiteStorage-keys"></a>}}
\if{latex}{\out{\hypertarget{method-SQLiteStorage-keys}{}}}
\subsection{Method \code{keys()}}{
List all keys
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SQLiteStorage$keys()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of keys
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SQLiteStorage-clear"></a>}}
\if{latex}{\out{\hypertarget{method-SQLiteStorage-clear}{}}}
\subsection{Method \code{clear()}}{
Clear all data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SQLiteStorage$clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SQLiteStorage-count"></a>}}
\if{latex}{\out{\hypertarget{method-SQLiteStorage-count}{}}}
\subsection{Method \code{count()}}{
Get count of stored items
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SQLiteStorage$count()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer count
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SQLiteStorage-close"></a>}}
\if{latex}{\out{\hypertarget{method-SQLiteStorage-close}{}}}
\subsection{Method \code{close()}}{
Close database connection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SQLiteStorage$close()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SQLiteStorage-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SQLiteStorage-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SQLiteStorage$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
