% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embedders.R
\name{DenseEmbedder}
\alias{DenseEmbedder}
\title{Dense Embedder using word2vec or GloVe}
\description{
Generates dense vector embeddings using pre-trained word vectors
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{dimension}}{Embedding dimension}

\item{\code{model_type}}{Type of model being used}

\item{\code{language}}{Language setting ("en" or "ml")}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DenseEmbedder-new}{\code{DenseEmbedder$new()}}
\item \href{#method-DenseEmbedder-set_sentence_embedder}{\code{DenseEmbedder$set_sentence_embedder()}}
\item \href{#method-DenseEmbedder-embed}{\code{DenseEmbedder$embed()}}
\item \href{#method-DenseEmbedder-fit}{\code{DenseEmbedder$fit()}}
\item \href{#method-DenseEmbedder-clone}{\code{DenseEmbedder$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DenseEmbedder-new"></a>}}
\if{latex}{\out{\hypertarget{method-DenseEmbedder-new}{}}}
\subsection{Method \code{new()}}{
Create a new DenseEmbedder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DenseEmbedder$new(
  dimension = 100,
  model_path = NULL,
  model_type = "tfidf",
  sentence_embedder = NULL,
  auto_download = FALSE,
  language = "en"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dimension}}{Vector dimension (default: 100 for word2vec, 50/100/200/300 for GloVe)}

\item{\code{model_path}}{Optional path to pre-trained model file}

\item{\code{model_type}}{Type: "word2vec", "glove", "glove-pretrained", or "tfidf"}

\item{\code{sentence_embedder}}{Optional SentenceEmbedder object to use}

\item{\code{auto_download}}{Auto-download GloVe vectors if model_type is glove-pretrained}

\item{\code{language}}{Language behavior ("en" = ASCII-focused, "ml" = Unicode-aware)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DenseEmbedder-set_sentence_embedder"></a>}}
\if{latex}{\out{\hypertarget{method-DenseEmbedder-set_sentence_embedder}{}}}
\subsection{Method \code{set_sentence_embedder()}}{
Set a SentenceEmbedder to use for embeddings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DenseEmbedder$set_sentence_embedder(embedder)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{embedder}}{SentenceEmbedder object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DenseEmbedder-embed"></a>}}
\if{latex}{\out{\hypertarget{method-DenseEmbedder-embed}{}}}
\subsection{Method \code{embed()}}{
Embed texts to vectors
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DenseEmbedder$embed(texts)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{texts}}{Character vector of texts}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Matrix of embeddings (rows are documents)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DenseEmbedder-fit"></a>}}
\if{latex}{\out{\hypertarget{method-DenseEmbedder-fit}{}}}
\subsection{Method \code{fit()}}{
Train embedder on corpus (for TF-IDF)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DenseEmbedder$fit(texts)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{texts}}{Character vector of training texts}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DenseEmbedder-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DenseEmbedder-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DenseEmbedder$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
