% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppTskit.R
\name{get_tskit_py}
\alias{get_tskit_py}
\alias{check_tskit_py}
\title{Get the reticulate \code{tskit} Python module}
\usage{
get_tskit_py(object_name = "tskit", force = FALSE)

check_tskit_py(object, stop = FALSE)
}
\arguments{
\item{object_name}{character name of the object holding the reticulate
\code{tskit} module. If this object exists in the global R environment and
is a reticulate Python module, it is returned. Otherwise, the function
attempts to install and import \code{tskit} before returning it.}

\item{force}{logical; force installation and/or import before returning the
reticulate Python module.}

\item{object}{reticulate Python module.}

\item{stop}{logical; whether to throw an error in \code{check_tskit_py}.}
}
\value{
\code{get_tskit_py} returns the reticulate Python module \code{tskit}
  if successful. Otherwise it throws an error (when \code{object_name} exists
  but is not a reticulate Python module) or returns \code{simpleError}
  (when installation or import failed). \code{check_tskit_py} returns
  \code{TRUE} if \code{object} is a reticulate Python module or \code{FALSE}
  otherwise.
}
\description{
This function imports the reticulate Python \code{tskit} module.
  If it is not yet installed, it attempts to install it first.
}
\details{
This function is meant for users running \code{tskit <- get_tskit_py()}
  or similar code, and for other functions in this package that need the
  \code{tskit} reticulate Python module. The point of \code{get_tskit_py} is
  to avoid importing the module repeatedly; if it has been imported already,
  we reuse that instance. This process can be sensitive to the reticulate
  Python setup, module availability, and internet access.
}
\section{Functions}{
\itemize{
\item \code{check_tskit_py()}: Test whether \code{get_tskit_py} returned a reticulate Python module object

}}
\examples{
\dontrun{
  tskit <- get_tskit_py()
  is(tskit)
  if (check_tskit_py(tskit)) {
    tskit$ALLELES_01
  }
}
}
