\name{MaxIntTools-package}
\alias{MaxIntTools-package}
\docType{package}
\title{
MaxIntTools: Tools for Detecting and Understanding Maximal Interaction Two-Mode Clustering 
}
\description{
MaxIntTools provides functions for performing maximal interaction two-mode clustering and related visualization techniques. It facilitates detection and understanding
of latent interaction in complex two-mode data sets with applications in psychology, marketing, neuroscience, and other fields.
}
\details{
The package includes the following key functions:
\itemize{
  \item \code{MaxInt_data_analysis}: Analysis two-mode data using this function. 
  \item \code{MaxInt.Screeplot}: Plot all (P, Q) clustering combinations so that we can decide the optimal ones. 
  \item \code{MaxInteraction.plot}: Plot the resulting of maximal interaction two-mode clustering for optimal choice.
  \item \code{MaxInt.heatmap.plot}: Generate heatmaps annotated with optimal clustering results.
}
These tools support exploratory data analysis and interpretation of complex interaction structures in two-mode data.
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl), 
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
Maintainer: Zaheer Ahmed (ahmed@ifado.de) 
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\seealso{
\code{\link{MaxInt_data_analysis}}, \code{\link{screeplot.MaxInt_data_analysis}}, \code{\link{MaxInteraction.plot}},
\code{\link{MaxInt.heatmap.plot}}
}
\keyword{Maximal interaction}
