/*
 * Decompiled with CFR 0.152.
 */
package bartMachine;

import bartMachine.StatToolbox;
import bartMachine.bartMachineTreeNode;
import bartMachine.bartMachine_c_debug;
import java.io.Serializable;

public abstract class bartMachine_d_init
extends bartMachine_c_debug
implements Serializable {
    protected transient double fixed_sigsq;
    protected int gibbs_sample_num;
    protected transient double[] sum_resids_vec;

    protected void SetupGibbsSampling() {
        this.InitGibbsSamplingData();
        this.InitizializeSigsq();
        this.InitializeTrees();
        this.InitializeMus();
        if (this.tree_illust) {
            this.InitTreeIllustrations();
        }
        this.gibbs_sample_num = 1;
        this.sum_resids_vec = new double[this.n];
    }

    protected void InitGibbsSamplingData() {
        this.gibbs_samples_of_bart_trees = new bartMachineTreeNode[this.num_gibbs_total_iterations + 1][this.num_trees];
        this.gibbs_samples_of_bart_trees_after_burn_in = new bartMachineTreeNode[this.num_gibbs_total_iterations - this.num_gibbs_burn_in + 1][this.num_trees];
        this.gibbs_samples_of_sigsq = new double[this.num_gibbs_total_iterations + 1];
        this.gibbs_samples_of_sigsq_after_burn_in = new double[this.num_gibbs_total_iterations - this.num_gibbs_burn_in];
        this.accept_reject_mh = new boolean[this.num_gibbs_total_iterations + 1][this.num_trees];
        this.accept_reject_mh_steps = new char[this.num_gibbs_total_iterations + 1][this.num_trees];
    }

    protected void InitializeTrees() {
        bartMachineTreeNode[] bartMachineTreeNodeArray = new bartMachineTreeNode[this.num_trees];
        for (int i = 0; i < this.num_trees; ++i) {
            bartMachineTreeNode bartMachineTreeNode2 = new bartMachineTreeNode(this);
            bartMachineTreeNode2.setStumpData(this.X_y, this.y_trans, this.p);
            bartMachineTreeNodeArray[i] = bartMachineTreeNode2;
        }
        this.gibbs_samples_of_bart_trees[0] = bartMachineTreeNodeArray;
    }

    protected void InitializeMus() {
        for (bartMachineTreeNode bartMachineTreeNode2 : this.gibbs_samples_of_bart_trees[0]) {
            bartMachineTreeNode2.y_pred = 0.0;
        }
    }

    protected void InitizializeSigsq() {
        this.gibbs_samples_of_sigsq[0] = StatToolbox.sample_from_inv_gamma(this.hyper_nu / 2.0, 2.0 / (this.hyper_nu * this.hyper_lambda));
        this.updateLogSigsqTable(this.gibbs_samples_of_sigsq[0]);
    }

    public int numSamplesAfterBurningAndThinning() {
        return this.num_gibbs_total_iterations - this.num_gibbs_burn_in;
    }

    public void setNumGibbsBurnIn(int n) {
        this.num_gibbs_burn_in = n;
    }

    public void setNumGibbsTotalIterations(int n) {
        this.num_gibbs_total_iterations = n;
    }

    public void setSigsq(double d) {
        this.fixed_sigsq = d;
    }

    public boolean[][] getAcceptRejectMH() {
        return this.accept_reject_mh;
    }
}

