/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import java.util.List;
import ucar.nc2.Attribute;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CancelTask;

public class EpicInsitu
extends CoordSysBuilder {
    public EpicInsitu() {
        this.conventionName = "EpicInsitu";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        List<Variable> vars = ds.getVariables();
        this.findAxes(vars);
        ds.finish();
    }

    private void findAxes(List<Variable> vars) {
        for (Variable v : vars) {
            this.checkIfAxis(v);
            if (!(v instanceof Structure)) continue;
            List<Variable> nested = ((Structure)v).getVariables();
            this.findAxes(nested);
        }
    }

    private void checkIfAxis(Variable v) {
        Attribute att = v.findAttributeIgnoreCase("axis");
        if (att == null) {
            return;
        }
        String axisType = att.getStringValue();
        if (axisType.equalsIgnoreCase("X")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        } else if (axisType.equalsIgnoreCase("Y")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        } else if (axisType.equalsIgnoreCase("Z")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
        } else if (axisType.equalsIgnoreCase("T")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        }
    }
}

