/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.UUID;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import org.apache.sis.measure.Units;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Locales;
import org.apache.sis.xml.LegacyCodes;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.NilReason;

public class ValueConverter {
    public static final ValueConverter DEFAULT = new ValueConverter();

    protected ValueConverter() {
    }

    protected <T> boolean exceptionOccured(MarshalContext marshalContext, T t, Class<T> clazz, Class<?> clazz2, Exception exception) {
        return false;
    }

    public String toLanguageCode(MarshalContext marshalContext, Locale locale) throws MissingResourceException {
        if (locale != null) {
            String string;
            try {
                string = locale.getISO3Language();
            }
            catch (MissingResourceException missingResourceException) {
                if (!this.exceptionOccured(marshalContext, locale, Locale.class, String.class, missingResourceException)) {
                    throw missingResourceException;
                }
                string = locale.getLanguage();
            }
            if (!string.isEmpty()) {
                return string;
            }
        }
        return null;
    }

    public String toCountryCode(MarshalContext marshalContext, Locale locale) throws MissingResourceException {
        String string;
        if (locale != null && !(string = locale.getCountry()).isEmpty()) {
            return string;
        }
        return null;
    }

    public String toCharsetCode(MarshalContext marshalContext, Charset charset) {
        if (charset != null) {
            return LegacyCodes.fromIANA(charset.name());
        }
        return null;
    }

    public Locale toLocale(MarshalContext marshalContext, String string) throws IllformedLocaleException {
        block3: {
            if ((string = CharSequences.trimWhitespaces(string)) != null && !string.isEmpty()) {
                try {
                    return Locales.parse(string);
                }
                catch (IllformedLocaleException illformedLocaleException) {
                    if (this.exceptionOccured(marshalContext, string, String.class, Locale.class, illformedLocaleException)) break block3;
                    throw illformedLocaleException;
                }
            }
        }
        return null;
    }

    public Charset toCharset(MarshalContext marshalContext, String string) throws IllegalCharsetNameException {
        block3: {
            if ((string = CharSequences.trimWhitespaces(string)) != null && !string.isEmpty()) {
                string = LegacyCodes.toIANA(string);
                try {
                    return Charset.forName(string);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    if (this.exceptionOccured(marshalContext, string, String.class, Charset.class, illegalCharsetNameException)) break block3;
                    throw illegalCharsetNameException;
                }
            }
        }
        return null;
    }

    public Unit<?> toUnit(MarshalContext marshalContext, String string) throws IllegalArgumentException {
        block3: {
            if ((string = CharSequences.trimWhitespaces(string)) != null && !string.isEmpty()) {
                try {
                    return Units.valueOf(string);
                }
                catch (ParserException parserException) {
                    if (this.exceptionOccured(marshalContext, string, String.class, Unit.class, parserException)) break block3;
                    throw parserException;
                }
            }
        }
        return null;
    }

    public UUID toUUID(MarshalContext marshalContext, String string) throws IllegalArgumentException {
        block3: {
            if ((string = CharSequences.trimWhitespaces(string)) != null && !string.isEmpty()) {
                try {
                    return UUID.fromString(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.exceptionOccured(marshalContext, string, String.class, UUID.class, illegalArgumentException)) break block3;
                    throw illegalArgumentException;
                }
            }
        }
        return null;
    }

    public URI toURI(MarshalContext marshalContext, String string) throws URISyntaxException {
        block3: {
            if ((string = CharSequences.trimWhitespaces(string)) != null && !string.isEmpty()) {
                try {
                    return new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (this.exceptionOccured(marshalContext, string, String.class, URI.class, uRISyntaxException)) break block3;
                    throw uRISyntaxException;
                }
            }
        }
        return null;
    }

    public URI toURI(MarshalContext marshalContext, URL uRL) throws URISyntaxException {
        block3: {
            if (uRL != null) {
                try {
                    return uRL.toURI();
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (this.exceptionOccured(marshalContext, uRL, URL.class, URI.class, uRISyntaxException)) break block3;
                    throw uRISyntaxException;
                }
            }
        }
        return null;
    }

    public URL toURL(MarshalContext marshalContext, URI uRI) throws MalformedURLException {
        block3: {
            if (uRI != null) {
                try {
                    return uRI.toURL();
                }
                catch (IllegalArgumentException | MalformedURLException exception) {
                    if (this.exceptionOccured(marshalContext, uRI, URI.class, URL.class, exception)) break block3;
                    throw exception;
                }
            }
        }
        return null;
    }

    public NilReason toNilReason(MarshalContext marshalContext, String string) throws URISyntaxException {
        block3: {
            if ((string = CharSequences.trimWhitespaces(string)) != null && !string.isEmpty()) {
                try {
                    return NilReason.valueOf(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (this.exceptionOccured(marshalContext, string, String.class, URI.class, uRISyntaxException)) break block3;
                    throw uRISyntaxException;
                }
            }
        }
        return null;
    }
}

