# Generated by default/object.tt
package Paws::AccessAnalyzer::S3PublicAccessBlockConfiguration;
  use Moose;
  has IgnorePublicAcls => (is => 'ro', isa => 'Bool', request_name => 'ignorePublicAcls', traits => ['NameInRequest'], required => 1);
  has RestrictPublicBuckets => (is => 'ro', isa => 'Bool', request_name => 'restrictPublicBuckets', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::S3PublicAccessBlockConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::S3PublicAccessBlockConfiguration object:

  $service_obj->Method(Att1 => { IgnorePublicAcls => $value, ..., RestrictPublicBuckets => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::S3PublicAccessBlockConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->IgnorePublicAcls

=head1 DESCRIPTION

The C<PublicAccessBlock> configuration to apply to this Amazon S3
bucket. If the proposed configuration is for an existing Amazon S3
bucket and the configuration is not specified, the access preview uses
the existing setting. If the proposed configuration is for a new bucket
and the configuration is not specified, the access preview uses
C<false>. If the proposed configuration is for a new access point and
the access point BPA configuration is not specified, the access preview
uses C<true>. For more information, see PublicAccessBlockConfiguration
(https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html).

=head1 ATTRIBUTES


=head2 B<REQUIRED> IgnorePublicAcls => Bool

Specifies whether Amazon S3 should ignore public ACLs for this bucket
and objects in this bucket.


=head2 B<REQUIRED> RestrictPublicBuckets => Bool

Specifies whether Amazon S3 should restrict public bucket policies for
this bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

