# Generated by default/object.tt
package Paws::FIS::ExperimentAction;
  use Moose;
  has ActionId => (is => 'ro', isa => 'Str', request_name => 'actionId', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Parameters => (is => 'ro', isa => 'Paws::FIS::ExperimentActionParameterMap', request_name => 'parameters', traits => ['NameInRequest']);
  has StartAfter => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'startAfter', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Paws::FIS::ExperimentActionState', request_name => 'state', traits => ['NameInRequest']);
  has Targets => (is => 'ro', isa => 'Paws::FIS::ExperimentActionTargetMap', request_name => 'targets', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FIS::ExperimentAction

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FIS::ExperimentAction object:

  $service_obj->Method(Att1 => { ActionId => $value, ..., Targets => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FIS::ExperimentAction object:

  $result = $service_obj->Method(...);
  $result->Att1->ActionId

=head1 DESCRIPTION

Describes the action for an experiment.

=head1 ATTRIBUTES


=head2 ActionId => Str

The ID of the action.


=head2 Description => Str

The description for the action.


=head2 Parameters => L<Paws::FIS::ExperimentActionParameterMap>

The parameters for the action.


=head2 StartAfter => ArrayRef[Str|Undef]

The name of the action that must be completed before this action
starts.


=head2 State => L<Paws::FIS::ExperimentActionState>

The state of the action.


=head2 Targets => L<Paws::FIS::ExperimentActionTargetMap>

The targets for the action.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FIS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

