/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Scrollable;

class ScrollablePicture
extends JLabel
implements Scrollable,
MouseMotionListener {
    private int maxUnitIncrement = 1;
    private boolean missingPicture = false;

    public ScrollablePicture(ImageIcon imageIcon, int n) {
        super(imageIcon);
        if (imageIcon == null) {
            this.missingPicture = true;
            this.setText("No picture found.");
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            this.setBackground(Color.white);
        }
        this.maxUnitIncrement = n;
        this.setAutoscrolls(true);
        this.addMouseMotionListener(this);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 1, 1);
        this.scrollRectToVisible(rectangle);
    }

    public Dimension getPreferredSize() {
        if (this.missingPicture) {
            return new Dimension(320, 480);
        }
        return super.getPreferredSize();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 0;
        n3 = n == 0 ? rectangle.x : rectangle.y;
        if (n2 < 0) {
            int n4 = n3 - n3 / this.maxUnitIncrement * this.maxUnitIncrement;
            return n4 == 0 ? this.maxUnitIncrement : n4;
        }
        return (n3 / this.maxUnitIncrement + 1) * this.maxUnitIncrement - n3;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width - this.maxUnitIncrement;
        }
        return rectangle.height - this.maxUnitIncrement;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setMaxUnitIncrement(int n) {
        this.maxUnitIncrement = n;
    }
}

