# Generated by default/object.tt
package Paws::WorkMail::MobileDeviceAccessRule;
  use Moose;
  has DateCreated => (is => 'ro', isa => 'Str');
  has DateModified => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has DeviceModels => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has DeviceOperatingSystems => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has DeviceTypes => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has DeviceUserAgents => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Effect => (is => 'ro', isa => 'Str');
  has MobileDeviceAccessRuleId => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has NotDeviceModels => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has NotDeviceOperatingSystems => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has NotDeviceTypes => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has NotDeviceUserAgents => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WorkMail::MobileDeviceAccessRule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WorkMail::MobileDeviceAccessRule object:

  $service_obj->Method(Att1 => { DateCreated => $value, ..., NotDeviceUserAgents => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WorkMail::MobileDeviceAccessRule object:

  $result = $service_obj->Method(...);
  $result->Att1->DateCreated

=head1 DESCRIPTION

A rule that controls access to mobile devices for an Amazon WorkMail
group.

=head1 ATTRIBUTES


=head2 DateCreated => Str

The date and time at which an access rule was created.


=head2 DateModified => Str

The date and time at which an access rule was modified.


=head2 Description => Str

The description of a mobile access rule.


=head2 DeviceModels => ArrayRef[Str|Undef]

Device models that a rule will match.


=head2 DeviceOperatingSystems => ArrayRef[Str|Undef]

Device operating systems that a rule will match.


=head2 DeviceTypes => ArrayRef[Str|Undef]

Device types that a rule will match.


=head2 DeviceUserAgents => ArrayRef[Str|Undef]

Device user agents that a rule will match.


=head2 Effect => Str

The effect of the rule when it matches. Allowed values are C<ALLOW> or
C<DENY>.


=head2 MobileDeviceAccessRuleId => Str

The ID assigned to a mobile access rule.


=head2 Name => Str

The name of a mobile access rule.


=head2 NotDeviceModels => ArrayRef[Str|Undef]

Device models that a rule B<will not> match. All other device models
will match.


=head2 NotDeviceOperatingSystems => ArrayRef[Str|Undef]

Device operating systems that a rule B<will not> match. All other
device types will match.


=head2 NotDeviceTypes => ArrayRef[Str|Undef]

Device types that a rule B<will not> match. All other device types will
match.


=head2 NotDeviceUserAgents => ArrayRef[Str|Undef]

Device user agents that a rule B<will not> match. All other device user
agents will match.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WorkMail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

