package Daje::Controller::Workflows::Workflows;
use Mojo::Base 'Mojolicious::Controller', -signatures;
use v5.42;

# NAME
# ====
#
# Daje::Controller::Workflow::Workflow - Mojolicious controller for Daje::Workflow
#
# SYNOPSIS
# ========
#
#     use Daje::Controller::Workflow::Workflow;
#
#     Expected indata format
#
#     'workflow' => {
#                      'workflow' => 'Workflow name',
#                      'activity' => 'name of activity',
#                      'workflow_pkey' => ,
#                      'connector' => 'Name of the connector to the workflow Optional if the workflow_pkey > 0'

#                    },
#      'payload' => {
#                        Something the activity understands
#                    }
#        }
#
#
# DESCRIPTION
# ===========
#
# Daje::Controller::Workflow::Workflow is the controller for accessing Daje::Workflow
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#
#

use Data::Dumper;
use Mojo::JSON qw{decode_json};
use Daje::Workflow::Database::Model;


sub execute($self) {

    # $self->render_later;
    $self->app->log->debug('Daje::Controller::Workflow::Workflow::execute');
    try {
        my ($companies_pkey, $users_pkey) = $self->jwt->companies_users_pkey(
            $self->req->headers->header('X-Token-Check')
        );

        $self->app->log->debug('Daje::Controller::Workflows::Workflows::execute '  . Dumper($self->req->body));

        my $data->{context} = decode_json ($self->req->body);
        $data->{context}->{users_fkey} = $users_pkey;
        $data->{context}->{companies_fkey} = $companies_pkey;
    #
    # push @{$data->{actions}}, "$self->stash('wf_action')";
    # $data->{workflow}->{workflow} = $self->stash('workflow');
    # $data->{workflow}->{workflow_relation} = $self->stash('workflow_relation');
    # $data->{workflow}->{workflow_relation_key} = $self->stash('workflow_relation_key');
    # $data->{workflow}->{workflow_origin_key} = $self->stash('workflow_origin_key');
    #
    # say Dumper ($data);

        if(exists $data->{context}->{payload}->{workflow_fkey}) {
            $self->workflow_engine->workflow_pkey($data->{context}->{payload}->{workflow_fkey});
        } else {
            $self->workflow_engine->workflow_pkey($data->{context}->{workflow}->{workflow_fkey});
        }
        $self->workflow_engine->workflow_name($data->{context}->{workflow}->{workflow});
        $self->workflow_engine->context($data);
        $self->workflow_engine->process($data->{context}->{workflow}->{activity});
        if($self->workflow_engine->error->has_error() == 0) {
            $self->render(json => {result => 1, data => 'OK'});
        } else {
            $self->app->log->error('Daje::Controller::Workflows::Workflows::execute ' . $self->workflow_engine->error->error());
            $self->render(json =>
                {result => 0, data => $self->workflow_engine->error->error()}
            );
        }
    } catch ($e) {
        $self->app->log->error('Daje::Controller::Workflows::Workflows::execute ' . $e);
        $self->render(json => {result => 0, data => $e});
    };
    $self->app->log->debug('Daje::Controller::Workflows::Workflows::execute ends');
}
1;
__END__










#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Controller::Workflow::Workflow - Mojolicious controller for Daje::Workflow



=head1 SYNOPSIS


    use Daje::Controller::Workflow::Workflow;

    Expected indata format

    'workflow' => {
                     'workflow' => 'Workflow name',
                     'activity' => 'name of activity',
                     'workflow_pkey' => ,
                     'connector' => 'Name of the connector to the workflow Optional if the workflow_pkey > 0'


=head1 REQUIRES

L<Daje::Controller::Workflow> 

L<Daje::Workflow::Database::Model> 

L<Mojo::JSON> 

L<Data::Dumper> 

L<v5.42> 

L<Mojo::Base> 


=head1 METHODS

=head2 execute($self)

 execute($self)();


=cut

