package Amazon::API::Pod::Parser;

use strict;
use warnings;

use Amazon::API::Pod::Simple::Text;

use parent qw{Exporter};

use Carp;
use IO::Scalar;
use Readonly;

Readonly::Scalar my $EMPTY => q{};

our $VERSION = '0.01';

our @EXPORT_OK = qw{ get_pod_section };

caller or __PACKAGE__->main(@ARGV);

########################################################################
sub get_pod_section {
########################################################################
  my ( $file, $section ) = @_;

  croak "no such file [$file]\n",
    if !-e $file;

  my $pod_simple = Amazon::API::Pod::Simple::Text->new;

  if ($section) {
    $Amazon::API::Pod::Simple::Text::SECTION = $section;
  }

  my $output = $EMPTY;

  my $fh = IO::Scalar->new( \$output );

  $pod_simple->output_fh($fh);
  $pod_simple->parse_file($file);

  # strip leading/trailing blank lines
  $output =~ s/\s*\n+\z//xsm;
  $output =~ s/\A\s*\s\n+(.*)\z/$1/xsm;

  return $output;

}

########################################################################
sub main {
########################################################################
  my ( $self, $file, $section ) = @_;

  print get_pod_section( $file, $section );

  exit 0;
}

1;

