/*-
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * Copyright (c) 2003 Sam Leffler, Errno Consulting
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    similar to the "NO WARRANTY" disclaimer below ("Disclaimer") and any
 *    redistribution must be conditioned upon including a substantially
 *    similar Disclaimer requirement for further binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF NONINFRINGEMENT, MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES.
 */

#ifndef _NETINET_IP_DIVERT_H_
#define	_NETINET_IP_DIVERT_H_
#include <sys/types.h>

/*
 * All communication occurs through a sockaddr_in socket where
 *
 * kernel-->userland
 *	sin_port = matching rule, host format;
 * 	sin_addr = IN: first address of the incoming interface;
 *		   OUT: INADDR_ANY
 *	sin_zero = if fits, the interface name (max 7 bytes + NUL)
 *
 * userland->kernel
 *	sin_port = restart-rule - 1, host order
 *		(we restart at sin_port + 1)
 *	sin_addr = IN: address of the incoming interface;
 *		   OUT: INADDR_ANY
 */

struct divstat {
	uint64_t	div_diverted;	/* successfully diverted to userland */
	uint64_t	div_noport;	/* failed due to no bound socket */
	uint64_t	div_outbound;	/* re-injected as outbound */
	uint64_t	div_inbound;	/* re-injected as inbound */
};
#endif /* _NETINET_IP_DIVERT_H_ */
