/*-
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Copyright (C) 2020 Dimitar Toshkov Zhekov.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * This is the "Terminus BSD Console" font.  It is identical to the standard
 * variant of Terminus Font 8x16, but provided under the 2-clause BSD License
 * (FreeBSD License).  Please contribute any changes back to Mr. Zhekov at
 * <dimitar.zhekov@gmail.com>.
 */

#include <dev/vt/vt.h>

static uint8_t font_bytes[2331 * 16] = {
	0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x7e, 0x24, 0x24,
	0x7e, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c,
	0x92, 0x90, 0x90, 0x7c, 0x12, 0x12, 0x92, 0x7c, 0x10, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x64, 0x94, 0x68, 0x08, 0x10, 0x10, 0x20, 0x2c, 0x52, 0x4c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x30, 0x4a,
	0x44, 0x44, 0x44, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x24, 0x18, 0x7e, 0x18, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10,
	0x20, 0x20, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x46, 0x4a, 0x52, 0x62, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x04, 0x08,
	0x10, 0x20, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x02, 0x1c, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x7e, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7c, 0x02,
	0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20,
	0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x3c, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x04, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
	0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04,
	0x08, 0x10, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x42, 0x04, 0x08, 0x08, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x82, 0x9e, 0xa2, 0xa2, 0xa2, 0xa6, 0x9a, 0x80, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x7e,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42,
	0x42, 0x42, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x44, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x44, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40,
	0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x4e,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x44,
	0x48, 0x50, 0x60, 0x60, 0x50, 0x48, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xaa, 0x92, 0x92, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c,
	0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x4a, 0x3c, 0x02, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x50, 0x48, 0x44, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x3c, 0x02,
	0x02, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24,
	0x24, 0x24, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x92, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02,
	0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10,
	0x08, 0x08, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x10, 0x08, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42,
	0x7e, 0x40, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10,
	0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x04, 0x00, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x42, 0x44, 0x48,
	0x70, 0x48, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c,
	0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x5e, 0x60, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x92,
	0x92, 0x92, 0x92, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x42, 0x24, 0x18, 0x24, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x08,
	0x10, 0x20, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x10,
	0x10, 0x10, 0x20, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x04, 0x08,
	0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x92, 0x8c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x92, 0x90,
	0x90, 0x90, 0x92, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x20, 0x20, 0x78, 0x20, 0x20, 0x20, 0x22, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x44, 0x38, 0x44, 0x44, 0x44, 0x38, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x28, 0x10, 0x7c,
	0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x44, 0x40, 0x30, 0x48, 0x44, 0x44, 0x24, 0x18, 0x04, 0x44,
	0x38, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e,
	0x81, 0x99, 0xa5, 0xa1, 0xa5, 0x99, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x04, 0x3c, 0x44, 0x3c, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x24, 0x48,
	0x90, 0x48, 0x24, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x81, 0xb9, 0xa5, 0xb9,
	0xa9, 0xa5, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c,
	0x10, 0x10, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x04,
	0x08, 0x10, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x04, 0x18, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x7a, 0x40, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x7e, 0x92, 0x92, 0x92, 0x92, 0x72, 0x12, 0x12, 0x12, 0x12,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0x00,
	0x00, 0x10, 0x30, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x90, 0x48, 0x24, 0x12, 0x24, 0x48, 0x90, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x20, 0x60, 0x20, 0x22, 0x24, 0x08, 0x10, 0x22, 0x46, 0x8a, 0x1e,
	0x02, 0x02, 0x00, 0x00, 0x00, 0x20, 0x60, 0x20, 0x22, 0x24, 0x08, 0x10,
	0x20, 0x4c, 0x92, 0x04, 0x08, 0x1e, 0x00, 0x00, 0x00, 0xe0, 0x10, 0x60,
	0x12, 0xe4, 0x08, 0x10, 0x22, 0x46, 0x8a, 0x1e, 0x02, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x00, 0x10, 0x10, 0x20, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3c,
	0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c,
	0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x24, 0x18, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x90, 0x90, 0x90, 0xfc, 0x90,
	0x90, 0x90, 0x90, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x10, 0x10, 0x20, 0x00,
	0x10, 0x08, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78,
	0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x7e,
	0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x24, 0x24, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x38,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x24, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x44,
	0x42, 0x42, 0xf2, 0x42, 0x42, 0x42, 0x44, 0x78, 0x00, 0x00, 0x00, 0x00,
	0x32, 0x4c, 0x00, 0x42, 0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3c,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x43, 0x42, 0x46, 0x4a, 0x52,
	0x62, 0x42, 0xc2, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x10, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x10, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42,
	0x42, 0x7c, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44,
	0x44, 0x48, 0x7c, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x08, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3c, 0x02, 0x3e,
	0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x32, 0x4c, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c, 0x02, 0x3e,
	0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x18, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x12, 0x72, 0x9e, 0x90, 0x90, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40,
	0x40, 0x40, 0x42, 0x3c, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x10, 0x08,
	0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x3c, 0x42, 0x42,
	0x7e, 0x40, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24,
	0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x10, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x30, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48,
	0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x48, 0x48, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x28, 0x3c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4c,
	0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x32, 0x4c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x00, 0x7c, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x3c, 0x46, 0x4a, 0x52, 0x62, 0x42, 0xbc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00,
	0x00, 0x00, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c,
	0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x42,
	0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18,
	0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42,
	0x02, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x3e,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x04, 0x03, 0x00, 0x08, 0x10, 0x00, 0x3c,
	0x42, 0x42, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40,
	0x40, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x3c, 0x42, 0x40,
	0x40, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x3c,
	0x42, 0x42, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x18, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x78, 0x44, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x44, 0x78, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x02, 0x02,
	0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x0f, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40,
	0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
	0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x24, 0x18, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x3c, 0x42, 0x42,
	0x7e, 0x40, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x7e,
	0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40,
	0x40, 0x40, 0x40, 0x7e, 0x02, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x3c, 0x08, 0x10, 0x0c, 0x00,
	0x18, 0x24, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x4e, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x3e, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00, 0x24, 0x18, 0x00, 0x3c,
	0x42, 0x40, 0x40, 0x4e, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x18, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x3c, 0x00, 0x10, 0x10, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x4e,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08,
	0x00, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x4e, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x10, 0x10, 0x20, 0x00, 0x04, 0x08, 0x08, 0x00, 0x3e, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00, 0x18, 0x24, 0x00, 0x42,
	0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x0c, 0x12, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0x42, 0x42, 0x7e, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf0,
	0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x32, 0x4c, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x58, 0x00, 0x30, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x38, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x78, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x30,
	0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x10, 0x20, 0x18, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x30, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x10, 0x20, 0x18, 0x00, 0x10, 0x10, 0x00, 0x38,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x52, 0x52, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x00, 0xc6, 0x42, 0x42, 0x42, 0x42, 0x42, 0xe2, 0x12, 0x12, 0x0c, 0x00,
	0x0c, 0x12, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x44, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x00, 0x0c, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x42, 0x44,
	0x48, 0x50, 0x60, 0x60, 0x50, 0x48, 0x44, 0x42, 0x00, 0x10, 0x10, 0x20,
	0x00, 0x00, 0x40, 0x40, 0x40, 0x42, 0x44, 0x48, 0x70, 0x48, 0x44, 0x42,
	0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x44, 0x48,
	0x70, 0x48, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x00, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x10, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x7e, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x30, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x10, 0x10, 0x20,
	0x24, 0x18, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x48, 0x30, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40,
	0x40, 0x40, 0x44, 0x44, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x30, 0x10, 0x10, 0x10, 0x11, 0x11, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x60, 0xc0,
	0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10,
	0x10, 0x10, 0x18, 0x30, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x10, 0x42, 0x42, 0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x42, 0x00, 0x10, 0x10, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x10, 0x10, 0x20, 0x24, 0x18, 0x42, 0x42, 0x42, 0x62, 0x52, 0x4a,
	0x46, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18,
	0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x80, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x62, 0x52, 0x4a,
	0x46, 0x42, 0x42, 0x42, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x02, 0x02, 0x0c, 0x00,
	0x3c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x3c,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x18, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x12, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x24,
	0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x90, 0x90, 0x90, 0x9c, 0x90, 0x90, 0x90, 0x90, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x92, 0x92,
	0x9e, 0x90, 0x90, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x7c,
	0x42, 0x42, 0x42, 0x7c, 0x50, 0x48, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x00, 0x5e, 0x60, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c,
	0x50, 0x48, 0x44, 0x42, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x5e, 0x60, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x40, 0x40, 0x80,
	0x24, 0x18, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x7c, 0x50, 0x48, 0x44, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x5e, 0x60, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3c,
	0x42, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x08, 0x00, 0x3e, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x3c,
	0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x00, 0x3e, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x42, 0x42, 0x3c,
	0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40,
	0x3c, 0x02, 0x02, 0x7c, 0x10, 0x10, 0x20, 0x00, 0x24, 0x18, 0x00, 0x3c,
	0x42, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x18, 0x00, 0x3e, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0e, 0x04, 0x04, 0x08, 0x00,
	0x24, 0x18, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10,
	0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x38, 0x10, 0x10, 0x10, 0x0e,
	0x00, 0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4c,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x3c, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x18, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x18, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x18, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x12, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x24, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x08, 0x10, 0x0c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x04, 0x03, 0x00, 0x18, 0x24, 0x00, 0x82, 0x82, 0x82, 0x82, 0x92,
	0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x00, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x24, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00, 0x44, 0x44, 0x00, 0x82,
	0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x10, 0x00, 0x7e, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x7e, 0x04, 0x08,
	0x10, 0x20, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x7e,
	0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x00, 0x7e, 0x04, 0x08, 0x10, 0x20, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x7e, 0x02, 0x04, 0x08, 0x10,
	0x20, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18,
	0x00, 0x7e, 0x04, 0x08, 0x10, 0x20, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0e, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02,
	0x02, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02,
	0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x38, 0x40,
	0x40, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12,
	0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x90, 0x60, 0x00,
	0x00, 0x00, 0x42, 0x42, 0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x42,
	0x40, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x7e, 0x02,
	0x04, 0x08, 0x7e, 0x10, 0x20, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x08, 0x7c, 0x10, 0x20, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x04, 0x08, 0x1c, 0x02,
	0x02, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7e, 0x90,
	0x90, 0x90, 0xfc, 0x90, 0x90, 0x90, 0x90, 0x9e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0x00, 0x6c, 0x12, 0x72, 0x9e, 0x90, 0x90, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x4e,
	0x42, 0x4f, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3e, 0x42, 0x42, 0x4f, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00,
	0x24, 0x18, 0x42, 0x44, 0x48, 0x50, 0x60, 0x60, 0x50, 0x48, 0x44, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x40, 0x40, 0x40, 0x42, 0x44, 0x48,
	0x70, 0x48, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x08, 0x10, 0x0c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x08, 0x10, 0x0c, 0x00, 0x3c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x08, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x3c,
	0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x08, 0x10, 0x0c, 0x00,
	0x24, 0x18, 0x00, 0x7e, 0x04, 0x08, 0x1c, 0x02, 0x02, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x7e, 0x02, 0x04,
	0x08, 0x1c, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x12, 0x0c,
	0x00, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x44, 0x38, 0x00,
	0x08, 0x10, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x4e, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x00, 0x3e, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00, 0x08, 0x10, 0x00, 0x7e,
	0x90, 0x90, 0x90, 0xfc, 0x90, 0x90, 0x90, 0x9e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x00, 0x6c, 0x12, 0x72, 0x9e, 0x90, 0x90, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3d, 0x42, 0x46, 0x4a, 0x52,
	0x62, 0x42, 0xc2, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10,
	0x02, 0x3c, 0x46, 0x4a, 0x52, 0x62, 0x42, 0xbc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x42, 0x42, 0x3c,
	0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40,
	0x3c, 0x02, 0x02, 0x7c, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0xfe, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x20,
	0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0e,
	0x00, 0x04, 0x04, 0x08, 0x7c, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02,
	0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x02, 0x7e, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40,
	0x38, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x40, 0x40, 0x80, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x04, 0x08, 0x1c, 0x02, 0x02,
	0x42, 0x42, 0x3c, 0x00, 0x08, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x0c, 0x00, 0x32, 0x4c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x12, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x10, 0x00, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x24,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x40, 0x80, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x7e, 0x40,
	0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x40, 0x80, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x3c, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x40, 0x80, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x24, 0x24, 0x66, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x48, 0x48,
	0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44,
	0x44, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x42, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x44, 0x82, 0x82, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x3c, 0x00,
	0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x08, 0x10, 0x20, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92,
	0x92, 0x92, 0x7c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92,
	0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x24, 0x66,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3a, 0x46, 0x44,
	0x44, 0x44, 0x46, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10,
	0x00, 0x3c, 0x42, 0x40, 0x38, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x30, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x24,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x44, 0x44, 0x44, 0x46, 0x3a,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x48, 0x7c, 0x42,
	0x42, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x3e, 0x10, 0x08, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x08, 0x10, 0x20, 0x40,
	0x40, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x38, 0x44,
	0x44, 0x44, 0x7c, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x10, 0x10, 0x28, 0x28,
	0x44, 0x44, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40,
	0x40, 0x40, 0x3c, 0x40, 0x40, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c,
	0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24,
	0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x48, 0x00, 0x30, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x44, 0x82, 0x92,
	0x92, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44,
	0x44, 0x44, 0x3e, 0x04, 0xc4, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x24, 0x18,
	0x10, 0x30, 0x48, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x3c, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x40,
	0x7c, 0x40, 0x20, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x78, 0x04, 0x02, 0x3e, 0x02, 0x04, 0x78, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xf8, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x30, 0x50, 0x90, 0x9c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x9c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x90, 0x90, 0x9c, 0xf2, 0x92,
	0x92, 0x92, 0x92, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x20,
	0x20, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x10, 0x42, 0x44, 0x48, 0x50, 0x60, 0x60, 0x50, 0x48, 0x44, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x42, 0x42, 0x42, 0x46, 0x4a, 0x52,
	0x62, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e,
	0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x40, 0x40, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x44,
	0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xfe, 0x82, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x92, 0x92, 0x92, 0x54, 0x38, 0x54, 0x92, 0x92, 0x92, 0x92,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x46, 0x4a, 0x52,
	0x62, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x42, 0x42,
	0x42, 0x46, 0x4a, 0x52, 0x62, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0e, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0x92,
	0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3f,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92,
	0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7f,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x40, 0x40, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82,
	0x82, 0xf2, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0xf2, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x92, 0x92, 0x92, 0x92, 0xf2,
	0x92, 0x92, 0x92, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x0a, 0x12, 0x22, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x48, 0x7c, 0x42,
	0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x54, 0x38, 0x54, 0x92, 0x92,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02,
	0x1c, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xaa, 0x92, 0x82, 0x82, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42,
	0x7e, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3f,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42,
	0x3e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7f,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x20, 0x3c,
	0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x82, 0x82, 0xf2, 0x8a, 0x8a, 0x8a, 0xf2, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x78, 0x44, 0x44, 0x44, 0x78,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02,
	0x1e, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x8c, 0x92, 0x92, 0xf2, 0x92, 0x92, 0x8c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf0, 0x40, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x10,
	0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x78, 0x40, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x90, 0x9c,
	0x92, 0x92, 0x92, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x90, 0x90, 0x9c, 0xf2, 0x92, 0x92, 0x9c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x00, 0x42, 0x44, 0x48, 0x70, 0x48, 0x44, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x40, 0xf0, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x78, 0x20, 0x20, 0x3c,
	0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82,
	0x44, 0x28, 0x38, 0x54, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x44, 0x28, 0x38, 0x54, 0x92, 0x92,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x02, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0xf8, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40,
	0xf8, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40,
	0x40, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x02, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x78, 0x44, 0x44, 0x44,
	0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x54, 0x38, 0x54,
	0x92, 0x92, 0x92, 0x93, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x92, 0x92, 0x54, 0x38, 0x54, 0x92, 0x93, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x1c, 0x02, 0x02, 0x42, 0x42, 0x3c,
	0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02,
	0x1c, 0x02, 0x42, 0x3c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x42, 0x44,
	0x48, 0x50, 0x60, 0x60, 0x50, 0x48, 0x44, 0x43, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x44, 0x48, 0x70, 0x48, 0x44, 0x43,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x54, 0x58, 0x70, 0x70,
	0x58, 0x54, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x54, 0x58, 0x70, 0x58, 0x54, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc2, 0x44, 0x48, 0x50, 0x60, 0x60, 0x50, 0x48, 0x44, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x44, 0x48,
	0x70, 0x48, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x43, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x43,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x47, 0x44, 0x44, 0x44, 0x7c, 0x44,
	0x44, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x47, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c,
	0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40,
	0x40, 0x40, 0x42, 0x3c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x82, 0x82,
	0x44, 0x44, 0x28, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10,
	0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18,
	0x24, 0x24, 0x42, 0x43, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x42, 0x24, 0x18, 0x24, 0x42, 0x43, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x03,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42,
	0x3e, 0x02, 0x02, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x4a, 0x4a, 0x3e, 0x0a, 0x0a, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x4a, 0x4a, 0x3e, 0x0a, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x7c, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x24, 0x18, 0x00, 0x92, 0x92, 0x92, 0x54, 0x38, 0x54, 0x92, 0x92, 0x92,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x92, 0x92, 0x54,
	0x38, 0x54, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c,
	0x42, 0x02, 0x02, 0x7e, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x24, 0x00, 0x3c, 0x02, 0x02, 0x7e, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x92, 0x92, 0x92, 0x54, 0x38,
	0x54, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44,
	0x00, 0x92, 0x92, 0x54, 0x38, 0x54, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00,
	0x24, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x1c, 0x02, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c, 0x42, 0x02,
	0x1c, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x42, 0x42,
	0x42, 0x46, 0x4a, 0x52, 0x62, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x24, 0x24, 0x00, 0x42, 0x42, 0x42, 0x46, 0x4a, 0x52, 0x62, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42,
	0x7e, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c,
	0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x1e,
	0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24,
	0x00, 0x3c, 0x42, 0x02, 0x1e, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x3c, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x12, 0x24, 0x00, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x12, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x3c, 0x00, 0x24, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24,
	0x00, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x48, 0x48, 0x00, 0x82, 0x82, 0x82, 0xf2, 0x8a, 0x8a, 0x8a, 0x8a, 0xf2,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x48, 0x00, 0x82, 0x82, 0xf2,
	0x8a, 0x8a, 0x8a, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x22, 0x22, 0x14, 0x28, 0x44, 0x44, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x14, 0x24, 0x42, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x02, 0x02, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x08,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x08,
	0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x7e, 0x02,
	0x02, 0x02, 0x02, 0x04, 0x08, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x62, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x22, 0x22, 0x22, 0x14, 0x14, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x32, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x32, 0x02,
	0x02, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x22, 0x24, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x42, 0x42, 0x22, 0x24, 0x18, 0x10, 0x08, 0x08, 0x04, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x42, 0x42, 0x44,
	0x48, 0x48, 0x48, 0x48, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x7c, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0xa2, 0xc2, 0x82, 0x84, 0xf8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x44,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x78, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x42, 0x44, 0x48, 0x50, 0x60, 0x60,
	0x50, 0x48, 0x44, 0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40,
	0x40, 0x42, 0x44, 0x48, 0x70, 0x48, 0x44, 0x42, 0x00, 0x3c, 0x00, 0x00,
	0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x10, 0x10, 0x00, 0x10, 0x10, 0x82, 0xc6,
	0xaa, 0x92, 0x92, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x00, 0xfc, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xaa, 0x92, 0x92, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfc, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x00, 0x10, 0x10, 0x00,
	0x10, 0x10, 0x42, 0x42, 0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x42, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0e, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x40, 0x7e,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42,
	0x7e, 0x40, 0x40, 0x3c, 0x00, 0x10, 0x10, 0x00, 0x32, 0x4c, 0x00, 0x7e,
	0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x32, 0x4c, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x08, 0x08, 0x00, 0x64, 0x98, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4c,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x7e,
	0x00, 0x08, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x24,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24,
	0x48, 0x00, 0x00, 0x00, 0x00, 0x48, 0x48, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c,
	0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x48, 0xa8, 0x50, 0x10, 0x20, 0x20, 0x40, 0x54, 0xaa, 0x94,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24,
	0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08,
	0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24,
	0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x30, 0x10, 0x10, 0x10, 0x38, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x14,
	0x3e, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x20, 0x38, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x20, 0x38, 0x24, 0x24, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x08,
	0x08, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x1c, 0x04, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x10,
	0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x24, 0x24, 0x24, 0x24, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x30, 0x10, 0x10, 0x10,
	0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
	0x24, 0x04, 0x08, 0x10, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x38, 0x04, 0x18, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x14, 0x3e, 0x04,
	0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38,
	0x20, 0x38, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0x20, 0x38, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x04, 0x08, 0x08, 0x10,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
	0x24, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x1c, 0x04, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x10,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x10, 0x10, 0x10,
	0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
	0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x1c, 0x24, 0x1c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x3c, 0x20,
	0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x3c, 0x24,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20,
	0x38, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x20, 0x24, 0x28, 0x30, 0x28, 0x24, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x78, 0x54, 0x54, 0x54, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x24, 0x24, 0x24, 0x38, 0x20, 0x20, 0x00,
	0x00, 0x00, 0xf0, 0x88, 0x88, 0x88, 0xf4, 0x84, 0x8e, 0x84, 0x84, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf2, 0x8a, 0x8a, 0xaa, 0xaa, 0xaa,
	0xaa, 0xa2, 0xa2, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c,
	0x22, 0x40, 0xf8, 0x40, 0xf8, 0x40, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0x10, 0x10, 0x1c, 0x70, 0x1c, 0x70, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x52, 0x52, 0x50, 0x50, 0x50,
	0x50, 0x52, 0x52, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x62, 0x52, 0x6a, 0x56, 0x4a, 0x46, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x96, 0x96, 0x96, 0xd0, 0xf0, 0xf0, 0xb0, 0x96, 0x90, 0x96,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x52, 0x52, 0x52, 0x52, 0x52,
	0x52, 0x52, 0x5a, 0x3c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xa4,
	0xa4, 0xa4, 0xa4, 0xb8, 0xa8, 0xb4, 0xaa, 0xe6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfb, 0x55, 0x55, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x06, 0x0a, 0x14, 0x28,
	0x50, 0x60, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44,
	0x22, 0x22, 0x34, 0x58, 0x88, 0x88, 0x84, 0x44, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0xfe, 0x40, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x08, 0x04, 0xfe, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x54, 0x38, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x42, 0xff,
	0x42, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38,
	0x54, 0x10, 0x10, 0x10, 0x10, 0x54, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x42, 0xfe, 0x42, 0x22, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x84, 0xfe,
	0x84, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38,
	0x54, 0x10, 0x10, 0x10, 0x54, 0x38, 0x10, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x22, 0x42, 0xfe, 0x40, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x88,
	0x84, 0xfe, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x02, 0x02, 0x22, 0x42, 0xfe, 0x40, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xf0, 0x30, 0x50, 0x92, 0x82, 0x82, 0x44, 0x38, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0xfe, 0x00,
	0xfe, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x04, 0xfe, 0x00, 0xfe, 0x40, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x7e, 0xc0, 0x7e, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x6c, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x08, 0xfc, 0x06, 0xfc, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x6c, 0x38, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x7e, 0xc3,
	0x7e, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38,
	0x6c, 0x28, 0x28, 0x28, 0x28, 0x6c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x82, 0x82, 0x82, 0x7c, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x7e,
	0x02, 0x02, 0x02, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7e,
	0x0a, 0x0a, 0x12, 0x7e, 0x12, 0x22, 0x22, 0x7e, 0x40, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x04, 0x7c, 0x8a, 0x92, 0x92, 0xa2, 0x7c, 0x40, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x44, 0x44, 0x44,
	0x28, 0x28, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e,
	0x20, 0x40, 0x40, 0x7e, 0x40, 0x40, 0x20, 0x1e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x1e, 0x24, 0x44, 0x48, 0x7e, 0x48, 0x50, 0x30, 0x3e,
	0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x40, 0x7e,
	0x40, 0x20, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78,
	0x04, 0x02, 0x02, 0x7e, 0x02, 0x02, 0x04, 0x78, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x40, 0x78, 0x24, 0x22, 0x12, 0x7e, 0x12, 0x0a, 0x0c, 0x7c,
	0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x02, 0x7e,
	0x02, 0x04, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10,
	0x20, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x04, 0x04, 0x04, 0x04, 0x44, 0x44,
	0x44, 0x24, 0x14, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0x92, 0x92, 0x92, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28,
	0x44, 0x44, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x32, 0x4c, 0x00, 0x32, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x7e, 0x08, 0x10, 0x7e, 0x40, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e,
	0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
	0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x00, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x12, 0x24, 0x48, 0x90,
	0x48, 0x24, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90,
	0x48, 0x24, 0x12, 0x09, 0x12, 0x24, 0x48, 0x90, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x3e, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82, 0x82, 0x82, 0x82, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7e, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x90, 0x90, 0x60, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x08, 0x10, 0x10, 0x20, 0x20, 0x20, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x20, 0x20, 0x20, 0x10, 0x10, 0x08, 0x04,
	0x40, 0x20, 0x10, 0x10, 0x08, 0x08, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x08, 0x08, 0x10, 0x10, 0x20, 0x40,
	0x7c, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7c, 0x7c, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x7c, 0x0e, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0xc0, 0xc0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x10, 0x0e, 0xe0, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x06, 0x06, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x10, 0xe0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x00, 0x88, 0x88, 0xf8, 0x88, 0x88, 0x88, 0x00,
	0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
	0x80, 0x80, 0xf8, 0x00, 0x1f, 0x10, 0x1c, 0x10, 0x10, 0x10, 0x00, 0x00,
	0x00, 0x88, 0x88, 0x50, 0x50, 0x20, 0x20, 0x00, 0x1f, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x00, 0x00, 0x00, 0xf8, 0x80, 0xe0, 0x80, 0x80, 0x80, 0x00,
	0x1f, 0x10, 0x1c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x70, 0x88, 0x80,
	0x80, 0x88, 0x70, 0x00, 0x1e, 0x11, 0x11, 0x1e, 0x12, 0x11, 0x00, 0x00,
	0x00, 0x88, 0xc8, 0xa8, 0x98, 0x88, 0x88, 0x00, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa,
	0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x00,
	0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00,
	0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00,
	0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x1f, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f,
	0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f,
	0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8,
	0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x1f, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f,
	0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xf0, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf8,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf8,
	0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x1f, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0xf0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff,
	0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
	0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xff, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x1f, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff,
	0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0xff, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x1f, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff,
	0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xff, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff,
	0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0xff, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x1f, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
	0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10,
	0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3f, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x20, 0x2f, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x10,
	0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xf8, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0xe8, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x10,
	0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2f, 0x20, 0x3f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0, 0x10,
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xe8, 0x08, 0xf8, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x10,
	0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x2f, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2f, 0x20, 0x2f, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0, 0x10,
	0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0xe8, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xe8, 0x08, 0xe8, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,
	0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xef, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x00,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xef, 0x00, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x10,
	0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0xff, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xef, 0x00, 0xef, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
	0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xc0, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x07,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x02,
	0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x80, 0x80,
	0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04,
	0x02, 0x02, 0x01, 0x01, 0x81, 0x81, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18,
	0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x81, 0x81, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
	0xfc, 0xfc, 0xfc, 0xfc, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
	0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf0, 0xf0, 0xf0, 0xf0,
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
	0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
	0xe0, 0xe0, 0xe0, 0xe0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
	0x0f, 0x0f, 0x0f, 0x0f, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22,
	0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0xaa, 0x55, 0xaa, 0x55,
	0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55,
	0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb,
	0xee, 0xbb, 0xee, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xf0,
	0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xf0,
	0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
	0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0xf0, 0xf0, 0xf0, 0xf0,
	0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
	0x7e, 0x7e, 0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x38, 0x38, 0x7c, 0x7c, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xc0, 0xf0, 0xfc, 0xff, 0xfc, 0xf0, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x7c, 0x7c,
	0x38, 0x38, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x0f, 0x3f, 0xff, 0x3f, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x38, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82,
	0x44, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xdb,
	0xdb, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x7c, 0x82,
	0xaa, 0x82, 0x82, 0xba, 0x92, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xfe, 0xd6, 0xfe, 0xfe, 0xc6, 0xee, 0xfe, 0xfe, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x92, 0x54, 0x38, 0xee,
	0x38, 0x54, 0x92, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44,
	0x44, 0x44, 0x44, 0x38, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1e, 0x06, 0x0a, 0x12, 0x38, 0x44, 0x44, 0x44, 0x44, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0x7c, 0xfe, 0xfe,
	0x7c, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38,
	0x38, 0x10, 0x54, 0xfe, 0xfe, 0x54, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0xfe, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22, 0x3e, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42,
	0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x80, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x02, 0x04, 0x04, 0x88, 0x88, 0x50, 0x50, 0x20, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x06, 0x06, 0xcc, 0xcc,
	0x78, 0x78, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x44,
	0x28, 0x18, 0x18, 0x14, 0x22, 0x20, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0xcc, 0x78, 0x38, 0x38, 0x3c, 0x66, 0x60, 0xc0, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x30, 0x60,
	0x30, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60,
	0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08,
	0x10, 0x10, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12,
	0x24, 0x24, 0x48, 0x48, 0x24, 0x24, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x48, 0x48, 0x24, 0x24, 0x12, 0x12, 0x24, 0x24, 0x48, 0x48,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x00,
	0x00, 0x00, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x88, 0x9c,
	0xaa, 0x88, 0x88, 0x88, 0x10, 0x20, 0x40, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0xf8, 0x00, 0x11, 0x19, 0x15, 0x13,
	0x11, 0x11, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x44, 0xfe, 0xfe,
	0xee, 0xc6, 0xee, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x80, 0xc0, 0xe0, 0xf0,
	0xf8, 0xfc, 0xfe, 0xff, 0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80,
	0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 0x01, 0x02, 0x04, 0x08,
	0x10, 0x20, 0x40, 0x80, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff,
	0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01, 0x01, 0x02, 0x04, 0x08,
	0x10, 0x20, 0x40, 0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01,
	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c,
	0x6c, 0xfe, 0x6c, 0x6c, 0xfe, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x10, 0x7c, 0xd6, 0xd0, 0xd0, 0x7c, 0x16, 0x16, 0xd6, 0x7c,
	0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x66, 0xd6, 0x6c, 0x0c, 0x18, 0x18,
	0x30, 0x36, 0x6b, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c,
	0x6c, 0x38, 0x76, 0xdc, 0xcc, 0xcc, 0xdc, 0x76, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18,
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0xfe, 0x38, 0x6c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e,
	0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18,
	0x30, 0x30, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0xce, 0xde, 0xf6, 0xe6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x38, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x06, 0x0c, 0x18,
	0x30, 0x60, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0x06, 0x3c, 0x06, 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x0e, 0x1e, 0x36, 0x66, 0xc6, 0xfe, 0x06, 0x06, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xfc, 0x06,
	0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x60,
	0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x30,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x0c, 0x78, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x0c, 0x18, 0x18, 0x00, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xce, 0xd6, 0xd6, 0xd6,
	0xd6, 0xce, 0xc0, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0xc0, 0xc0,
	0xc0, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xcc,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xcc, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8, 0xc0,
	0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0xc0, 0xc0, 0xde, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x0c,
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xcc, 0xd8, 0xf0, 0xf0, 0xd8, 0xcc, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6,
	0xee, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6,
	0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xde, 0x7c,
	0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc,
	0xf0, 0xd8, 0xcc, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0x6c, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x6c, 0x38, 0x38,
	0x6c, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3,
	0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0x06, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60,
	0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x66, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00,
	0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x06, 0x7e,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
	0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x7e, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1e, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0xc0, 0xc0,
	0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x0e, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0xc0, 0xc0,
	0xc0, 0xc6, 0xcc, 0xd8, 0xf0, 0xd8, 0xcc, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xd6, 0xd6,
	0xd6, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0xf0, 0xe0, 0xc0, 0xc0, 0xc0, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0,
	0x7c, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30,
	0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	0x6c, 0x6c, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x38, 0x6c, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfe, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x30, 0x30, 0x30, 0x60, 0x30, 0x30, 0x30, 0x30, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x18,
	0x18, 0x18, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x73, 0xdb, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
	0x10, 0x7c, 0xd6, 0xd0, 0xd0, 0xd0, 0xd6, 0x7c, 0x10, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x6c, 0x60, 0x60, 0xf8, 0x60, 0x60, 0x60, 0x66, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x3c, 0x66, 0x66,
	0x66, 0x3c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3,
	0x66, 0x3c, 0x18, 0x7e, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x60, 0x38, 0x6c, 0x66, 0x66,
	0x36, 0x1c, 0x06, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x06, 0x3e, 0x66, 0x3e, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x36, 0x6c,
	0xd8, 0x6c, 0x36, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfe, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x6c,
	0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x0c, 0x18, 0x30, 0x7c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0c, 0x38,
	0x0c, 0x0c, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xce, 0xf6, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x7e, 0xd6,
	0xd6, 0xd6, 0xd6, 0x76, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x30, 0x30, 0x60, 0x00, 0x00, 0x18, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x66,
	0x66, 0x3c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x6c, 0x36, 0x1b, 0x36, 0x6c, 0xd8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xe0, 0x62, 0x66, 0x6c, 0x18, 0x30,
	0x66, 0xce, 0x9a, 0x3e, 0x06, 0x06, 0x00, 0x00, 0x00, 0x60, 0xe0, 0x62,
	0x66, 0x6c, 0x18, 0x30, 0x60, 0xdc, 0xb6, 0x0c, 0x18, 0x3e, 0x00, 0x00,
	0x00, 0xe0, 0x30, 0x62, 0x36, 0xec, 0x18, 0x30, 0x66, 0xce, 0x9a, 0x3e,
	0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x60,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x00, 0x7c,
	0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0x7c,
	0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x38, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xd8,
	0xd8, 0xd8, 0xfe, 0xd8, 0xd8, 0xd8, 0xd8, 0xde, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0xc0, 0xc0, 0xc0, 0xc6, 0xc6, 0x7c,
	0x30, 0x30, 0x60, 0x00, 0x30, 0x18, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8,
	0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0xfe,
	0xc0, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x6c, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8,
	0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x00, 0x3c,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x0c, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x3c,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x78, 0x6c, 0x66, 0x66, 0xf6, 0x66, 0x66, 0x66, 0x6c, 0x78,
	0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0xc6, 0xc6, 0xe6, 0xf6, 0xde,
	0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x00, 0x7c,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0x7c,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x6c, 0x38,
	0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc7,
	0xc6, 0xce, 0xde, 0xf6, 0xe6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x30, 0x18, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
	0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x78, 0xcc, 0xcc, 0xc8, 0xfc, 0xc6, 0xc6, 0xc6, 0xe6, 0xdc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x00, 0x7c, 0x06, 0x7e,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30,
	0x00, 0x7c, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0x7c, 0x06, 0x7e,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c,
	0x00, 0x7c, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x6c, 0x38, 0x7c, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x16, 0x16,
	0x7e, 0xd0, 0xd0, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x30, 0x30, 0x60, 0x00,
	0x00, 0x00, 0x30, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc6,
	0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c,
	0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x00, 0x38, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18,
	0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x6c, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x38, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x30,
	0x58, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x76, 0xdc, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x00, 0x7c, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30,
	0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0x7c, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c,
	0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x67, 0x6e,
	0x7e, 0x76, 0xe6, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x6c, 0x6c,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00,
	0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0x06, 0x7e,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0x7c,
	0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x38, 0x00, 0x7c, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe,
	0xc6, 0xc6, 0xc6, 0xc6, 0x06, 0x0c, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0x07, 0x00,
	0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc0,
	0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c,
	0xc6, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0xc0,
	0xc0, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
	0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc0,
	0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0xf8,
	0xcc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xcc, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x38, 0x06, 0x06, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1f, 0x06, 0x7e, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0xfe, 0xc0,
	0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8,
	0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38,
	0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7c, 0xc6, 0xc6,
	0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0,
	0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x06, 0x0c, 0x07, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c,
	0x18, 0x30, 0x1c, 0x00, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xde,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c,
	0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00,
	0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xde, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0x7e, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00, 0x18, 0x18, 0x00, 0x7c,
	0xc6, 0xc0, 0xc0, 0xde, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0xc0, 0xde,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x30, 0x30, 0x60, 0x00, 0x0c, 0x18, 0x18,
	0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00,
	0x38, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x36, 0xc0, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xff,
	0x66, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0xf8, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
	0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc,
	0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x7e, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x38, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0x3c,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x38, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x18, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x18, 0x18,
	0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x30, 0x1c, 0x00,
	0x18, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xf6, 0xf6, 0xdc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x36, 0x36, 0x1c, 0x00, 0x1c, 0x36, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c,
	0x0c, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b,
	0x00, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xcc, 0xd8, 0xf0, 0xf0, 0xd8, 0xcc, 0xc6, 0xc6,
	0x00, 0x30, 0x30, 0x60, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc6, 0xcc, 0xd8,
	0xf0, 0xd8, 0xcc, 0xc6, 0x00, 0x30, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xcc, 0xd8, 0xf0, 0xd8, 0xcc, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x60, 0xc0, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x30, 0x30, 0x60,
	0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x18, 0x18, 0x30, 0x6c, 0x38, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0x38,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xcc, 0xcc, 0xc0, 0xc0, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x1b, 0x1b,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60,
	0x60, 0x60, 0x70, 0xe0, 0x60, 0x60, 0x60, 0x7f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x1c, 0x38, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0xc6, 0xc6, 0xc6, 0xe6, 0xf6, 0xde,
	0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30,
	0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0xc6, 0xc6,
	0x00, 0x30, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x30, 0x30, 0x60, 0x6c, 0x38, 0xc6, 0xc6,
	0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x38, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0xc0, 0x00, 0xfc, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0x06, 0x06, 0x1c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x06, 0x06, 0x1c, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c,
	0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x36, 0x6c, 0x00, 0x7c,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x36, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xd8, 0xd8, 0xd8, 0xde, 0xd8,
	0xd8, 0xd8, 0xd8, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xd6, 0xd6, 0xde, 0xd0, 0xd0, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x30, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xfc, 0xf0, 0xd8, 0xcc, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0xde, 0xf0, 0xe0,
	0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6,
	0xc6, 0xc6, 0xc6, 0xfc, 0xf0, 0xd8, 0xcc, 0xc6, 0x00, 0x30, 0x30, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0x78, 0x70, 0x60, 0x60, 0x60, 0x60,
	0x00, 0x60, 0x60, 0xc0, 0x6c, 0x38, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xfc,
	0xf0, 0xd8, 0xcc, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38,
	0x00, 0xde, 0xf0, 0xe0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x00, 0x7e, 0xc0, 0xc0,
	0x7c, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c,
	0xc6, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x6c, 0x00, 0x7e, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0x7c, 0x06,
	0x06, 0xc6, 0xc6, 0x7c, 0x30, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7e, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xfc, 0x30, 0x30, 0x60, 0x00,
	0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0x7e, 0xc0, 0xc0,
	0x7c, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x0c, 0x18, 0x00,
	0x00, 0x00, 0x30, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1e,
	0x0c, 0x0c, 0x18, 0x00, 0x6c, 0x38, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0x30,
	0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x30, 0xfc, 0x30, 0x78,
	0x30, 0x30, 0x30, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x76, 0xdc, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x38, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x38, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x6c, 0x38, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x36, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x6c,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x18, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0x07, 0x00, 0x38, 0x6c, 0x00, 0xc6,
	0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x82, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x6c, 0x00, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00,
	0x66, 0x66, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0x30,
	0x60, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30,
	0x00, 0xfe, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0xfe, 0x0c, 0x18,
	0x30, 0x60, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0xfe,
	0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x38, 0x00, 0xfe, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x30, 0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0x06, 0x06, 0x06, 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0x06, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0xfe, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0xc0, 0x78, 0xc0, 0xc0, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0e, 0x1b, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x76, 0x7e, 0x6e,
	0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x06, 0x06, 0x06, 0x00,
	0x00, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0xfe, 0x30, 0x60, 0xc0, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x0c, 0x18,
	0xfc, 0x30, 0x60, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06,
	0x0c, 0x18, 0x3c, 0x06, 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x00, 0x7e, 0xd8, 0xd8, 0xd8, 0xfe, 0xd8, 0xd8, 0xd8, 0xd8, 0xde,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x6c, 0x16, 0x16,
	0x7e, 0xd0, 0xd0, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0xc0, 0xc0, 0xde, 0xc6, 0xdf, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xdf, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x7c, 0x00, 0x6c, 0x38, 0xc6, 0xc6, 0xcc, 0xd8, 0xf0, 0xf0,
	0xd8, 0xcc, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0xc0, 0xc0,
	0xc0, 0xc6, 0xcc, 0xd8, 0xf0, 0xd8, 0xcc, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x18, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x18, 0x30, 0x1c, 0x00, 0x7c, 0x00, 0x7c, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x18, 0x30, 0x1c, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x18, 0x30, 0x1c, 0x00, 0x6c, 0x38, 0x00, 0xfe, 0x0c, 0x18, 0x3c, 0x06,
	0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38,
	0x00, 0xfe, 0x06, 0x0c, 0x18, 0x3c, 0x06, 0x06, 0xc6, 0xc6, 0x7c, 0x00,
	0x00, 0x00, 0x1b, 0x0e, 0x00, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x66, 0x66, 0x3c, 0x00, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xde,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18,
	0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00,
	0x0c, 0x18, 0x00, 0x7e, 0xd8, 0xd8, 0xd8, 0xfe, 0xd8, 0xd8, 0xd8, 0xde,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x00, 0x6c, 0x16, 0x16,
	0x7e, 0xd0, 0xd0, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0x7c,
	0xc7, 0xc6, 0xce, 0xde, 0xf6, 0xe6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x30, 0x00, 0x3d, 0x67, 0x6e, 0x7e, 0x76, 0xe6, 0xbc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0x7c, 0x06,
	0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x30, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7e, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xfc, 0x00, 0x30, 0x30, 0x60,
	0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x30, 0x30, 0x30, 0xfc, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x1e, 0x00, 0x0c, 0x0c, 0x18, 0x7e, 0x00, 0xc3, 0xc3,
	0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0x06, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x06, 0x06,
	0xfe, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0xc0, 0x78, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
	0x60, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x0c,
	0x18, 0x3c, 0x06, 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x18, 0x30, 0x30, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x1c, 0x00,
	0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x36, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x60, 0xc0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x30, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x60, 0xc0, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x60, 0xc0, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x60, 0xc0, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x60, 0xc0, 0x3c, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x60, 0xc0, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x60, 0xc0, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x60, 0xc0, 0x7c, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0xee, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x30, 0xd8, 0xd8, 0x00, 0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x38, 0x38, 0x6c, 0x6c, 0x6c, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0x38, 0x6c, 0x6c,
	0x6c, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00,
	0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0x60, 0x30, 0x18, 0x18,
	0x30, 0x60, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c,
	0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0x6c, 0x6c, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30,
	0x00, 0x7a, 0xce, 0xcc, 0xcc, 0xcc, 0xce, 0x7a, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc0, 0x78, 0xc0, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0xfc, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x18, 0x30,
	0x00, 0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x30, 0x00, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xce, 0xcc,
	0xcc, 0xcc, 0xce, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xcc,
	0xcc, 0xc8, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x3c, 0x18,
	0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x7e, 0x30, 0x18, 0x7c, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x0c,
	0x18, 0x30, 0x60, 0xc0, 0xc0, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0x0c, 0x00,
	0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30,
	0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0xc3, 0xc3, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0xc0, 0xc0, 0xc0, 0x7c, 0xc0, 0xc0, 0xc0, 0xc0, 0x7c,
	0x06, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc0, 0x7c,
	0x06, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x66, 0x66,
	0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xd6, 0xd6,
	0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xc6, 0x6c, 0x6c, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xc6, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c,
	0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xc6, 0xd6,
	0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xd8,
	0x00, 0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30,
	0x00, 0x44, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x3f, 0x06, 0xe6, 0x66, 0x66, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0xd6, 0xd6,
	0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xe3, 0x36, 0x1c, 0x18, 0x38, 0x6c, 0xc7, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc,
	0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3e, 0x60, 0xc0, 0xfc, 0xc0, 0x60, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x0c, 0x06, 0x7e, 0x06, 0x0c, 0xf8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x60, 0x60, 0x7c, 0x66, 0x66,
	0x66, 0x66, 0x66, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0xfe,
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x70, 0xd0, 0xdc, 0xd6, 0xd6,
	0xd6, 0xd6, 0xd6, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xd0,
	0xd0, 0xdc, 0xf6, 0xd6, 0xd6, 0xd6, 0xd6, 0xdc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xf0, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0xc6, 0xc6, 0xcc, 0xd8, 0xf0, 0xf0,
	0xd8, 0xcc, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0xc6, 0xc6,
	0xc6, 0xce, 0xde, 0xf6, 0xe6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x38, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xfe, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc0,
	0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xff,
	0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0x7c, 0x38, 0x7c,
	0xd6, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0xc6, 0xce, 0xde, 0xf6, 0xe6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x38, 0xc6, 0xc6, 0xc6, 0xce, 0xde, 0xf6, 0xe6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x36, 0x66, 0x66, 0x66, 0x66,
	0x66, 0x66, 0x66, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7f, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6,
	0xd6, 0xd6, 0xd6, 0x7f, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x60,
	0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xe6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xe6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x60, 0x7c, 0x66, 0x66,
	0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xcc, 0xd6, 0xd6, 0xd6, 0xd6, 0xf6, 0xd6, 0xd6, 0xd6, 0xcc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x1e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc0,
	0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x78, 0xcc, 0xcc, 0xc8, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xd6, 0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x3c, 0x06, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x66, 0x66,
	0x66, 0x66, 0x66, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xee, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7f, 0x03, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6,
	0xd6, 0xd6, 0xd6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7f, 0x03, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xe6,
	0xd6, 0xd6, 0xd6, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x3e, 0x06, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xd6, 0xd6,
	0xf6, 0xd6, 0xd6, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7e, 0xc6, 0xc6, 0x7e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0xf8, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
	0x06, 0x06, 0x1c, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0xfe, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0xc0, 0xf8, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xd0, 0xdc, 0xd6, 0xd6, 0xd6, 0x9c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xd0, 0xdc,
	0xf6, 0xd6, 0xd6, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30,
	0x00, 0xc6, 0xcc, 0xd8, 0xf0, 0xd8, 0xcc, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x38, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xfe, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x60, 0xf8,
	0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x60, 0xf8, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6, 0x6c, 0x6c, 0x38, 0x7c,
	0xd6, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfe, 0x6c, 0x28, 0x38, 0x7c, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00,
	0x06, 0x06, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0xfe, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x60,
	0x60, 0x60, 0xfc, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x60, 0x60, 0xfc, 0x60, 0x60, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xfc,
	0xc6, 0xc6, 0xc6, 0xc6, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfe, 0xc0, 0xc0, 0xf8, 0xcc, 0xcc, 0xcc, 0x0c, 0x18, 0x00, 0x00,
	0x00, 0x00, 0xd6, 0xd6, 0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd6, 0xd6, 0xd7,
	0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0x7c,
	0x38, 0x7c, 0xd6, 0xd7, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0x06, 0x3c, 0x06, 0x06, 0xc6, 0xc6, 0x7c, 0x30, 0x30, 0x30, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x3c, 0x06, 0xc6, 0x7c,
	0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xcc, 0xd8, 0xf0, 0xf0,
	0xd8, 0xcc, 0xc6, 0xc7, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xcc, 0xd8, 0xf0, 0xd8, 0xcc, 0xc7, 0x03, 0x03, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xd6, 0xdc, 0xf8, 0xf8, 0xdc, 0xd6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xd6, 0xdc,
	0xf8, 0xdc, 0xd6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe3, 0xe3,
	0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe3, 0x66, 0x6c, 0x78, 0x6c, 0x66, 0x63,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc7, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc7, 0x03, 0x03, 0x00, 0x00,
	0x00, 0x00, 0xcf, 0xcc, 0xcc, 0xcc, 0xfc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xcc, 0xcc,
	0xfc, 0xcc, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0xc0, 0xc0, 0xc0, 0xc0, 0xc6, 0xc6, 0x7c, 0x30, 0x30, 0x30, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c,
	0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18,
	0x7e, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x7e, 0x18, 0x18, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x6c, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xc7,
	0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x6c,
	0x38, 0x6c, 0xc6, 0xc7, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x07, 0x03, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x07,
	0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0x7e,
	0x16, 0x16, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xd6, 0xd6, 0x7e, 0x16, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xfc,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0xd6,
	0xd6, 0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x38, 0x00, 0xd6, 0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd6,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0xfe,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c,
	0x00, 0x7c, 0x06, 0x06, 0xfe, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x00, 0xd6, 0xd6, 0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd6, 0xd6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xd6, 0xd6, 0x7c,
	0x38, 0x7c, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c,
	0xc6, 0xc6, 0x06, 0x3c, 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0x06, 0x3c, 0x06, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xce, 0xde, 0xf6,
	0xe6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6,
	0xc6, 0xc6, 0xce, 0xde, 0xf6, 0xe6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c,
	0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0x3e, 0x06, 0x06, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0x06,
	0x3e, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x36, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x6c,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00,
	0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6,
	0x7e, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6,
	0xc6, 0xc6, 0xe6, 0xd6, 0xd6, 0xd6, 0xd6, 0xe6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xe6, 0xd6, 0xd6, 0xd6, 0xe6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x66, 0x66, 0x3c, 0x78,
	0xcc, 0xcc, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x78, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x36, 0x63, 0xc3,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06,
	0x06, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x0c, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xcc, 0xce, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00,
	0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xfe, 0x06, 0x06, 0x06, 0x06, 0x0c,
	0x18, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xdc, 0x76, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0c,
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x66, 0x66, 0x36,
	0x36, 0x1c, 0x38, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0xc6, 0x66, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x66, 0x06, 0x06, 0x06, 0x06, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x33, 0x36, 0x1c, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0x66, 0x6c, 0x38, 0x30, 0x18, 0x18, 0x0c, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0x06, 0x06, 0xc6, 0xc6, 0xcc, 0xd8, 0xd8, 0xd8, 0xd8,
	0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6,
	0xd6, 0xd6, 0xd6, 0xe6, 0xc6, 0xc6, 0xcc, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xcc, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xcc, 0xf8, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x06, 0x06,
	0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xcc, 0xd8, 0xf0, 0xf0, 0xd8, 0xcc, 0xc6, 0xc6,
	0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc6, 0xcc, 0xd8,
	0xf0, 0xd8, 0xcc, 0xc6, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x82, 0xc6, 0xee, 0xfe, 0xd6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30,
	0x00, 0xfc, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x82, 0xc6, 0xee, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xd6, 0xd6,
	0xd6, 0xd6, 0xd6, 0xd6, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0xc6, 0xc6,
	0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x30, 0x30, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xe6, 0xf6, 0xde,
	0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x30, 0x30, 0x30, 0xfc, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x1e, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0xfe, 0xc0,
	0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c,
	0x00, 0x18, 0x18, 0x00, 0x76, 0xdc, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8,
	0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc,
	0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x18, 0x18, 0x00,
	0x76, 0xdc, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfe, 0x00, 0xfe, 0x00, 0x18, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x66,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66,
	0xcc, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0x66, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
	0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xdb, 0xdb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0xac,
	0xf8, 0x18, 0x30, 0x30, 0x60, 0x7f, 0xd5, 0xdf, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x18, 0x30, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
	0x66, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x6c,
	0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1c, 0x34, 0x7e, 0x0c, 0x0c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x60, 0x78,
	0x0c, 0x0c, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x60, 0x78, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x38,
	0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x6c, 0x6c, 0x3c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x30,
	0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x30, 0x18, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x6c, 0x6c, 0x6c, 0x6c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x38, 0x6c, 0x6c, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x38, 0x18, 0x18, 0x18,
	0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38,
	0x6c, 0x0c, 0x18, 0x30, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x78, 0x0c, 0x38, 0x0c, 0x0c, 0x78, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1c, 0x34, 0x7e, 0x0c,
	0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78,
	0x60, 0x78, 0x0c, 0x0c, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x38, 0x60, 0x78, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x0c, 0x18, 0x18, 0x30,
	0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38,
	0x6c, 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x38, 0x6c, 0x6c, 0x3c, 0x0c, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
	0x30, 0x30, 0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x30, 0x18, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x0c, 0x3c, 0x6c,
	0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x6c, 0x7c, 0x60, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x3c, 0x18, 0x3c,
	0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x78, 0x0c, 0x7c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x60, 0x78, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x66, 0x6c, 0x78, 0x6c,
	0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xfc, 0xd6, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x6c, 0x6c, 0x6c,
	0x78, 0x60, 0x60, 0x00, 0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xcc, 0xfa, 0xc6,
	0xcf, 0xc6, 0xc6, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e,
	0x33, 0x60, 0xfc, 0x60, 0xfc, 0x60, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x18, 0x18, 0x1e, 0x78, 0x1e, 0x78, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x33, 0x33, 0x3e, 0x7c,
	0xcc, 0xcc, 0xc6, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x20, 0x60, 0xfe, 0xfe, 0x60, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0xfe,
	0xfe, 0x0c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x66, 0xff, 0xff, 0x66, 0x24, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18,
	0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x22, 0x62, 0xfe, 0xfe, 0x62, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x8c, 0xfe, 0xfe, 0x8c, 0x88, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18,
	0x7e, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06,
	0x06, 0x06, 0x26, 0x66, 0xfe, 0xfe, 0x60, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc8, 0xcc, 0xfe, 0xfe, 0x0c, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x26, 0x66,
	0xfe, 0xfe, 0x60, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,
	0x38, 0x68, 0xcb, 0xc3, 0xc3, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x20, 0x60, 0xfe, 0xfe, 0x00, 0xfe, 0xfe, 0x0c, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0xfe, 0xfe, 0x00,
	0xfe, 0xfe, 0x60, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x3e, 0x7e, 0xe0, 0x7e, 0x3e, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x38, 0x7c, 0xee, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xf8, 0xfc, 0x0e,
	0xfc, 0xf8, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0xee, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x7e, 0xff, 0xc3, 0xff, 0x7e, 0x24, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xee, 0x6c, 0x6c,
	0xee, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0xc6, 0xfe, 0x6c, 0x6c, 0x6c, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0xfe, 0x06, 0x06, 0x06, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xfe, 0x1e, 0x16, 0x36, 0xfe,
	0x36, 0x66, 0x66, 0xfe, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0c,
	0x7c, 0xce, 0xde, 0xf6, 0xe6, 0x7c, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0xc6, 0xc6, 0x6c, 0x6c, 0x6c, 0x38, 0x38, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x60, 0xc0, 0xc0, 0xfe,
	0xc0, 0xc0, 0x60, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x3e,
	0x6c, 0xcc, 0xd8, 0xfe, 0xd8, 0xf0, 0x70, 0x7e, 0x60, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3e, 0x60, 0xc0, 0xfe, 0xc0, 0x60, 0x3e, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x0c, 0x06, 0x06, 0xfe,
	0x06, 0x06, 0x0c, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xf8,
	0x6c, 0x66, 0x36, 0xfe, 0x36, 0x1e, 0x1c, 0xfc, 0x0c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xf8, 0x0c, 0x06, 0xfe, 0x06, 0x0c, 0xf8, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x18,
	0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0x60, 0x30,
	0x18, 0x0c, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0xcc, 0x6c, 0x3c, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xd6, 0xd6,
	0xd6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0xc3, 0xc3,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0x66, 0x66,
	0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00,
	0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x06, 0xfe, 0x18, 0x30, 0xfe, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x60, 0x30,
	0x18, 0x0c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
	0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x09, 0x1b, 0x36, 0x6c, 0xd8, 0x6c, 0x36, 0x1b, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xd8, 0x6c, 0x36, 0x1b,
	0x36, 0x6c, 0xd8, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7e, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0xc0, 0xc0,
	0xc0, 0x7e, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc,
	0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
	0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0,
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x18,
	0x30, 0x30, 0x30, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	0x60, 0x30, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x06, 0x60, 0x30, 0x18, 0x18,
	0x0c, 0x0c, 0x0c, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x0c, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x60, 0x7e, 0x60, 0x60, 0x60,
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	0x60, 0x60, 0x60, 0x7e, 0x7e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x7e,
	0x0f, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xe0,
	0xe0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x0f,
	0xf0, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x07,
	0x07, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0xf0,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xcc, 0xcc, 0xfc, 0xcc, 0xcc, 0xcc, 0x00, 0x3f, 0x0c, 0x0c, 0x0c,
	0x0c, 0x0c, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xf8, 0x00,
	0x3f, 0x30, 0x3c, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc,
	0xcc, 0x78, 0x30, 0x00, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
	0x00, 0xfc, 0xc0, 0xf0, 0xc0, 0xc0, 0xc0, 0x00, 0x3f, 0x30, 0x3c, 0x30,
	0x30, 0x30, 0x00, 0x00, 0x00, 0x78, 0xcc, 0xc0, 0xc0, 0xcc, 0x78, 0x00,
	0x3e, 0x33, 0x33, 0x3e, 0x36, 0x33, 0x00, 0x00, 0x00, 0xcc, 0xec, 0xfc,
	0xdc, 0xcc, 0xcc, 0x00, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x38, 0x38, 0x00, 0x38, 0x38, 0x38, 0x00, 0x38, 0x38, 0x38, 0x00,
	0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f,
	0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3f, 0x3f, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8,
	0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xf8, 0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8, 0xf8, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f,
	0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8,
	0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xf8, 0xf8, 0xf8, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f,
	0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x3f, 0x3f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3f, 0x3f, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3f,
	0x3f, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x3f, 0x3f, 0x3f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3f, 0x3f, 0x3f, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3f, 0x3f,
	0x3f, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0xf8, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xf8, 0xf8, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8,
	0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0xf8, 0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xf8, 0xf8, 0xf8, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8,
	0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0xf8, 0xf8, 0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,
	0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff,
	0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3f, 0xff, 0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xff,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x1f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xff,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3f, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xff, 0xff,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0xf8, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0xff, 0xff, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff,
	0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xff,
	0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0xf8, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3f, 0xff, 0xff, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xff,
	0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x1f, 0xff, 0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xff, 0xff, 0xff, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff,
	0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0xf8, 0xff, 0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3f, 0xff, 0xff, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xff, 0xff,
	0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18,
	0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7f, 0x7f, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x60, 0x6f, 0x6f, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18,
	0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xfc, 0xfc, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xfc, 0x0c, 0xec, 0xec, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18,
	0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6f, 0x6f, 0x60, 0x7f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18,
	0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0xfc, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xec, 0xec, 0x0c, 0xfc, 0xfc, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18,
	0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6f, 0x6f, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6f, 0x6f, 0x60, 0x6f, 0x6f, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18,
	0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0xec, 0xec, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xec, 0xec, 0x0c, 0xec, 0xec, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
	0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xef, 0xef, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x00,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xef, 0xef, 0x00, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x18,
	0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0xff, 0xff, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xef, 0xef, 0x00, 0xef, 0xef, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
	0x0f, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xe0, 0xf0, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0xf0, 0xe0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x0f,
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x02,
	0x06, 0x04, 0x0c, 0x08, 0x18, 0x10, 0x30, 0x20, 0x60, 0x40, 0xc0, 0x80,
	0x80, 0xc0, 0x40, 0x60, 0x20, 0x30, 0x10, 0x18, 0x08, 0x0c, 0x04, 0x06,
	0x02, 0x03, 0x01, 0x01, 0x81, 0xc1, 0x43, 0x62, 0x26, 0x34, 0x1c, 0x18,
	0x18, 0x1c, 0x34, 0x26, 0x62, 0x43, 0xc1, 0x81, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8,
	0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x3c, 0x3c, 0x7e, 0x7e, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xf0, 0xfc, 0xff,
	0xff, 0xfc, 0xf0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x7e, 0x7e, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x3f, 0xff, 0xff, 0x3f, 0x0f, 0x03,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff,
	0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x3c, 0x66, 0xc3, 0x66, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x7e,
	0x7e, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xc3, 0x99, 0xbd, 0xbd, 0x99, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x18, 0xdb, 0x7e, 0x3c, 0xe7, 0x3c, 0x7e, 0xdb, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c,
	0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x0e,
	0x1a, 0x32, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0x7e, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x5a, 0xff,
	0xff, 0x5a, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x66,
	0x7e, 0x60, 0x60, 0x60, 0x60, 0x60, 0xe0, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6e, 0xec,
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x0e, 0x0e, 0xdc, 0xfc,
	0x78, 0x78, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xee,
	0x7c, 0x3c, 0x3c, 0x3e, 0x77, 0x73, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0e, 0x1c, 0x38, 0x70, 0xe0, 0x70, 0x38, 0x1c, 0x0e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x70, 0x38, 0x1c, 0x0e,
	0x1c, 0x38, 0x70, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c,
	0x18, 0x18, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x6c, 0x6c, 0xd8, 0xd8,
	0x6c, 0x6c, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xd8,
	0x6c, 0x6c, 0x36, 0x36, 0x6c, 0x6c, 0xd8, 0xd8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xcc, 0xde, 0xff, 0xcc, 0xcc, 0xcc,
	0x98, 0x30, 0x60, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0xc0, 0xc0, 0xc0,
	0xc0, 0xc0, 0xfc, 0x00, 0x33, 0x3b, 0x3f, 0x37, 0x33, 0x33, 0x00, 0x00,
	0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0xff, 0xff, 0xe7, 0xc3, 0xe7, 0xff,
	0xff, 0xff, 0x00, 0x00, 0x80, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03,
	0x03, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80, 0x01, 0x03, 0x06, 0x0c,
	0x18, 0x30, 0x60, 0xc0, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x01,
};

static vfnt_map_t font_mapping_normal[322] = {
	{ 0x0020, 0x0001, 0x5e }, { 0x00a0, 0x0001, 0x00 },
	{ 0x00a1, 0x0060, 0x6e }, { 0x0110, 0x008f, 0x00 },
	{ 0x0111, 0x00cf, 0x08 }, { 0x011a, 0x00d2, 0x01 },
	{ 0x011c, 0x00d8, 0x63 }, { 0x0186, 0x013c, 0x00 },
	{ 0x018e, 0x013d, 0x02 }, { 0x0192, 0x0140, 0x00 },
	{ 0x019d, 0x0141, 0x01 }, { 0x01b5, 0x0143, 0x02 },
	{ 0x01cd, 0x00c1, 0x01 }, { 0x01cf, 0x00e8, 0x01 },
	{ 0x01d1, 0x010a, 0x01 }, { 0x01d3, 0x0128, 0x01 },
	{ 0x01e2, 0x0146, 0x03 }, { 0x01e6, 0x00da, 0x01 },
	{ 0x01e8, 0x014a, 0x08 }, { 0x01f4, 0x0153, 0x01 },
	{ 0x01fc, 0x0155, 0x03 }, { 0x0218, 0x0159, 0x03 },
	{ 0x0232, 0x015d, 0x01 }, { 0x0237, 0x015f, 0x00 },
	{ 0x0254, 0x0160, 0x00 }, { 0x0258, 0x0161, 0x01 },
	{ 0x025b, 0x0163, 0x00 }, { 0x0272, 0x0164, 0x00 },
	{ 0x0292, 0x0165, 0x00 }, { 0x02bb, 0x0166, 0x02 },
	{ 0x02c6, 0x0169, 0x01 }, { 0x02d8, 0x016a, 0x01 },
	{ 0x02db, 0x016c, 0x02 }, { 0x0300, 0x0041, 0x00 },
	{ 0x0301, 0x0073, 0x00 }, { 0x0302, 0x0169, 0x00 },
	{ 0x0303, 0x016d, 0x00 }, { 0x0304, 0x006e, 0x00 },
	{ 0x0305, 0x016f, 0x00 }, { 0x0306, 0x016a, 0x01 },
	{ 0x0308, 0x0067, 0x00 }, { 0x030a, 0x0170, 0x00 },
	{ 0x030b, 0x016e, 0x00 }, { 0x030c, 0x016a, 0x00 },
	{ 0x0329, 0x0171, 0x00 }, { 0x0384, 0x0172, 0x06 },
	{ 0x038c, 0x0179, 0x00 }, { 0x038e, 0x017a, 0x02 },
	{ 0x0391, 0x0022, 0x01 }, { 0x0393, 0x017d, 0x01 },
	{ 0x0395, 0x0026, 0x00 }, { 0x0396, 0x003b, 0x00 },
	{ 0x0397, 0x0029, 0x00 }, { 0x0398, 0x017f, 0x00 },
	{ 0x0399, 0x002a, 0x00 }, { 0x039a, 0x002c, 0x00 },
	{ 0x039b, 0x0180, 0x00 }, { 0x039c, 0x002e, 0x01 },
	{ 0x039e, 0x0181, 0x00 }, { 0x039f, 0x0030, 0x00 },
	{ 0x03a0, 0x0182, 0x00 }, { 0x03a1, 0x0031, 0x00 },
	{ 0x03a3, 0x0183, 0x00 }, { 0x03a4, 0x0035, 0x00 },
	{ 0x03a5, 0x003a, 0x00 }, { 0x03a6, 0x0184, 0x00 },
	{ 0x03a7, 0x0039, 0x00 }, { 0x03a8, 0x0185, 0x01 },
	{ 0x03aa, 0x008e, 0x00 }, { 0x03ab, 0x0134, 0x00 },
	{ 0x03ac, 0x0187, 0x08 }, { 0x03b5, 0x0163, 0x00 },
	{ 0x03b6, 0x0190, 0x00 }, { 0x03b7, 0x0142, 0x00 },
	{ 0x03b8, 0x0191, 0x01 }, { 0x03ba, 0x00f4, 0x00 },
	{ 0x03bb, 0x0193, 0x00 }, { 0x03bc, 0x0074, 0x00 },
	{ 0x03bd, 0x0057, 0x00 }, { 0x03be, 0x0194, 0x00 },
	{ 0x03bf, 0x0050, 0x00 }, { 0x03c0, 0x0195, 0x0b },
	{ 0x03cc, 0x00b2, 0x00 }, { 0x03cd, 0x01a1, 0x01 },
	{ 0x03d1, 0x01a3, 0x00 }, { 0x03d5, 0x01a4, 0x00 },
	{ 0x03f0, 0x01a5, 0x01 }, { 0x03f2, 0x0044, 0x00 },
	{ 0x03f3, 0x004b, 0x00 }, { 0x03f4, 0x01a7, 0x02 },
	{ 0x0400, 0x0087, 0x00 }, { 0x0401, 0x008a, 0x00 },
	{ 0x0402, 0x01aa, 0x02 }, { 0x0405, 0x0034, 0x00 },
	{ 0x0406, 0x002a, 0x00 }, { 0x0407, 0x008e, 0x00 },
	{ 0x0408, 0x002b, 0x00 }, { 0x0409, 0x01ad, 0x06 },
	{ 0x0410, 0x0022, 0x00 }, { 0x0411, 0x01b4, 0x00 },
	{ 0x0412, 0x0023, 0x00 }, { 0x0413, 0x017d, 0x00 },
	{ 0x0414, 0x01b5, 0x00 }, { 0x0415, 0x0026, 0x00 },
	{ 0x0416, 0x01b6, 0x00 }, { 0x0417, 0x0014, 0x00 },
	{ 0x0418, 0x01b7, 0x01 }, { 0x041a, 0x002c, 0x00 },
	{ 0x041b, 0x01b9, 0x00 }, { 0x041c, 0x002e, 0x00 },
	{ 0x041d, 0x0029, 0x00 }, { 0x041e, 0x0030, 0x00 },
	{ 0x041f, 0x0182, 0x00 }, { 0x0420, 0x0031, 0x00 },
	{ 0x0421, 0x0024, 0x00 }, { 0x0422, 0x0035, 0x00 },
	{ 0x0423, 0x01ba, 0x01 }, { 0x0425, 0x0039, 0x00 },
	{ 0x0426, 0x01bc, 0x05 }, { 0x042c, 0x0043, 0x00 },
	{ 0x042d, 0x01c2, 0x02 }, { 0x0430, 0x0042, 0x00 },
	{ 0x0431, 0x01c5, 0x02 }, { 0x0434, 0x0048, 0x00 },
	{ 0x0435, 0x0046, 0x00 }, { 0x0436, 0x01c8, 0x01 },
	{ 0x0438, 0x0056, 0x00 }, { 0x0439, 0x0129, 0x00 },
	{ 0x043a, 0x00f4, 0x00 }, { 0x043b, 0x01ca, 0x02 },
	{ 0x043e, 0x0050, 0x00 }, { 0x043f, 0x0195, 0x00 },
	{ 0x0440, 0x0051, 0x00 }, { 0x0441, 0x0044, 0x00 },
	{ 0x0442, 0x01cd, 0x00 }, { 0x0443, 0x005a, 0x00 },
	{ 0x0444, 0x01a4, 0x00 }, { 0x0445, 0x0059, 0x00 },
	{ 0x0446, 0x01ce, 0x09 }, { 0x0450, 0x00a7, 0x00 },
	{ 0x0451, 0x00aa, 0x00 }, { 0x0452, 0x01d8, 0x02 },
	{ 0x0455, 0x0054, 0x00 }, { 0x0456, 0x004a, 0x00 },
	{ 0x0457, 0x00ae, 0x00 }, { 0x0458, 0x004b, 0x00 },
	{ 0x0459, 0x01db, 0x01 }, { 0x045b, 0x00e3, 0x00 },
	{ 0x045c, 0x01dd, 0x00 }, { 0x045d, 0x00b8, 0x00 },
	{ 0x045e, 0x01de, 0x01 }, { 0x0462, 0x01e0, 0x01 },
	{ 0x046a, 0x01e2, 0x01 }, { 0x0490, 0x01e4, 0x0d },
	{ 0x04a0, 0x01f2, 0x05 }, { 0x04aa, 0x01f8, 0x01 },
	{ 0x04ae, 0x003a, 0x00 }, { 0x04af, 0x018e, 0x00 },
	{ 0x04b0, 0x01fa, 0x03 }, { 0x04b6, 0x01fe, 0x05 },
	{ 0x04c0, 0x002a, 0x00 }, { 0x04c1, 0x0204, 0x01 },
	{ 0x04cf, 0x004d, 0x00 }, { 0x04d0, 0x00c1, 0x01 },
	{ 0x04d2, 0x0083, 0x00 }, { 0x04d3, 0x00a3, 0x00 },
	{ 0x04d4, 0x0085, 0x00 }, { 0x04d5, 0x00a5, 0x00 },
	{ 0x04d6, 0x00d2, 0x01 }, { 0x04d8, 0x013e, 0x00 },
	{ 0x04d9, 0x0162, 0x00 }, { 0x04da, 0x0206, 0x05 },
	{ 0x04e2, 0x020c, 0x00 }, { 0x04e3, 0x0127, 0x00 },
	{ 0x04e4, 0x020d, 0x00 }, { 0x04e5, 0x00bb, 0x00 },
	{ 0x04e6, 0x0095, 0x00 }, { 0x04e7, 0x00b5, 0x00 },
	{ 0x04e8, 0x01a7, 0x00 }, { 0x04e9, 0x020e, 0x05 },
	{ 0x04ef, 0x015e, 0x00 }, { 0x04f0, 0x0214, 0x00 },
	{ 0x04f1, 0x00be, 0x00 }, { 0x04f2, 0x0215, 0x03 },
	{ 0x04f8, 0x0219, 0x01 }, { 0x05d0, 0x021b, 0x1a },
	{ 0x1e0c, 0x0236, 0x01 }, { 0x1e34, 0x0238, 0x03 },
	{ 0x1e40, 0x023c, 0x07 }, { 0x1e6c, 0x0244, 0x01 },
	{ 0x1eb8, 0x0246, 0x01 }, { 0x1ebc, 0x0248, 0x01 },
	{ 0x1eca, 0x024a, 0x03 }, { 0x1ee4, 0x024e, 0x01 },
	{ 0x1ef8, 0x0250, 0x01 }, { 0x2000, 0x0001, 0x00 },
	{ 0x2001, 0x0001, 0x00 }, { 0x2002, 0x0001, 0x00 },
	{ 0x2003, 0x0001, 0x00 }, { 0x2004, 0x0001, 0x00 },
	{ 0x2005, 0x0001, 0x00 }, { 0x2006, 0x0001, 0x00 },
	{ 0x2007, 0x0001, 0x00 }, { 0x2008, 0x0001, 0x00 },
	{ 0x2009, 0x0001, 0x00 }, { 0x200a, 0x0001, 0x00 },
	{ 0x200b, 0x0001, 0x00 }, { 0x200c, 0x0001, 0x00 },
	{ 0x200d, 0x0001, 0x00 }, { 0x200e, 0x0001, 0x00 },
	{ 0x200f, 0x0001, 0x00 }, { 0x2010, 0x006c, 0x00 },
	{ 0x2011, 0x006c, 0x00 }, { 0x2012, 0x000e, 0x00 },
	{ 0x2013, 0x000e, 0x00 }, { 0x2014, 0x0252, 0x00 },
	{ 0x2015, 0x0252, 0x0d }, { 0x2026, 0x0260, 0x00 },
	{ 0x2030, 0x0261, 0x00 }, { 0x2032, 0x0262, 0x01 },
	{ 0x2039, 0x0264, 0x01 }, { 0x203c, 0x0266, 0x00 },
	{ 0x203e, 0x016f, 0x00 }, { 0x2070, 0x0267, 0x01 },
	{ 0x2074, 0x0269, 0x1a }, { 0x2090, 0x0284, 0x08 },
	{ 0x209a, 0x028d, 0x00 }, { 0x20a7, 0x028e, 0x00 },
	{ 0x20aa, 0x028f, 0x00 }, { 0x20ac, 0x0290, 0x00 },
	{ 0x20ae, 0x0291, 0x00 }, { 0x2102, 0x0292, 0x00 },
	{ 0x210e, 0x0049, 0x00 }, { 0x210f, 0x00e3, 0x00 },
	{ 0x2115, 0x0293, 0x01 }, { 0x211a, 0x0295, 0x00 },
	{ 0x211d, 0x0296, 0x00 }, { 0x2122, 0x0297, 0x00 },
	{ 0x2124, 0x0298, 0x00 }, { 0x2126, 0x0186, 0x00 },
	{ 0x2135, 0x0299, 0x00 }, { 0x2190, 0x029a, 0x05 },
	{ 0x21a4, 0x02a0, 0x00 }, { 0x21a6, 0x02a1, 0x00 },
	{ 0x21a8, 0x02a2, 0x00 }, { 0x21b2, 0x02a3, 0x01 },
	{ 0x21b5, 0x02a5, 0x00 }, { 0x21bb, 0x02a6, 0x00 },
	{ 0x21cb, 0x02a7, 0x01 }, { 0x21d0, 0x02a9, 0x05 },
	{ 0x2200, 0x02af, 0x00 }, { 0x2203, 0x02b0, 0x02 },
	{ 0x2206, 0x017e, 0x00 }, { 0x2207, 0x02b3, 0x06 },
	{ 0x2212, 0x000e, 0x00 }, { 0x2213, 0x02ba, 0x03 },
	{ 0x2219, 0x02be, 0x01 }, { 0x221e, 0x02c0, 0x01 },
	{ 0x2225, 0x0253, 0x00 }, { 0x2227, 0x02c2, 0x03 },
	{ 0x2248, 0x02c6, 0x00 }, { 0x2260, 0x02c7, 0x01 },
	{ 0x2264, 0x02c9, 0x01 }, { 0x226a, 0x02cb, 0x01 },
	{ 0x2282, 0x02cd, 0x01 }, { 0x2286, 0x02cf, 0x01 },
	{ 0x22a5, 0x02d1, 0x00 }, { 0x22c2, 0x02d2, 0x00 },
	{ 0x22c3, 0x0036, 0x00 }, { 0x2300, 0x02b2, 0x00 },
	{ 0x2302, 0x02d3, 0x00 }, { 0x2308, 0x02d4, 0x03 },
	{ 0x2310, 0x02d8, 0x00 }, { 0x2319, 0x02d9, 0x00 },
	{ 0x2320, 0x02da, 0x01 }, { 0x239b, 0x02dc, 0x06 },
	{ 0x23a2, 0x02dd, 0x00 }, { 0x23a3, 0x02e3, 0x01 },
	{ 0x23a5, 0x02e0, 0x00 }, { 0x23a6, 0x02e5, 0x03 },
	{ 0x23ab, 0x02e9, 0x04 }, { 0x23ba, 0x02ee, 0x03 },
	{ 0x23d0, 0x02ec, 0x00 }, { 0x2409, 0x02f2, 0x04 },
	{ 0x2424, 0x02f7, 0x00 }, { 0x2500, 0x02ed, 0x00 },
	{ 0x2501, 0x02f8, 0x00 }, { 0x2502, 0x02ec, 0x00 },
	{ 0x2503, 0x02f9, 0x00 }, { 0x2508, 0x02fa, 0x43 },
	{ 0x2550, 0x033e, 0x43 }, { 0x2596, 0x0382, 0x0a },
	{ 0x25ac, 0x038d, 0x00 }, { 0x25ae, 0x038e, 0x00 },
	{ 0x25b2, 0x038f, 0x00 }, { 0x25b6, 0x0390, 0x00 },
	{ 0x25ba, 0x0390, 0x00 }, { 0x25bc, 0x0391, 0x00 },
	{ 0x25c0, 0x0392, 0x00 }, { 0x25c4, 0x0392, 0x00 },
	{ 0x25c6, 0x0393, 0x00 }, { 0x25ca, 0x0394, 0x01 },
	{ 0x25cf, 0x025f, 0x00 }, { 0x25d8, 0x0396, 0x01 },
	{ 0x263a, 0x0398, 0x02 }, { 0x2640, 0x039b, 0x00 },
	{ 0x2642, 0x039c, 0x00 }, { 0x2660, 0x039d, 0x00 },
	{ 0x2663, 0x039e, 0x00 }, { 0x2665, 0x039f, 0x00 },
	{ 0x2666, 0x0393, 0x00 }, { 0x266a, 0x03a0, 0x01 },
	{ 0x2713, 0x03a2, 0x01 }, { 0x2717, 0x03a4, 0x01 },
	{ 0x276e, 0x03a6, 0x01 }, { 0x27e8, 0x03a8, 0x03 },
	{ 0x2800, 0x0001, 0x00 }, { 0x2801, 0x03ac, 0xfe },
	{ 0x2e2c, 0x04ab, 0x00 }, { 0xe0a0, 0x04ac, 0x02 },
	{ 0xe0b0, 0x04af, 0x03 }, { 0xf6be, 0x015f, 0x00 },
};

static vfnt_map_t font_mapping_bold[336] = {
	{ 0x0021, 0x04b3, 0x0b }, { 0x002d, 0x0252, 0x00 },
	{ 0x002e, 0x04bf, 0x0d }, { 0x003c, 0x03a6, 0x00 },
	{ 0x003d, 0x04cd, 0x00 }, { 0x003e, 0x03a7, 0x00 },
	{ 0x003f, 0x04ce, 0x3f }, { 0x00a1, 0x050e, 0x07 },
	{ 0x00aa, 0x0516, 0x03 }, { 0x00af, 0x051a, 0x07 },
	{ 0x00b7, 0x02be, 0x00 }, { 0x00b8, 0x0522, 0x57 },
	{ 0x0110, 0x053a, 0x00 }, { 0x0111, 0x057a, 0x08 },
	{ 0x011a, 0x057d, 0x01 }, { 0x011c, 0x0583, 0x63 },
	{ 0x0186, 0x05e7, 0x00 }, { 0x018e, 0x05e8, 0x02 },
	{ 0x0192, 0x05eb, 0x00 }, { 0x019d, 0x05ec, 0x01 },
	{ 0x01b5, 0x05ee, 0x02 }, { 0x01cd, 0x056c, 0x01 },
	{ 0x01cf, 0x0593, 0x01 }, { 0x01d1, 0x05b5, 0x01 },
	{ 0x01d3, 0x05d3, 0x01 }, { 0x01e2, 0x05f1, 0x03 },
	{ 0x01e6, 0x0585, 0x01 }, { 0x01e8, 0x05f5, 0x08 },
	{ 0x01f4, 0x05fe, 0x01 }, { 0x01fc, 0x0600, 0x03 },
	{ 0x0218, 0x0604, 0x03 }, { 0x0232, 0x0608, 0x01 },
	{ 0x0237, 0x060a, 0x00 }, { 0x0254, 0x060b, 0x00 },
	{ 0x0258, 0x060c, 0x01 }, { 0x025b, 0x060e, 0x00 },
	{ 0x0272, 0x060f, 0x00 }, { 0x0292, 0x0610, 0x00 },
	{ 0x02bb, 0x0611, 0x02 }, { 0x02c6, 0x0614, 0x01 },
	{ 0x02d8, 0x0615, 0x01 }, { 0x02db, 0x0617, 0x02 },
	{ 0x0300, 0x04ef, 0x00 }, { 0x0301, 0x051f, 0x00 },
	{ 0x0302, 0x0614, 0x00 }, { 0x0303, 0x0618, 0x00 },
	{ 0x0304, 0x051a, 0x00 }, { 0x0305, 0x061a, 0x00 },
	{ 0x0306, 0x0615, 0x01 }, { 0x0308, 0x0515, 0x00 },
	{ 0x030a, 0x061b, 0x00 }, { 0x030b, 0x0619, 0x00 },
	{ 0x030c, 0x0615, 0x00 }, { 0x0329, 0x061c, 0x00 },
	{ 0x0384, 0x061d, 0x06 }, { 0x038c, 0x0624, 0x00 },
	{ 0x038e, 0x0625, 0x02 }, { 0x0391, 0x04d0, 0x01 },
	{ 0x0393, 0x0628, 0x01 }, { 0x0395, 0x04d4, 0x00 },
	{ 0x0396, 0x04e9, 0x00 }, { 0x0397, 0x04d7, 0x00 },
	{ 0x0398, 0x062a, 0x00 }, { 0x0399, 0x04d8, 0x00 },
	{ 0x039a, 0x04da, 0x00 }, { 0x039b, 0x062b, 0x00 },
	{ 0x039c, 0x04dc, 0x01 }, { 0x039e, 0x062c, 0x00 },
	{ 0x039f, 0x04de, 0x00 }, { 0x03a0, 0x062d, 0x00 },
	{ 0x03a1, 0x04df, 0x00 }, { 0x03a3, 0x062e, 0x00 },
	{ 0x03a4, 0x04e3, 0x00 }, { 0x03a5, 0x04e8, 0x00 },
	{ 0x03a6, 0x062f, 0x00 }, { 0x03a7, 0x04e7, 0x00 },
	{ 0x03a8, 0x0630, 0x01 }, { 0x03aa, 0x0539, 0x00 },
	{ 0x03ab, 0x05df, 0x00 }, { 0x03ac, 0x0632, 0x08 },
	{ 0x03b5, 0x060e, 0x00 }, { 0x03b6, 0x063b, 0x00 },
	{ 0x03b7, 0x05ed, 0x00 }, { 0x03b8, 0x063c, 0x01 },
	{ 0x03ba, 0x059f, 0x00 }, { 0x03bb, 0x063e, 0x00 },
	{ 0x03bc, 0x0520, 0x00 }, { 0x03bd, 0x0505, 0x00 },
	{ 0x03be, 0x063f, 0x00 }, { 0x03bf, 0x04fe, 0x00 },
	{ 0x03c0, 0x0640, 0x0b }, { 0x03cc, 0x055d, 0x00 },
	{ 0x03cd, 0x064c, 0x01 }, { 0x03d1, 0x064e, 0x00 },
	{ 0x03d5, 0x064f, 0x00 }, { 0x03f0, 0x0650, 0x01 },
	{ 0x03f2, 0x04f2, 0x00 }, { 0x03f3, 0x04f9, 0x00 },
	{ 0x03f4, 0x0652, 0x02 }, { 0x0400, 0x0532, 0x00 },
	{ 0x0401, 0x0535, 0x00 }, { 0x0402, 0x0655, 0x02 },
	{ 0x0405, 0x04e2, 0x00 }, { 0x0406, 0x04d8, 0x00 },
	{ 0x0407, 0x0539, 0x00 }, { 0x0408, 0x04d9, 0x00 },
	{ 0x0409, 0x0658, 0x06 }, { 0x0410, 0x04d0, 0x00 },
	{ 0x0411, 0x065f, 0x00 }, { 0x0412, 0x04d1, 0x00 },
	{ 0x0413, 0x0628, 0x00 }, { 0x0414, 0x0660, 0x00 },
	{ 0x0415, 0x04d4, 0x00 }, { 0x0416, 0x0661, 0x00 },
	{ 0x0417, 0x04c4, 0x00 }, { 0x0418, 0x0662, 0x01 },
	{ 0x041a, 0x04da, 0x00 }, { 0x041b, 0x0664, 0x00 },
	{ 0x041c, 0x04dc, 0x00 }, { 0x041d, 0x04d7, 0x00 },
	{ 0x041e, 0x04de, 0x00 }, { 0x041f, 0x062d, 0x00 },
	{ 0x0420, 0x04df, 0x00 }, { 0x0421, 0x04d2, 0x00 },
	{ 0x0422, 0x04e3, 0x00 }, { 0x0423, 0x0665, 0x01 },
	{ 0x0425, 0x04e7, 0x00 }, { 0x0426, 0x0667, 0x09 },
	{ 0x0430, 0x04f0, 0x00 }, { 0x0431, 0x0671, 0x02 },
	{ 0x0434, 0x04f6, 0x00 }, { 0x0435, 0x04f4, 0x00 },
	{ 0x0436, 0x0674, 0x01 }, { 0x0438, 0x0504, 0x00 },
	{ 0x0439, 0x05d4, 0x00 }, { 0x043a, 0x059f, 0x00 },
	{ 0x043b, 0x0676, 0x02 }, { 0x043e, 0x04fe, 0x00 },
	{ 0x043f, 0x0640, 0x00 }, { 0x0440, 0x04ff, 0x00 },
	{ 0x0441, 0x04f2, 0x00 }, { 0x0442, 0x0679, 0x00 },
	{ 0x0443, 0x0508, 0x00 }, { 0x0444, 0x064f, 0x00 },
	{ 0x0445, 0x0507, 0x00 }, { 0x0446, 0x067a, 0x09 },
	{ 0x0450, 0x0552, 0x00 }, { 0x0451, 0x0555, 0x00 },
	{ 0x0452, 0x0684, 0x02 }, { 0x0455, 0x0502, 0x00 },
	{ 0x0456, 0x04f8, 0x00 }, { 0x0457, 0x0559, 0x00 },
	{ 0x0458, 0x04f9, 0x00 }, { 0x0459, 0x0687, 0x01 },
	{ 0x045b, 0x058e, 0x00 }, { 0x045c, 0x0689, 0x00 },
	{ 0x045d, 0x0563, 0x00 }, { 0x045e, 0x068a, 0x01 },
	{ 0x0462, 0x068c, 0x01 }, { 0x046a, 0x068e, 0x01 },
	{ 0x0490, 0x0690, 0x0d }, { 0x04a0, 0x069e, 0x05 },
	{ 0x04aa, 0x06a4, 0x01 }, { 0x04ae, 0x04e8, 0x00 },
	{ 0x04af, 0x0639, 0x00 }, { 0x04b0, 0x06a6, 0x03 },
	{ 0x04b6, 0x06aa, 0x05 }, { 0x04c0, 0x04d8, 0x00 },
	{ 0x04c1, 0x06b0, 0x01 }, { 0x04cf, 0x04fb, 0x00 },
	{ 0x04d0, 0x056c, 0x01 }, { 0x04d2, 0x052e, 0x00 },
	{ 0x04d3, 0x054e, 0x00 }, { 0x04d4, 0x0530, 0x00 },
	{ 0x04d5, 0x0550, 0x00 }, { 0x04d6, 0x057d, 0x01 },
	{ 0x04d8, 0x05e9, 0x00 }, { 0x04d9, 0x060d, 0x00 },
	{ 0x04da, 0x06b2, 0x05 }, { 0x04e2, 0x06b8, 0x00 },
	{ 0x04e3, 0x05d2, 0x00 }, { 0x04e4, 0x06b9, 0x00 },
	{ 0x04e5, 0x0566, 0x00 }, { 0x04e6, 0x0540, 0x00 },
	{ 0x04e7, 0x0560, 0x00 }, { 0x04e8, 0x0652, 0x00 },
	{ 0x04e9, 0x06ba, 0x05 }, { 0x04ef, 0x0609, 0x00 },
	{ 0x04f0, 0x06c0, 0x00 }, { 0x04f1, 0x0569, 0x00 },
	{ 0x04f2, 0x06c1, 0x03 }, { 0x04f8, 0x06c5, 0x01 },
	{ 0x05d0, 0x06c7, 0x1a }, { 0x1e0c, 0x06e2, 0x01 },
	{ 0x1e34, 0x06e4, 0x03 }, { 0x1e40, 0x06e8, 0x07 },
	{ 0x1e6c, 0x06f0, 0x01 }, { 0x1eb8, 0x06f2, 0x01 },
	{ 0x1ebc, 0x06f4, 0x01 }, { 0x1eca, 0x06f6, 0x03 },
	{ 0x1ee4, 0x06fa, 0x01 }, { 0x1ef8, 0x06fc, 0x01 },
	{ 0x2010, 0x0519, 0x00 }, { 0x2011, 0x0519, 0x00 },
	{ 0x2012, 0x0252, 0x00 }, { 0x2013, 0x0252, 0x00 },
	{ 0x2016, 0x06fe, 0x03 }, { 0x201a, 0x04be, 0x00 },
	{ 0x201b, 0x0702, 0x06 }, { 0x2026, 0x0709, 0x00 },
	{ 0x2030, 0x070a, 0x00 }, { 0x2032, 0x070b, 0x01 },
	{ 0x2039, 0x070d, 0x01 }, { 0x203c, 0x070f, 0x00 },
	{ 0x203e, 0x061a, 0x00 }, { 0x2070, 0x0710, 0x01 },
	{ 0x2074, 0x0712, 0x06 }, { 0x207d, 0x0719, 0x0d },
	{ 0x208d, 0x0727, 0x01 }, { 0x2090, 0x0729, 0x08 },
	{ 0x209a, 0x0732, 0x00 }, { 0x20a7, 0x0733, 0x00 },
	{ 0x20ac, 0x0734, 0x00 }, { 0x20ae, 0x0735, 0x00 },
	{ 0x210e, 0x04f7, 0x00 }, { 0x210f, 0x058e, 0x00 },
	{ 0x2126, 0x0631, 0x00 }, { 0x2135, 0x0736, 0x00 },
	{ 0x2190, 0x0737, 0x05 }, { 0x21a4, 0x073d, 0x00 },
	{ 0x21a6, 0x073e, 0x00 }, { 0x21a8, 0x073f, 0x00 },
	{ 0x21b2, 0x0740, 0x01 }, { 0x21b5, 0x0742, 0x00 },
	{ 0x21bb, 0x0743, 0x00 }, { 0x21cb, 0x0744, 0x01 },
	{ 0x21d0, 0x0746, 0x05 }, { 0x2200, 0x074c, 0x00 },
	{ 0x2203, 0x074d, 0x02 }, { 0x2206, 0x0629, 0x00 },
	{ 0x2207, 0x0750, 0x06 }, { 0x2212, 0x0252, 0x00 },
	{ 0x2213, 0x0757, 0x03 }, { 0x2219, 0x075b, 0x01 },
	{ 0x221e, 0x075d, 0x01 }, { 0x2225, 0x06fe, 0x00 },
	{ 0x2227, 0x075f, 0x03 }, { 0x2248, 0x0763, 0x00 },
	{ 0x2260, 0x0764, 0x01 }, { 0x2264, 0x0766, 0x01 },
	{ 0x226a, 0x0768, 0x01 }, { 0x2282, 0x076a, 0x01 },
	{ 0x2286, 0x076c, 0x01 }, { 0x22a5, 0x076e, 0x00 },
	{ 0x22c2, 0x076f, 0x00 }, { 0x22c3, 0x04e4, 0x00 },
	{ 0x2300, 0x074f, 0x00 }, { 0x2302, 0x0770, 0x00 },
	{ 0x2308, 0x0771, 0x03 }, { 0x2310, 0x0775, 0x00 },
	{ 0x2319, 0x0776, 0x00 }, { 0x2320, 0x0777, 0x01 },
	{ 0x239b, 0x0779, 0x06 }, { 0x23a2, 0x077a, 0x00 },
	{ 0x23a3, 0x0780, 0x01 }, { 0x23a5, 0x077d, 0x00 },
	{ 0x23a6, 0x0782, 0x03 }, { 0x23ab, 0x0786, 0x02 },
	{ 0x23ae, 0x02f9, 0x00 }, { 0x23af, 0x02f8, 0x00 },
	{ 0x23ba, 0x0789, 0x02 }, { 0x23bd, 0x036f, 0x00 },
	{ 0x23d0, 0x02f9, 0x00 }, { 0x2409, 0x078c, 0x04 },
	{ 0x2424, 0x0791, 0x00 }, { 0x2500, 0x02f8, 0x00 },
	{ 0x2501, 0x0792, 0x00 }, { 0x2502, 0x02f9, 0x00 },
	{ 0x2503, 0x0793, 0x00 }, { 0x2508, 0x02fb, 0x00 },
	{ 0x2509, 0x0794, 0x00 }, { 0x250a, 0x02fd, 0x00 },
	{ 0x250b, 0x0795, 0x00 }, { 0x250c, 0x0301, 0x00 },
	{ 0x250d, 0x0796, 0x02 }, { 0x2510, 0x0305, 0x00 },
	{ 0x2511, 0x0799, 0x02 }, { 0x2514, 0x0309, 0x00 },
	{ 0x2515, 0x079c, 0x02 }, { 0x2518, 0x030d, 0x00 },
	{ 0x2519, 0x079f, 0x02 }, { 0x251c, 0x0315, 0x00 },
	{ 0x251d, 0x07a2, 0x06 }, { 0x2524, 0x031d, 0x00 },
	{ 0x2525, 0x07a9, 0x06 }, { 0x252c, 0x0325, 0x00 },
	{ 0x252d, 0x07b0, 0x06 }, { 0x2534, 0x032d, 0x00 },
	{ 0x2535, 0x07b7, 0x06 }, { 0x253c, 0x033d, 0x00 },
	{ 0x253d, 0x07be, 0x0e }, { 0x2550, 0x07cd, 0x25 },
	{ 0x2576, 0x0368, 0x01 }, { 0x2578, 0x07f3, 0x07 },
	{ 0x25a0, 0x07fb, 0x00 }, { 0x25ac, 0x07fc, 0x00 },
	{ 0x25ae, 0x07fd, 0x00 }, { 0x25b2, 0x07fe, 0x00 },
	{ 0x25b6, 0x07ff, 0x00 }, { 0x25ba, 0x07ff, 0x00 },
	{ 0x25bc, 0x0800, 0x00 }, { 0x25c0, 0x0801, 0x00 },
	{ 0x25c4, 0x0801, 0x00 }, { 0x25c6, 0x0802, 0x00 },
	{ 0x25ca, 0x0803, 0x01 }, { 0x25cf, 0x0805, 0x00 },
	{ 0x25d9, 0x0806, 0x00 }, { 0x263c, 0x0807, 0x00 },
	{ 0x2640, 0x0808, 0x00 }, { 0x2642, 0x0809, 0x00 },
	{ 0x2660, 0x080a, 0x00 }, { 0x2663, 0x080b, 0x00 },
	{ 0x2666, 0x0802, 0x00 }, { 0x266a, 0x080c, 0x01 },
	{ 0x2713, 0x03a3, 0x00 }, { 0x2714, 0x080e, 0x00 },
	{ 0x2717, 0x03a5, 0x00 }, { 0x2718, 0x080f, 0x00 },
	{ 0x276e, 0x0810, 0x01 }, { 0x27e8, 0x0812, 0x03 },
	{ 0x2801, 0x0816, 0xfe }, { 0x2e2c, 0x0915, 0x00 },
	{ 0xe0a0, 0x0916, 0x02 }, { 0xe0b1, 0x0919, 0x00 },
	{ 0xe0b3, 0x091a, 0x00 }, { 0xf6be, 0x060a, 0x00 },
};

struct vt_font vt_font_default = {
	.vf_width		= 8,
	.vf_height		= 16,
	.vf_bytes		= font_bytes,
	.vf_map			= {
				    font_mapping_normal,
				    NULL,
				    font_mapping_bold,
				    NULL,
				  },
	.vf_map_count		= { 322, 0, 336, 0 },
	.vf_refcount		= 1,
};
