<SERVER PURPOSE="JSConstructor" CLASS="netscape.peas.DBPool">
</SERVER>
function displayErrMsgs(db) {
    write("Error: Unable to connect to database.  Check that your username and password are correct")
    write("and that you have specified the correct name for the database server, database name, and type.")
    write("<P>Major Error Message: " + db.majorErrorMessage() )
    write("<P>Minor Error Message: " + db.minorErrorMessage() )
    write("<P>Major Error Code: " + db.majorErrorCode() )
    write("<P>Minor Error Code: " + db.minorErrorCode() )
}

function netscape_peas_DBPool(params) {
   if  (params.dbName == null)
      params.dbName = ""
   if  (params.password == null)
      params.password = ""
   if (params.dbType.indexOf("ODBC") != -1)
      params.dbType = "ODBC"

   //use ODBC to connect to POLite
   if (params.dbType == "Personal Oracle Lite") {
      params.dbType = "ODBC";
      params.maxConnections = 1; // works better
   }
   project.dbType = params.dbType
   project.dbServer = params.dbServer
   project.userName = params.userName
   project.password = params.password
   project.dbName = params.dbName

   this.timeout = params.timeout
   this.id = params.id

   if (server.httpdlwVersion.indexOf("1.0") != -1) { // ---- Server 2.0

      dbObj = new Object()
      with (params) {
         database.connect(dbType, dbServer, userName, password, dbName)
      }
      if  ( !database.connected() )
         displayErrMsgs(database)
      else
          return dbObj

   } else { // ----- Server 3.x+
      if (project[params.id] == null) {  //Create db pool if it doesn't already exist
         pool = new DbPool(params.dbType, params.dbServer, params.userName, params.password, params.dbName, params.maxConnections, params.transactionMode)
         project[params.id] = pool
      } else {
	   pool = project[params.id]
	  }
      if  ( !pool.connected() )
         displayErrMsgs(pool)
      else
         return pool

   }
} // netscape_peas_DBPool
