<JSB>
/*
 * HelloWorld.jsb   1.0 97/11/09
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */

    <JSB_DESCRIPTOR NAME="netscape.samples.helloworld.HelloWorld"
     HELP_URL="netscape/samples/helloworld/HelloWorld.html">

    /**
     * The message displayed by this JSB
     */
    <JSB_PROPERTY NAME="theMessage" TYPE="string" DEFAULT_VALUE="Hello World!">

    <JSB_METHOD NAME="displayMessage" TYPE="void"> </JSB_METHOD>

    <JSB_CONSTRUCTOR>

    /**
     * Displays the currently set message and
     * writes it to the Java Console.
     * This is called once in the constructor,
     * and can then be called again by other components.
     * <p>
     * Note that the full name of the function contains
     * not only the underscored version of the package space,
     * but the component name as well.  This further insures
     * against namespace collisions, and is useful in situations
     * where a package namespace is used for more than one component.
     * <p>
     * <i>For example,</i> if another component called
     * netscape.samples.helloworld.EasyBanner had a displayMessage method,
     * it would be useful to be able to distinguish between the
     * methods:
     * <ul>
     * <li>netscape_samples_helloworld_HelloWorld_displayMessage()
     * </ul>
     * and
     * <ul>
     * <li>netscape_samples_helloworld_EasyBanner_displayMessage()
     * </ul>
     *
     * @see theMessage
     */
    function netscape_samples_helloworld_HelloWorld_displayMessage() {
        alert(this.theMessage);
        this.sysout(this.theMessage);
    }

    /**
     * This is the constructor
     */
    function netscape_samples_helloworld_HelloWorld(params) {
        // Assign the params.theMessage value
        // to a "message" property for the "this" object
        // which it is the constructor's responsibility
        // to populate with all properties and methods
        // declared in the JSB_PROPERTY and JSB_METHOD
        // tags above.
        this.theMessage = params.theMessage;

        // Notice that the namespace is eliminated
        // when assigning the method -- this
        // makes it easier to reference methods through
        // the instance of this JSB object, while
        // preserving namespace collision protection
        this.displayMessage = netscape_samples_helloworld_HelloWorld_displayMessage;

        // It is a good idea, though not mandatory, to assign
        // private functions as well; it is only mandatory if they
        // must be instance as opposed to static functions.
        // This also allows us to call
        //      this.sysout
        // instead of
        //      _netscape_samples_helloworld_HeloWorld_sysout
        //
        this.sysout = _netscape_samples_helloworld_HelloWorld_sysout;

        // Now, to pop up a message on construction
        // one writes:
        this.displayMessage(this.message);
    }

    /**
     * This is a private function to output
     * text to the Java console.
     * Used primarily by displayMessage.
     * @see displayMessage
     */
    function _netscape_samples_helloworld_HelloWorld_sysout(tempString) {
        // Comment out the following line to avoid calling Java,
        // not calling Java can speed up your JSB.
        // This is used primarily for debugging purposes, and is left
        // uncommented for illustration purposed.
        java.lang.System.out.println(tempString);
    }

    </JSB_CONSTRUCTOR>
</JSB>

