/*
 * ShowTextCustomizer.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
package netscape.samples.simple;

import java.beans.*;
import java.awt.*;
import java.awt.event.*;

/**
 * Note: Images may be missing from the JavaDocs generated.<p>
 * <b>Do not be alarmed</b>: this is intentional and should
 * not impact the usability of the JavaDocs as a reference.
 */
public class ShowTextCustomizer extends Panel implements Customizer, KeyListener {

    private ShowText target;
    private TextField textField;
    public Font textFont = new Font("TimesRoman",Font.ITALIC | Font.BOLD,26);
    public Color textColor = new Color(80,80,180);
    public Color backgroundColor = new Color(200,200,255);

    /**
     * The constructor initializes basic properties of this customizer class.
     */
    public ShowTextCustomizer() {
        setBackground(backgroundColor);
    	setLayout(null);
    }

    /**
     * This is called by the tool inspecting ShowText at design time
     * just before instantiating the customizer and displaying it
     * to the user.
     * <p>
     * The textfield used is initialized to the value of the property
     * it controls.
     */
    public void setObject(Object obj) {
    	target = (ShowText) obj;

    	Label textLabel = new Label("Caption:", Label.RIGHT);
    	add(textLabel);
    	textLabel.setBounds(10, 45, 60, 30);

        Label previewLabel = new Label("Preview:", Label.LEFT);
    	add(previewLabel);
    	previewLabel.setBounds(10, 85, 60, 30);

    	textField = new TextField(target.getMessage(), 20);
    	add(textField);
    	textField.setBounds(80, 45, 100, 30);

	    textField.addKeyListener(this);
    }

    /**
     * Paints a preview of what will appear in the 
     * main ShowText class using the message specified,
     * using an algorithm similar to the one used in ShowText
     */
    public void paint(Graphics g) {
        g.setFont(textFont);
        g.setColor(textColor);
        g.drawString("ShowText Customizer",20,30);

        g.setColor(Color.gray);
    	g.drawString(textField.getText(),23, 145);
        g.setColor(Color.black);
    	g.drawString(textField.getText(),20, 140);
    }

    /**
     * Returns the preferred size for our customizer
     */
    public Dimension getPreferredSize() {
    	return new Dimension(300, 175);
    }

    /**
     * Forces a repaint on keystrokes
     */
    public void keyTyped(KeyEvent e) {
        repaint();
    }

    /**
     * Forces a repaint on keypresses
     */
    public void keyPressed(KeyEvent e) {
        repaint();
    }

    /**
     * On a key release event, set the property
     * of the bean to match the value
     * the user specified in the textfield
     */
    public void keyReleased(KeyEvent e) {
    	String txt = textField.getText();
    	target.setMessage(txt);
    	support.firePropertyChange("", null, null);
    }

    /**
     * Old method used only for older layout managers
     */
    public Dimension preferredSize() {
	    return getPreferredSize();
    }


    //////////////////////////////////////////////////////
    //
    // Additional Methods for supporting Adding and
    // Removing listeners
    //
    public void addPropertyChangeListener(PropertyChangeListener listener) {
	    support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    	support.removePropertyChangeListener(listener);
    }

    private PropertyChangeSupport support = new PropertyChangeSupport(this);

}
