<JSB>
/*
 * SourceLoader.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
   <JSB_DESCRIPTOR NAME="SourceLoader" ENV="client"
                   DISPLAYNAME="SourceLoader"
                   SHORTDESCRIPTION="Source Loader">

   <JSB_METHOD NAME="getContent" TYPE="string"
               ENV="client"
               DISPLAYNAME="getContent"
               SHORTDESCRIPTION="Provides the content of an url">

      <JSB_PARAMETER NAME="url" TYPE="string"
                     DISPLAYNAME="url"
                     SHORTDESCRIPTION="The url of the document you want to get">
   </JSB_METHOD>  

   <JSB_EVENT NAME="gotContent"
   			  DISPLAYNAME="gotContent"
			  LISTENERMETHODS="onChange"
			  EVENTMODEL="JS">


   </JSB_EVENT>

  <JSB_CONSTRUCTOR>
function SourceLoader_getContent(url) {

    /**
     * SourceLoader makes use of JavaScript
     * to Java calls, and essentially acts to
     * encapsulate Java functionality for
     * retrieving an URL from a server.
     */
    function newbyte(size) {
        return java.lang.reflect.Array.newInstance(java.lang.Byte.TYPE, size);
    }

    var stream=java.net.URL(url).getContent();
    var curSize=4096;

    var buf = newbyte(curSize);
    var aux = newbyte(curSize);
    var tmp;

    var read=0;
    var length=stream.read(aux);
    while (length!=-1) {
        if (read+length>curSize) {
          curSize*=2;
          tmp = newbyte(curSize);
          java.lang.System.arraycopy(buf,0,tmp,0,read);
          buf=tmp;
        }
        java.lang.System.arraycopy(aux,0,buf,read,length);
        read+=length;
        length=stream.read(aux);
    }
    this.data=String(java.lang.String(buf,0,0,read));
	if (this.gotContent) {
	  this.gotContent("data",'',this. data);
	}
}

function SourceLoader(params) {
  this.getContent=SourceLoader_getContent;
  this.data='';
}
  </JSB_CONSTRUCTOR>
</JSB>

