/*
 * ShowText.java    1.0 97/11/09
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */

package netscape.samples.showtext;

import java.awt.*;

/**
 * Note: Images may be missing from the JavaDocs generated.<p>
 * <b>Do not be alarmed</b>: this is intentional and should
 * not impact the usability of the JavaDocs as a reference.
 */
public class ShowText extends java.applet.Applet {
    /**
     * The string which stores the message
     * to be displayed by the Applet/Bean
     */ 
    public String  message = null;


    /**
     * Initializes the Applet / Bean with properties
     * from PARAM tags to support HTML Serialization
     * model -- thus getting the initial values from
     * HTML instead of from a <b><i>.ser</i></b>
     * file.
     */
    public void init() {
        // gets message from "message" param in HTML
        // for HTML-serialization support
    	String textVal = getParameter("message");

        // set the message
    	setMessage(textVal);

        // set the font
    	setFont(new Font("TimesRoman",Font.ITALIC | Font.BOLD,36));
    }


    /**
     * Paints the message string with a dark-gray drop shadow
     * @see setMessage
     */
    public void paint(Graphics g) {
        g.setColor(Color.gray);
    	g.drawString(message,20, 45);
        g.setColor(Color.black);
    	g.drawString(message,17, 37);
    }


    /**
     * getMessage is the "getter" method
     * for the message property
     */
    public String getMessage() {
        return message;
    }

    /**
     * setMessage is the setter method
     * for the message property -- defaults
     * to "Netscape" if null is passed.
     * <p>
     * Sets message and forces a repaint.
     */
    public void setMessage(String newVal) {
        message = newVal;
    	if (message == null) {
    	    message = "Netscape";
    	}
    	repaint();
    }


}

