/*
 * LDAPIsMemberBeanInfo.java    1.1
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
package netscape.ldap.beans;

import java.beans.SimpleBeanInfo;
import java.beans.BeanDescriptor;
import java.beans.EventSetDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.BeanInfo;

/**
 * BeanInfo for IsMember
 *
 * History:
 *  v1.0: Rob Weltman
 *  v1.1: cdk_team
 */
public class LDAPIsMemberBeanInfo extends SimpleBeanInfo {

    public LDAPIsMemberBeanInfo() throws Exception {

    beanClass = Class.forName( "netscape.ldap.beans.LDAPIsMember" );
        // Publish properties -------------------------------------------------

        try {
            PropertyDescriptor host =
				new PropertyDescriptor("host", beanClass);
			PropertyDescriptor port =
				new PropertyDescriptor("port", beanClass);
			PropertyDescriptor authDN =
				new PropertyDescriptor("authDN", beanClass);
            PropertyDescriptor authPassword =
				new PropertyDescriptor("authPassword", beanClass);
            PropertyDescriptor group =
				new PropertyDescriptor("group", beanClass);
            PropertyDescriptor member =
				new PropertyDescriptor("member", beanClass);

            PropertyDescriptor rv[] =
			    {host, port, authDN, authPassword, group, member};
            _propertyDescriptor = new PropertyDescriptor[rv.length];
			for( int i = 0; i < rv.length; i++ )
			    _propertyDescriptor[i] = rv[i];
        } catch (Exception e) {
            throw new Error(e.toString());
        }

        // Publish descriptor ---------------------------------------------
        try {
            _beanDescriptor = new BeanDescriptor(beanClass);
			_beanDescriptor.setDisplayName( "LDAP IsMember" );
			_beanDescriptor.setShortDescription(
				"LDAP IsMember -"
				+ " provided a host, port, group name and member name,"
				+ " and optionally an authentication name and password,"
				+ " return true if the member belongs to the group." );
        } catch (Exception e) {
        }
    }

    /**
     * @return the public properties
     */
    public PropertyDescriptor[] getPropertyDescriptors() {
        return _propertyDescriptor;
    }

    public EventSetDescriptor[] getEventSetDescriptors() {
        return _eventSetDescriptor;
    }

    public BeanInfo[] getAdditionalBeanInfo() {
        return null;
    }

    public int getDefaultEventIndex() {
        return -1;
    }

    public int getDefaultPropertyIndex() {
        return -1;
    }

    public BeanDescriptor getBeanDescriptor() {
		return _beanDescriptor;
	}

    private static Class beanClass;
	private BeanDescriptor _beanDescriptor;
    private EventSetDescriptor[] _eventSetDescriptor;
    private PropertyDescriptor[] _propertyDescriptor;
}


