<JSB>
/*
 * jsbdoc.jsb    1.0 97/11/06
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * -garys
 */

    /**
     * This is the descriptor tag
     * for the jsbdoc JSB
     * <p>
     * Note that it provides a short description, and
     * notes "ISJAVA" and "ISHIDDEN"
     */
    <JSB_DESCRIPTOR
        NAME="netscape.samples.jsbdoc.jsbdoc"
        DISPLAYNAME="JSBDoc"
        SHORTDESCRIPTION="JSBDoc"
        ISJAVA ISHIDDEN>

    /**
     * the fileName property must be set to a valid filename...
     * <p>
     * Defaults to "jsbdoc.jsb"
     * @see setFileName
     */
    <JSB_PROPERTY NAME="fileName" DISPLAYNAME="fileName"
        PROPTYPE="AWT11" TYPE="string"
        READMETHOD="getFileName" WRITEMETHOD="setFileName"
        ISRUNTIME DEFAULT_VALUE="jsbdoc.jsb"
        SHORTDESCRIPTION="fileName">

    /**
     * This returns the currently-set filename
     */
    <JSB_METHOD NAME="generateJSBDoc" TYPE="void"> </JSB_METHOD>

    <JSB_CONSTRUCTOR>
    /**
     * Reads the file... Ported from the JavaBean into
     * this JavaScript bean so that security-sensitive
     * items can be consolidated into one script for easier
     * signing.
     * @see writeFile
     */
    function netscape_samples_jsbdoc_readFile(fileName) {
        if(fileName.indexOf('.jsb') == -1) {
            alert(' You need to enter the location of an existing JavaScript \n file in .jsb .js or .html format. Try using the "Browse" button.');
            return;
        }
        netscape.security.PrivilegeManager.enablePrivilege("UniversalFileAccess");
        var fis = new java.io.FileInputStream(fileName);
        var dis = new java.io.DataInputStream(fis);
        var line;
        var fileLines = new java.util.Vector();
        while (( line = dis.readLine()) != null) { 
            fileLines.addElement(line);
        }
        fis.close();
        this.fileLines = fileLines;
        java.lang.System.out.println("done reading...");
    }

    /**
     * Writes out the newly created JSBDocumentation.
     * @see readFile
     */
    function netscape_samples_jsbdoc_writeFile(fileName, str) {
        var dos = new java.io.DataOutputStream(new java.io.BufferedOutputStream(new java.io.FileOutputStream(fileName),512));
        dos.writeBytes(str);
        dos.flush();
        dos.close();
        java.lang.System.out.println("Generating " + fileName);
    }

    /**
     * This is the method that calls into the JSBDoc JavaBean
     * to parse the JSB file and create documentation (writing
     * it to the disk).
     * <p>
     * The parsing is done in the JavaBean.  The request for
     * permission to read/write files appears below, and these
     * functions exist in this JavaScript Bean encapsulation of
     * the JavaBean.
     */
    function netscape_samples_jsbdoc_generateJSBDoc() {
        netscape.security.PrivilegeManager.enablePrivilege("UniversalFileAccess");
        this.readFile(this.fileName);
        this.JSBname = this.fileName.substring(0, this.fileName.lastIndexOf("."));
        this.docFileName = this.JSBname +"_jsb.html";
        java.lang.System.out.println("Generating documentation for JSB "+this.JSBname);
        this.JSBDocPackage.runParser(this.JSBname, this.fileLines);
        this.writeFile(this.docFileName, this.JSBDocPackage.getFinalDoc());
    }

    /**
     * Constructs a new JSBDoc instance
     * and initializes the JavaScript calls into Java
     * or JavaScript methods.<p>
     * Instantiates the JSBDoc Java Package (containing
     * the JSBDoc JavaBean) and mates
     * it to this instance of the JSBDoc JavaScript Bean.
     */
    function netscape_samples_jsbdoc_jsbdoc(params) {
        this.fileName  = params.fileName;
        this.readFile  = netscape_samples_jsbdoc_readFile;
        this.writeFile = netscape_samples_jsbdoc_writeFile;
        this.generateJSBDoc = netscape_samples_jsbdoc_generateJSBDoc;

        this.JSBDocPackage = new Packages.netscape.samples.jsbdoc.jsbdoc();
        this.JSBDocPackage.setFileName(params.fileName);
    }
    </JSB_CONSTRUCTOR>

</JSB>
