import netscape.WAI.Naming;
import idl.*;

/**
 * This class provides the runnable daemon which manages
 * the HelloCorba object and services requests made to
 * this object.  It extends a class which has been automatically
 * generated by idl2java from the HelloCorba.idl file.
 */
public class HelloCorbaDaemon extends idl._sk_HelloCorba {

    /** Construct a persistently named object. */
    public HelloCorbaDaemon(java.lang.String name) {
        super(name);
    }
    /** Construct a transient object. */
    public HelloCorbaDaemon() {
        super();
    }

    //////////////// strings
    public void setOneString(String value1) {
        System.out.println("setOneString: " + value1);
        _sString1 = value1;
    }
    public void setTwoStrings(String value1,String value2) {
        System.out.println("setTwoStrings: " + value1 + '|' + value2 );
        _sString1 = value1;
        _sString2 = value2;
    }
    public void setThreeStrings(String value1,String value2,String value3) {
        System.out.println("setThreeStrings: " + value1 + '|' + value2 + '|' + value3);
        _sString1 = value1;
        _sString2 = value2;
        _sString3 = value3;
    }
    public String getOneString() {
        System.out.println("getOneString");
        return _sString1;
    }
    public String getTwoStrings(org.omg.CORBA.StringHolder value2) {
        System.out.println("getTwoStrings");
	value2.value = _sString2;
        return _sString1;
    }
    public String getThreeStrings(org.omg.CORBA.StringHolder value2,
                            org.omg.CORBA.StringHolder value3) {
        System.out.println("getThreeStrings");
        value2.value = _sString2;
        value3.value = _sString3;
        return _sString1;
    }

    /////////////// long
    public void setLong(int value) {
        System.out.println("setLong: " + value);
        _lLong1 = (long) value;
    }
    public int getLong() {
        System.out.println("getLong: " + _lLong1);
        return (int) _lLong1;
    }
    public void outLong(org.omg.CORBA.IntHolder value) {
        System.out.println("outLong: " + _lLong1);
        value.value = (int) _lLong1;
    }

    /////////////// short
    public void setShort(short value) {
        System.out.println("setShort: " + value);
        _lLong1 = (long) value;
    }
    public short getShort() {
        System.out.println("getShort: " + _lLong1);
        return (short) _lLong1;
    }
    public void outShort(org.omg.CORBA.ShortHolder value) {
        System.out.println("outShort: " + _lLong1);
        value.value = (short) _lLong1;
    }

    /////////////// unsigned long
    public void setULong(int value) {
        _lLong1 = value;
    }
    public int getULong() {
        return (int) _lLong1;
    }
    public void outULong(org.omg.CORBA.IntHolder value) {
        value.value = (int) _lLong1;
    }

    /////////////// unsigned short
    public void setUShort(short value) {
        _lLong1 = (long) value;
    }
    public short getUShort() {
        return (short) _lLong1;
    }
    public void outUShort(org.omg.CORBA.ShortHolder value) {
        value.value = (short) _lLong1;
    }

    /////////////// char
    public void setChar(char value) {
        _cChar1 = value;
    }
    public char getChar() {
        return _cChar1;
    }
    public void outChar(org.omg.CORBA.CharHolder value) {
        value.value = _cChar1;
    }

    /////////////// boolean
    public void setBoolean(boolean value) {
        _bBoolean1 = value;
    }
    public boolean getBoolean() {
        return _bBoolean1;
    }
    public void outBoolean(org.omg.CORBA.BooleanHolder value) {
        value.value = _bBoolean1;
    }

    /////////////// byte (confusingly called octet by some)
    public void setOctet(byte value) {
        _cChar1 = (char) value;
    }
    public byte getOctet() {
        return (byte) _cChar1;
    }
    public void outOctet(org.omg.CORBA.ByteHolder value) {
        value.value = (byte) _cChar1;
    }


    static public void main(String[] args)
    {
        System.out.println("HelloCorba: initializing...");
        String hostName;
        try {
            hostName = java.net.InetAddress.getLocalHost().getHostName();
        } catch (java.net.UnknownHostException e) {
            hostName = "127.0.0.1";
        }
        try {
            int index = 0;
            while (index < args.length) {
                String anArg = args[index];
                if (anArg.equals("-h")) {
                    hostName = args[index+1];
                }
                ++index;
            }
        } catch (Exception e) {
            System.out.println("ERROR DURING INITIALIZATION");
            System.out.println(e.toString());
            e.printStackTrace();
            System.out.println("------------------");
            System.out.println("HelloCorba parameters:");
            System.out.println("   -h <host>  name of host to register to");
            System.out.println("");
            return;
        }
        System.out.println("HelloCorba: starting CORBA...");
        try {
            // Initialize the ORB.
            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();

            // Initialize the BOA.
            org.omg.CORBA.BOA boa = orb.BOA_init();

            // Create the station object.
            HelloCorba station = new HelloCorbaDaemon("HelloCorba");

            // Export to the newly created object to the ORB
            boa.obj_is_ready(station);

            // Web naming
            // Saves the station's IOR in a file under the web server "iiop_objects" dir
            String regName = "http://" + hostName + "/iiop_objects/HelloCorba";

            // Live object is registered to the URL
            System.out.println("HelloCorba being registered to: " + regName);
            Naming.register(regName, station);

            System.out.println("HelloCorba Daemon ready for service");
            // Ready to service requests.
            boa.impl_is_ready();
        } catch(Exception e) {
            System.out.println("FATAL ERROR DURING EXECUTION");
            System.out.println(e.toString());
            e.printStackTrace();
        }

    }


    ///////////////////////////////////
    //---- instance variables
    String  _sString1;
    String  _sString2;
    String  _sString3;
    long    _lLong1;
    double  _dDouble1;
    char    _cChar1;
    boolean _bBoolean1;
}
