/*
 * FloatingWindow.jsb    1.1 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
 
<JSB>
<JSB_DESCRIPTOR NAME="FloatingWindow" ENV="client" DISPLAYNAME="Floating Window" SHORTDESCRIPTION="Srollable, movable, resizeable window widget">
<JSB_PROPERTY NAME="title" PROPTYPE="JS" TYPE="java.lang.String" DISPLAYNAME="Window Title" SHORTDESCRIPTION="Title to display at the top of the window">
<JSB_PROPERTY NAME="src" PROPTYPE="JS" TYPE="java.lang.String" DISPLAYNAME="Source URL" SHORTDESCRIPTION="URL containing the window's content">
<JSB_PROPERTY NAME="posX" PROPTYPE="JS" TYPE="java.lang.String" DISPLAYNAME="X Position" SHORTDESCRIPTION="X position to start window at">
<JSB_PROPERTY NAME="posY" PROPTYPE="JS" TYPE="java.lang.String" DISPLAYNAME="Y Position" SHORTDESCRIPTION="Y position to start window at">
<JSB_PROPERTY NAME="contentWidth" PROPTYPE="JS" TYPE="java.lang.String" DISPLAYNAME="Content Width" SHORTDESCRIPTION="Width to wrap the content at">
<JSB_PROPERTY NAME="width" PROPTYPE="JS" TYPE="java.lang.String" DISPLAYNAME="Window Width" SHORTDESCRIPTION="Initial width of the window">
<JSB_PROPERTY NAME="height" PROPTYPE="JS" TYPE="java.lang.String" DISPLAYNAME="Window Height" SHORTDESCRIPTION="Initial height of the window">

<JSB_CONSTRUCTOR>
    /*
     * Javascript scrollable/resizable Window class.
     * First version: Jef Pearlman
     * Current Version 1.1
     *
     * Creates a floating layer with the contents of a specified URL
     * Does not support pages with frames, or multiple windows on a page.
     */

    FloatingWindow_curZ=0;
    FloatingWindow_navVersion=eval(navigator.appVersion.charAt(0));

    ///////////////////////////////////////////////////////////////////////////////
    // FloatingWindowSerializer, functions which provide the
    // URL serialization for feeding the contents of the FloatingWindow
    //

    /**
     * First, initialize the serializer iff we are using Navigator 4 and we haven't 
     * already done the initialization.
     */
    if (FloatingWindow_navVersion<4 || window.onload!=FloatingWindowSerializer_onload)
         FloatingWindowSerializer_init(1);
 
        /**
         * Initialize the layer load serializer with p pending loads.
         * Conditionally called by the JSB_Constructor 
         */
        function FloatingWindowSerializer_init(p)
        {
            // Initialize the serializer -- the callback and parameter arrays,
            // pending count, etc.
            FloatingWindowSerializer_callback=new Array;
            FloatingWindowSerializer_param=new Array;
            FloatingWindowSerializer_pending=p;
            FloatingWindowSerializer_current=0;
            FloatingWindowSerializer_top=0;

            // If this is Navigator 4, catch the onload event and store the original 
            // one.
            if (eval(navigator.appVersion.charAt(0))>=4) {	
              FloatingWindow_oldOnload=window.onload;
              window.onload=FloatingWindowSerializer_onload;
            }
        }

        /**
         * Increment the number of pending loads by 1,
         * or n if n is not specified.
         */
        function FloatingWindowSerializer_incPending(n) {
            if (n==null)
                FloatingWindowSerializer_pending++;
            else
                FloatingWindowSerializer_pending+=n;
        }

        /**
         * Decrement the number of pending loads by 1, or n if n is not 
         * specified. Check for a callback if there are no more pending loads.
         */
        function FloatingWindowSerializer_decPending(n) {
            if (n==null)
                FloatingWindowSerializer_pending--;
            else
                FloatingWindowSerializer_pending-=n;

            //This should never go below 0, so check it, and warn if
            // it does.
            if (FloatingWindowSerializer_pending < 0) {
              alert("FloatingWindowSerializer_decPending: There are no pending loads.");
              FloatingWindowSerializer_pending=0;
            }

            // Check for a callback.
            FloatingWindowSerializer_check();
        }

        /**
         * Add a callback to the queue. Run it if there is nothing pending.
         */
        function FloatingWindowSerializer_addCallback(callback, param) {
            FloatingWindowSerializer_callback[FloatingWindowSerializer_top]=callback;
            FloatingWindowSerializer_param[FloatingWindowSerializer_top]=param;
            FloatingWindowSerializer_top++;
            FloatingWindowSerializer_check();
        }

        /**
         * Check if anything is pending and, if not,  if we have any callbacks 
         * waiting.
         */
        function FloatingWindowSerializer_check() {
            if (FloatingWindowSerializer_pending==0 &&
                    FloatingWindowSerializer_top !=
                        FloatingWindowSerializer_current) {	

              // If nothing is pending and we have a callback waiting, 
              // start the next callback.
              FloatingWindowSerializer_goNow=FloatingWindowSerializer_current;
              FloatingWindowSerializer_current++;
              FloatingWindowSerializer_incPending();
              FloatingWindowSerializer_callback[FloatingWindowSerializer_goNow](FloatingWindowSerializer_param[FloatingWindowSerializer_goNow]);
            }
        }

        /**
         * If this is a load we care about, decrement the number
         * of pending loads.
         */
        function FloatingWindowSerializer_onload(e) {
            // alert('onload: '+e.target);
            if (e.target == window || e.target.type == "FloatingWindowContent")
            {
              //      alert('onload '+e.target+" "+FloatingWindowSerializer_pending);
              FloatingWindowSerializer_decPending();
            }
            // If there is an old handler and this is a window load, pass it to 
            // the old handler.
            if (FloatingWindow_oldOnload != null && (FloatingWindow_oldOnload.constructor == Function || FloatingWindow_oldOnload.constructor == Closure))
            FloatingWindow_oldOnload(e);
        }

    ///////////////////////////////////////////////////////////////////////////////
    //
    // Main Floating Window functionality
    //

        /**
         * Show the window!
         */
        function FloatingWindow_show() {
            this.border.visibility="SHOW";
        }

        /**
         * Hide the window!
         */
        function FloatingWindow_hide() {
            this.border.visibility="HIDE";
        }

        /**
         * Null-op function
         */
        function FloatingWindow_dummyMove(e) {
            return true;
        }

        /**
         * Hack to enable drag-mouse capture so I get the mouse-up event 
         * in the layer.
         */
        function FloatingWindow_setupButton(obj,buttonName,down,up,move) {
            if (move!=null) {
              // If a move handler is specified, use it.
              obj.border.layers[buttonName].captureEvents(Event.MOUSEMOVE);
              obj.border.layers[buttonName].onmousemove=move;
            }
            else {
              // Otherwise, capture the mousemove event to enable mouse capture (so 
              // the layer which got the mousedown always gets the mouseup).
              obj.border.layers[buttonName].document.captureEvents(Event.MOUSEMOVE);
              obj.border.layers[buttonName].document.onmousemove=FloatingWindow_dummyMove; 
            }

            // Capture the appropriate events.
            obj.border.layers[buttonName].captureEvents(Event.MOUSEDOWN|Event.MOUSEUP);
            obj.border.layers[buttonName].onmousedown=down;
            obj.border.layers[buttonName].onmouseup=up;
            obj.border.layers[buttonName].obj=obj;
        }

        /**
         * Reload callback to reload the contents of a window.
         */
        function FloatingWindow_reload(obj) {
            // If we are, in fact, reloading, add reUpdateClip as a callback,
            // and start the new load, otherwise decrement the number of pending
            // (to simulate a load).
            if (obj.reloading==true)
            {
              FloatingWindowSerializer_addCallback(FloatingWindow_reUpdateClip,obj);
              if (obj.loadWidth!=obj.contentWidth) {
                  obj.loadWidth=obj.contentWidth;
                  obj.content.load(obj.url,obj.contentWidth);
              } else {
                  FloatingWindowSerializer_decPending();
              }
            }
       }

        /**
         * Add a color bar layer with the specified information, to the 
         * current document.
         */
        function FloatingWindow_addBar(x,y,w,h,barColor,content,id) {
            // If content or id are not specified, set them blank.
            if (content==null)
            content="";
            if (id==null) 
            id="";
            else
            id=" ID="+id;
            document.write("<LAYER"+id+" LEFT="+x+" TOP="+y+" CLIP=0,0,"+w+","+h+" BGCOLOR="+barColor+">"+content+"</LAYER>\n");
        }

        /**
         * Add a layer with an image, with the speicified information, in
         * the current document.
         */
        function FloatingWindow_addImage(x,y,w,h,image,id) {
            // If the id is not specified, set it blank.
            if (id==null)
            id="";
            else
            id=" ID="+id;
            document.write("<LAYER"+id+" LEFT="+x+" TOP="+y+" WIDTH="+w+" HEIGHT="+h+"><IMG WIDTH="+w+" HEIGHT="+h+" SRC=images/"+image+"></LAYER>\n");
        }

        /**
         * Find the parent scrollable Window object of this object.
         */
        function FloatingWindow_findParent(obj) {
        // NOTE: A better way to do this would be to set a property of the layer
        //       which receives the event to point to the top level window object.
        //       This way, the "this" object in the mouse event handler will 
        //       be that layer, and have a property pointing to the window object,
        //       and the recursive findParent would be unneccessary.
        //       With as many layers as we have capturing mouse events, however,
        //       it is more annoying to set properties for each of them manually 
        //       then it is to do this.

        // Simply recurse until you hit a null (top of the list) or an object which
        // contains a FloatingWindow object in an obj property.

            for (obj=obj.__parent__; obj != null && (obj.obj == null || obj.obj.type != "FloatingWindow"); obj=obj.__parent__);
            if (obj==null)
            return obj;
            else
            return obj.obj;
        }

        /**
         * Callback function which updates the clipping and decrements the
         * number of pending loads.
         */
        function FloatingWindow_reUpdateClip(obj) {
            // Update the clipping. 
            FloatingWindow_updateClip(obj);

            // If we need to reload, add it as a callback (this allows resizing content
            // to work -- when one load is over, we can load again if the content doesn't
            // match window width).
            if (obj.loadWidth!=obj.contentWidth)
                FloatingWindowSerializer_addCallback(FloatingWindow_reload,obj);
            else
                obj.reloading=false;

            FloatingWindowSerializer_decPending();
        }

        /**
         * Update the clipping of the window -- move all the scrollbars and 
         * buttons as appropriate, and resize the content clipping area.
         */
        function FloatingWindow_updateClip(obj) {
            // If the clipping view would flow off the end of the document, move the
            // view.
            if (obj.startX+obj.width  > obj.content.document.width)
            obj.startX=obj.content.document.width-obj.width;
            if (obj.startY+obj.height > obj.content.document.height)
            obj.startY=obj.content.document.height-obj.height;
            if (obj.startX < 0)
            obj.startX=0;
            if (obj.startY < 0)
            obj.startY=0;

            // Clip the content window to the correct size.
            obj.content.left=4-obj.startX;
            obj.content.clip.left=obj.startX;
            obj.content.clip.width=obj.width;

            // If the visible width is greather than the content width or is 48 
            // (smallest), we don't need scrollbar stubs.
            if (obj.width>=obj.content.document.width || obj.content.clip.width==48)
            {
              obj.border.layers['bottomStub'].visibility="HIDE";

                // If we're two big, we don't need scroll buttons either. If we're too
                // small, we still do.
                if (obj.width >= obj.content.document.width)	
                {
                  obj.border.layers['leftButtonP'].visibility="HIDE";
                  obj.border.layers['leftButton'].visibility="HIDE";
                  obj.border.layers['rightButtonP'].visibility="HIDE";
                  obj.border.layers['rightButton'].visibility="HIDE";
                } else {
                  obj.border.layers['leftButton'].visibility=obj.leftButtonVis;
                  obj.border.layers['leftButtonP'].visibility="INHERIT";
                  obj.border.layers['rightButton'].visibility=obj.rightButtonVis;
                  obj.border.layers['rightButtonP'].visibility="INHERIT"
                }
            }
            else
            {
              // Otherwise, we do need scrollbar stubs and buttons.
              obj.border.layers['bottomStub'].visibility="INHERIT";
              obj.border.layers['bottomStub'].moveTo(20+obj.startX*(obj.totalWidth-72)/(obj.content.document.width-obj.content.clip.width),obj.totalHeight-20);
              obj.border.layers['leftButton'].visibility=obj.leftButtonVis;
              obj.border.layers['leftButtonP'].visibility="INHERIT";
              obj.border.layers['rightButton'].visibility=obj.rightButtonVis;
              obj.border.layers['rightButtonP'].visibility="INHERIT";
            }

            // Repeat the above clipping and scrollbar steps for the vertical scrollbar.
            obj.content.top=22-obj.startY;
            obj.content.clip.top=obj.startY;
            obj.content.clip.height=obj.height;
            if (obj.height>=obj.content.document.height || obj.content.clip.height==48)
            {
                obj.border.layers['rightStub'].visibility="HIDE";

                if (obj.height >= obj.content.document.height) {
                  obj.border.layers['upButtonP'].visibility="HIDE";
                  obj.border.layers['upButton'].visibility="HIDE";
                  obj.border.layers['downButtonP'].visibility="HIDE";
                  obj.border.layers['downButton'].visibility="HIDE";
                } else {
                  obj.border.layers['upButton'].visibility=obj.upButtonVis;
                  obj.border.layers['upButtonP'].visibility="INHERIT";
                  obj.border.layers['downButton'].visibility=obj.downButtonVis;
                  obj.border.layers['downButtonP'].visibility="INHERIT";
                }
            } else {
              obj.border.layers['rightStub'].visibility="INHERIT";
              obj.border.layers['rightStub'].moveTo(obj.totalWidth-20,38+obj.startY*(obj.totalHeight-90)/(obj.content.document.height-obj.content.clip.height));
              obj.border.layers['upButton'].visibility=obj.upButtonVis;
              obj.border.layers['upButtonP'].visibility="INHERIT";
              obj.border.layers['downButton'].visibility=obj.downButtonVis;
              obj.border.layers['downButtonP'].visibility="INHERIT";
            }
        }

    ///////////////////////////////////////////////////////////////////////////////
    // Mouse events for anywhere on the window.

        /**
         * Mouse down on window:
         * Raise the window to the top level.
         */
        function FloatingWindow_mouseDown(e) {
            // Raise the zindex of the window layer to the top and increment curZ.
            obj=FloatingWindow_findParent(e.target);
            obj.border.zIndex=FloatingWindow_curZ;
            FloatingWindow_curZ++;
            return routeEvent(e);
        }

    ///////////////////////////////////////////////////////////////////////////////
    // Mouse events for right scrollbar button.

        /**
         * Mouse down on right scrollbar button:
         *   Shift content right
         *   Depress button
         */
        function FloatingWindow_downRight(e) {
            // Hide the un-pressed button layer and increment the starting x position
            // of the window. Then reclip.
            obj=FloatingWindow_findParent(e.target);
            obj.rightButtonVis="HIDE";
            obj.startX+=25;
            FloatingWindow_updateClip(obj);
            return false;
        }

        /**
         * Mouse up on right scrollbar button:
         *   Raise button
         */
        function FloatingWindow_upRight(e) {
            // Unhide the un-pressed button layer.
            obj=FloatingWindow_findParent(e.target);
            obj.rightButtonVis="INHERIT";
            FloatingWindow_updateClip(obj);
            return true;
        }

    ///////////////////////////////////////////////////////////////////////////////
    // Mouse events for  left scrollbar button.

        /**
         * Mouse down on left scrollbar button:
         *   Shift content left
         *   Depress button
         */
        function FloatingWindow_downLeft(e) {
            // Hide the un-pressed button layer and decrement the starting x position
            // of the window. Then reclip.
            obj=FloatingWindow_findParent(e.target);
            obj.leftButtonVis="HIDE";
            obj.startX-=25;
            FloatingWindow_updateClip(obj);
            return false;
        }

        /**
         * Mouse up on left scrollbar button:
         *   Raise button
         */
        function FloatingWindow_upLeft(e) {
            // Unhide the un-pressed button layer.
            obj=FloatingWindow_findParent(e.target);
            obj.leftButtonVis="INHERIT";
            FloatingWindow_updateClip(obj);
            return true;
        }

    ///////////////////////////////////////////////////////////////////////////////
    // Mouse events for up scrollbar button.

        /**
         * Mouse down on up scrollbar button:
         *   Shift content up
         *   Depress button
         */
        function FloatingWindow_downUp(e) {
            // Hide the un-pressed button layer and decrement the starting y position
            // of the window. Then reclip.
            obj=FloatingWindow_findParent(e.target);
            obj.upButtonVis="HIDE";
            obj.startY-=25;
            FloatingWindow_updateClip(obj);
            return false;
        }


        /**
         * Mouse up on up scrollbar button:
         *   Raise button
         */
        function FloatingWindow_upUp(e) {
            // Unhide the un-pressed button layer.
            obj=FloatingWindow_findParent(e.target);
            obj.upButtonVis="INHERIT";
            FloatingWindow_updateClip(obj);
            return true;
        }

    ///////////////////////////////////////////////////////////////////////////////
    // Mouse events for down scrollbar button.

        /**
         * Mouse down on down scrollbar button:
         *   Shift content down
         *   Depress button
         */
        function FloatingWindow_downDown(e) {
            // Hide the un-pressed button layer and increment the starting y position
            // of the window. Then reclip.
            obj=FloatingWindow_findParent(e.target);
            obj.downButtonVis="HIDE";
            obj.startY+=25;
            FloatingWindow_updateClip(obj);
            return false;
        }

        /**
         * Mouse up on down scrollbar button:
         *   Raise button
         */
        function FloatingWindow_upDown(e) {
            // Unhide the un-pressed button layer.
            obj=FloatingWindow_findParent(e.target);
            obj.downButtonVis="INHERIT";
            FloatingWindow_updateClip(obj);
            return true;
        }

    ///////////////////////////////////////////////////////////////////////////////
    // Mouse events for horizontal scrollbar stub.

        /**
         * Mouse down on horizontal scrollbar stub:
         *   Record current x position of the cursor and stub
         *   Start sliding page
         */
        function FloatingWindow_downBottomStub(e) {
            // Record the fact that the bottom stub has been pressed and the current
            // x location of the cursor and of the stub itself.
            obj=FloatingWindow_findParent(e.target);
            obj.bottomStub=true;
            obj.oldX=e.pageX;
            obj.border.layers['bottomStub'].oldL=obj.border.layers['bottomStub'].left-20;
            return false;
        }


        /**
         * Mouse up on horizontal scrollbar stub:
         *   Stop sliding page
         */
        function FloatingWindow_upBottomStub(e) {
            // Record the fact that the bottom stub is no longer pressed.
            obj=FloatingWindow_findParent(e.target);
            obj.bottomStub=false;
            return true;
        }

        /**
         * Mouse movement on horizontal scrollbar stub:
         *   If we're sliding, move the window and update the clip.
         */
        function FloatingWindow_moveBottomStub(e) {
            // Check if we're sliding.
            obj=FloatingWindow_findParent(e.target);

            if (obj.bottomStub==true) {
              // If we are, calculate the new position, and update the clip.
              stubX=obj.border.layers['bottomStub'].oldL-(obj.oldX-e.pageX);
              obj.startX=stubX*(obj.content.document.width-obj.content.clip.width)/(obj.totalWidth-72);
              FloatingWindow_updateClip(obj);      
              return false;
            }

            return true;
        }

    ///////////////////////////////////////////////////////////////////////////////
    // Mouse events for vertical scrollbar stub.

        /**
         * Mouse down on vertical scrollbar stub:
         *   Record current y position of the cursor and stub
         *   Start sliding page
         */
        function FloatingWindow_downRightStub(e) {
            // Record the fact that the bottom stub has been pressed and the current
            // x location of the cursor and of the stub itself.
            obj=FloatingWindow_findParent(e.target);
            obj.rightStub=true;
            obj.oldY=e.pageY;
            obj.border.layers['rightStub'].oldT=obj.border.layers['rightStub'].top-38;
            return false;
        }

        /**
         * Mouse up on vertical scrollbar stub:
         *   Stop sliding page
         */
        function FloatingWindow_upRightStub(e) {
            // Record the fact that the bottom stub is no longer pressed.
            obj=FloatingWindow_findParent(e.target);
            obj.rightStub=false;
            return true;
        }

        /**
         * Mouse movement on vertical scrollbar stub:
         *   If we're sliding, move the window and update the clip.
         */
        function FloatingWindow_moveRightStub(e) {
            // Check if we're sliding.
            obj=FloatingWindow_findParent(e.target);

            if (obj.rightStub==true) {
              // If we are, calculate the new position, and update the clip.
              stubY=obj.border.layers['rightStub'].oldT-(obj.oldY-e.pageY);
              obj.startY=stubY*(obj.content.document.height-obj.content.clip.height)/(obj.totalHeight-90);
              FloatingWindow_updateClip(obj);
              return false;
            }

            return true;
        }

    ///////////////////////////////////////////////////////////////////////////////
    // Mouse events for bottom scrollbar area.

        /**
         * Mouse down on horizontal scrollbar area:
         *   Scroll to the right or left, depending on where the stub is
         *   Update clip
         */
        function FloatingWindow_downBBar(e) {
            // If we're to the right of the stub, increment x, else decrement it.
            obj=FloatingWindow_findParent(e.target);
            if (obj.border.layers['bottomStub'].visibility!="hide") {
              if (obj.border.layers['bottomStub'].pageX < e.pageX) 
                    obj.startX+=obj.content.clip.width;
              else
                    obj.startX-=obj.content.clip.width;

              FloatingWindow_updateClip(obj);
            }
            return false;
        }

        /**
         * Mouse up on horizontal scrollbar area:
         */
        function FloatingWindow_upBBar(e) {
            return true;
        }

        /**
         * Mouse down on rightbar
         */
        function FloatingWindow_downRBar(e) {
            if (obj.border.layers['rightStub'].visibility!="hide")
            {
              obj=FloatingWindow_findParent(e.target);
              if (obj.border.layers['rightStub'].pageY < e.pageY) 
                obj.startY+=obj.content.clip.height;
              else
                obj.startY-=obj.content.clip.height;

              FloatingWindow_updateClip(obj);
            }
            return false;
        }

        /**
         * Mouse up on rightbar
         */
        function FloatingWindow_upRBar(e) {
            return true;
        }

        /**
         * Mouse up on rightbar
         */
        function FloatingWindow_downTitle(e) {
            obj=FloatingWindow_findParent(e.target);
            obj.dragWindow=true;
            obj.oldX=e.pageX;
            obj.oldY=e.pageY;
            obj.saveX=obj.border.x;
            obj.saveY=obj.border.y;
            return false;
        }

        /**
         * Mouse up on title
         */
        function FloatingWindow_upTitle(e) {
            obj=FloatingWindow_findParent(e.target);
            obj.dragWindow=false;
            return true;
        }

        /**
         * move title
         */
        function FloatingWindow_moveTitle(e) {
            obj=FloatingWindow_findParent(e.target);
            if (obj.dragWindow==true)
            {
              var pageX=e.pageX, pageY=e.pageY;
              if (pageX<0) pageX=0;
              if (pageY<0) pageY=0;
              if (pageX>window.innerWidth) pageX=window.innerWidth;
              if (pageY>window.innerHeight) pageY=window.innerHeight;
              obj.border.moveTo((pageX-obj.oldX)+obj.saveX, (pageY-obj.oldY)+obj.saveY);
              return false;
            }
            return true;
        }

        function FloatingWindow_downCorner(e) {
          obj=FloatingWindow_findParent(e.target);
            if (obj.content.document.width==0 || obj.content.document.height==0) 
            return false;
            obj.resizeWindow=true;
            obj.oldX=e.pageX; 
            obj.saveX=e.pageX; obj.saveW=obj.border.clip.width;
            obj.oldY=e.pageY; 
            obj.saveY=e.pageY; obj.saveH=obj.border.clip.height;
            return false;
        }

        function FloatingWindow_upCorner(e) {
            obj=FloatingWindow_findParent(e.target);
            obj.resizeWindow=false;
            return true;
        }

        function FloatingWindow_moveCorner(e) {
            obj=FloatingWindow_findParent(e.target);
            if (obj.resizeWindow==true) {
              diffX=e.pageX-obj.saveX; diffX-=(obj.border.clip.width-obj.saveW);
              diffY=e.pageY-obj.saveY; diffY-=(obj.border.clip.height-obj.saveH);
              if (obj.width+diffX < 48)
                    diffX=48-obj.width;

              if (obj.height+diffY < 48)
                    diffY=48-obj.height;

              if (obj.width+diffX > obj.content.document.width
                            && obj.fixedWidth==true)
                    diffX=obj.content.document.width-obj.width;

              if (obj.height+diffY > obj.content.document.height
                            && obj.fixedWidth==true)
                    diffY=obj.content.document.height-obj.height;

              obj.oldX=e.pageX;
              obj.oldY=e.pageY;
              obj.border.resizeBy(diffX,diffY);

              for (i=1;i<4;i++) {
                if (i<3) {
                  obj.border.layers['top'+i].resizeBy(diffX,0);
                  obj.border.layers['left'+i].resizeBy(0,diffY);
                }
                  obj.border.layers['bottom'+i].moveBy(0,diffY);
                  obj.border.layers['bottom'+i].resizeBy(diffX,0);
                  obj.border.layers['right'+i].moveBy(diffX,0);
                  obj.border.layers['right'+i].resizeBy(0,diffY);
              }

              obj.border.layers['leftButtonD'].moveBy(0,diffY);
              obj.border.layers['leftButtonP'].moveBy(0,diffY);
              obj.border.layers['leftButton'].moveBy(0,diffY);
              obj.border.layers['rightButtonD'].moveBy(diffX,diffY);
              obj.border.layers['rightButtonP'].moveBy(diffX,diffY);
              obj.border.layers['rightButton'].moveBy(diffX,diffY);
              obj.border.layers['bottomStub'].moveBy(0,diffY);
              obj.border.layers['corner'].moveBy(diffX,diffY);
              obj.border.layers['upButtonD'].moveBy(diffX,0);
              obj.border.layers['upButtonP'].moveBy(diffX,0);
              obj.border.layers['upButton'].moveBy(diffX,0);
              obj.border.layers['downButtonD'].moveBy(diffX,diffY);
              obj.border.layers['downButtonP'].moveBy(diffX,diffY);
              obj.border.layers['downButton'].moveBy(diffX,diffY);
              obj.border.layers['rightStub'].moveBy(diffX,diffY);
              obj.border.layers['rightBar'].moveBy(diffX,0);
              obj.border.layers['rightBar'].resizeBy(0,diffY);
              obj.border.layers['bottomBar'].moveBy(0,diffY);
              obj.border.layers['bottomBar'].resizeBy(diffX,0);
              obj.border.layers['title'].resizeBy(diffX,0);	
              obj.border.layers['title'].layers['titleText'].clip.width+=diffX;
              obj.border.layers['title'].layers['xButton'].moveBy(diffX,0);
              obj.width+=diffX;
              obj.height+=diffY;
              obj.totalHeight=obj.height+(obj.borderWidth*2)+obj.titleHeight+obj.barWidth;
              obj.totalWidth=obj.width+(obj.borderWidth*2)+obj.barWidth;

            if (obj.fixedWidth==false)
            {
              obj.contentWidth+=diffX;
              if (obj.reloading==false) {
                  obj.reloading=true;
                  FloatingWindowSerializer_addCallback(FloatingWindow_reload,obj);
              }
            }
              FloatingWindow_updateClip(obj);
              return false;
            }

            return true;
        }

        function FloatingWindow_null(a,b) {
            if (a==null||a=="") 
                return b;

            return a;
        }

        function FloatingWindow(p) {
            id=FloatingWindow_null(p.id,"default"+FloatingWindow_curZ);
            title=FloatingWindow_null(p.title,id);
            src=FloatingWindow_null(p.src,"http://www.netscape.com/");
            posX=eval(FloatingWindow_null(p.posX,"0"));
            posY=eval(FloatingWindow_null(p.posY,"0"));
            width=eval(FloatingWindow_null(p.width,"0"));
            height=eval(FloatingWindow_null(p.height,"0"));
            contentWidth=FloatingWindow_null(p.contentWidth,null);

            // Trap sizes too small to use and make a reasonable
            // minimum size
            if (width < 48 || width == null)
                    width=48;
            if (height < 48 || height == null)
                    height=48;

            // Kickdown when run on a non-Netscape4.x 
            // browser
            if (eval(navigator.appVersion.charAt(0))<4) {
              window.open(src,id,"toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width="+width+",height="+height);
              return this;
            };

            // Creates a window widget object.
            // Uses src as the source url.

            this.type="FloatingWindow";
            this.borderWidth=4;
            this.rightButtonVis="INHERIT";
            this.leftButtonVis="INHERIT";
            this.upButtonVis="INHERIT";
            this.downButtonVis="INHERIT";
            this.url=src;
            this.id=id;
            this.startX=0;
            this.startY=0;
            this.show=FloatingWindow_show;
            this.hide=FloatingWindow_hide;
            this.addBar=FloatingWindow_addBar;
            this.addImage=FloatingWindow_addImage;
            this.width=width;
            this.height=height;
            this.inclip=false;
            this.title=title;
            this.bottomStub=false;
            this.rightStub=false;
            this.oldX=0;
            this.oldY=0;
            this.titleHeight=18;
            this.barWidth=16
            this.totalHeight=this.height+(this.borderWidth*2)+this.titleHeight+this.barWidth;
            this.totalWidth=this.width+(this.borderWidth*2)+this.barWidth;
            this.scrollEnabled=true;
            this.reloading=true;
            this.loadWidth=0; // Start at 0 so initial reload actually loads.

            FloatingWindowSerializer_incPending();
            if (contentWidth!=null) {
              this.contentWidth=contentWidth;
              contentWidthS="WIDTH="+contentWidth;
              contentWidthS2="WIDTH="+(this.totalWidth+(eval(contentWidth)-this.width));
              this.fixedWidth=true;
            } else {
              this.contentWidth=width;
              contentWidthS="WIDTH="+width;
              contentWidthS2="WIDTH="+(this.totalWidth);
              this.fixedWidth=false;
            }

            // 2 -- Main window

            document.write("<LAYER id="+id+"Border Z-INDEX="+FloatingWindow_curZ+" CLIP=0,0,"+(this.totalWidth)+","+(this.totalHeight)+" BGCOLOR=BLACK "+contentWidthS2+" HEIGHT="+(this.totalHeight)+" LEFT="+posX+" TOP="+posY+" VISIBILITY=HIDE>\n");
            document.write("<LAYER id="+id+"Content LEFT=4 TOP="+(this.titleHeight+this.borderWidth)+" CLIP=0,0,"+(width)+","+(height)+" "+contentWidthS+" VISIBILITY=INHERIT></LAYER>\n");
            FloatingWindow_curZ++;

            // 4 -- Title Bar
            this.addBar(4,4,width+this.barWidth,this.titleHeight,'000084',"<BODY BGCOLOR='000084' TEXT='FFFFFF'><LAYER BGCOLOR='000084' TOP=1 LEFT=1 WIDTH=16 HEIGHT=16><IMG WIDTH=16 HEIGHT=16 SRC=images/icon_nav.gif></LAYER><LAYER ID=titleText BGCOLOR='000084' TOP=-1 LEFT=20 WIDTH=4096 HEIGHT=18 CLIP=0,0,"+(this.totalWidth-28)+",19>"+title,"title");
            this.addImage(this.totalWidth-26,2,16,14,"button_x_d.gif","xButton")

            document.write("</LAYER></BODY>");

            //this.addBar(4,4,width+this.barWidth,this.titleHeight,'000084');
            // 2 -- Left 
            this.addBar(0,0,4,this.totalHeight-1,'C6C6C6',"","left1");
            this.addBar(1,1,1,this.totalHeight-2,'FFFFFF',"","left2");
            // 2 -- Top
            this.addBar(4,0,this.totalWidth-5,4,'C6C6C6',"","top1");
            this.addBar(2,1,this.totalWidth-4,1,'FFFFFF',"","top2");
            // 3 -- Right
            this.addBar(this.totalWidth-4,2,4,this.totalHeight-4,'C6C6C6',"","right1");
            this.addBar(this.totalWidth-2,1,1,this.totalHeight-2,'848484',"","right2");
            this.addBar(this.totalWidth-1,0,1,this.totalHeight,'000000',"","right3");
            // 3 -- Bottom
            this.addBar(4,this.totalHeight-4,this.totalWidth-8,4,'C6C6C6',"","bottom1");
            this.addBar(1,this.totalHeight-2,this.totalWidth-3,1,'848484',"","bottom2");
            this.addBar(0,this.totalHeight-1,this.totalWidth-1,1,'000000',"","bottom3");
            // 2 -- ScrollBar
            this.addBar(20,this.totalHeight-(this.barWidth+4),this.totalWidth-56,this.barWidth,'E3E3E3',"","bottomBar");
            this.addBar(this.totalWidth-(this.barWidth+4),this.titleHeight+20,this.barWidth,this.totalHeight-74,'E3E3E3',"","rightBar");
            // 15 -- Icons
            this.addImage(this.totalWidth-20,this.totalHeight-20,16,16,"corner.gif","corner"); 
            this.addImage(4,this.totalHeight-20,16,16,"button_left_d.gif","leftButtonD");
            this.addImage(4,this.totalHeight-20,16,16,"button_left_p.gif","leftButtonP");
            this.addImage(4,this.totalHeight-20,16,16,"button_left_e.gif","leftButton");
            this.addImage(20,this.totalHeight-20,16,16,"button_stub_e.gif","bottomStub");
            this.addImage(this.totalWidth-36,this.totalHeight-20,16,16,"button_right_d.gif","rightButtonD");
            this.addImage(this.totalWidth-36,this.totalHeight-20,16,16,"button_right_p.gif","rightButtonP");
            this.addImage(this.totalWidth-36,this.totalHeight-20,16,16,"button_right_e.gif","rightButton");
            this.addImage(this.totalWidth-20,22,16,16,"button_up_d.gif","upButtonD");
            this.addImage(this.totalWidth-20,22,16,16,"button_up_p.gif","upButtonP");
            this.addImage(this.totalWidth-20,22,16,16,"button_up_e.gif","upButton");
            this.addImage(this.totalWidth-20,38,16,16,"button_stub_e.gif","rightStub");
            this.addImage(this.totalWidth-20,this.totalHeight-36,16,16,"button_down_d.gif","downButtonD");
            this.addImage(this.totalWidth-20,this.totalHeight-36,16,16,"button_down_p.gif","downButtonP");
            this.addImage(this.totalWidth-20,this.totalHeight-36,16,16,"button_down_e.gif","downButton");

            document.write("</LAYER>\n");

            this.border=document.layers[this.id+"Border"];
            this.content=this.border.layers[this.id+"Content"];  
            this.content.onload=FloatingWindowSerializer_onload;
            this.content.type="FloatingWindowContent";
            this.content.obj=this;
            this.border.document.captureEvents(Event.MOUSEDOWN);
            this.border.document.onmousedown=FloatingWindow_mouseDown;   
            FloatingWindow_setupButton(this,'rightButton',FloatingWindow_downRight,FloatingWindow_upRight);
            FloatingWindow_setupButton(this,'leftButton',FloatingWindow_downLeft,FloatingWindow_upLeft);
            FloatingWindow_setupButton(this,'upButton',FloatingWindow_downUp,FloatingWindow_upUp);
            FloatingWindow_setupButton(this,'downButton',FloatingWindow_downDown,FloatingWindow_upDown);
            FloatingWindow_setupButton(this,'bottomStub',FloatingWindow_downBottomStub,FloatingWindow_upBottomStub,FloatingWindow_moveBottomStub);
            FloatingWindow_setupButton(this,'rightStub',FloatingWindow_downRightStub,FloatingWindow_upRightStub,FloatingWindow_moveRightStub);
            FloatingWindow_setupButton(this,'bottomBar',FloatingWindow_downBBar,FloatingWindow_upBBar);
            FloatingWindow_setupButton(this,'rightBar',FloatingWindow_downRBar,FloatingWindow_upRBar);
            FloatingWindow_setupButton(this,'title',FloatingWindow_downTitle,FloatingWindow_upTitle,FloatingWindow_moveTitle);
            FloatingWindow_setupButton(this,'corner',FloatingWindow_downCorner,FloatingWindow_upCorner,FloatingWindow_moveCorner);
            FloatingWindow_updateClip(this);
            FloatingWindowSerializer_addCallback(FloatingWindow_reload,this);
            this.show();

            return this;
        }

</JSB_CONSTRUCTOR>
</JSB>
