<JSB>
    <JSB_DESCRIPTOR NAME="netscape.peas.DBPool"
        DISPLAYNAME="Database Connection Pool"
        HELP_URL="$installdir/doc/compref1.htm#LiveWire DBPool"
        SHORTDESCRIPTION="LiveWire Database Connection Pool" ENV="server" ISHIDDEN>

    <JSB_PROPERTY NAME="dbType" DISPLAYNAME="Database Type" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        VALUESET="ORACLE,Personal Oracle Lite,INFORMIX,SYBASE,DB2,ODBC-SQL Anywhere,ODBC-SQL Server,ODBC-other"
        SHORTDESCRIPTION="Database type">

    <JSB_PROPERTY NAME="dbServer" DISPLAYNAME="Database Server" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name of database server">

    <JSB_PROPERTY NAME="userName" DISPLAYNAME="User Name" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="User name on database server">

    <JSB_PROPERTY NAME="password" DISPLAYNAME="Password" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="password on database server">

    <JSB_PROPERTY NAME="dbName" DISPLAYNAME="Database Name" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Database name">

    <JSB_PROPERTY NAME="maxConnections" DISPLAYNAME="Max. Connections" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD=""
        VALUESET="nonNegative"
        SHORTDESCRIPTION="Max number of database connections to cache (ES3)">

    <JSB_PROPERTY NAME="transactionMode" DISPLAYNAME="Transaction Mode" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        VALUESET="commit,rollback"
        SHORTDESCRIPTION="Commit or rollback open transactions when connection released (ES3)">

    <JSB_PROPERTY NAME="timeout" DISPLAYNAME="Timeout Interval" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD=""
        VALUESET="nonNegative"
        SHORTDESCRIPTION="Timeout interval to wait for available connection (ES3)">

    <JSB_METHOD NAME="connect" TYPE="void">
        <JSB_PARAMETER NAME="dbType" TYPE="string" VALUESET="ORACLE,ODBC,INFORMIX,SYBASE,DB2">
        <JSB_PARAMETER NAME="dbServer" TYPE="string">
        <JSB_PARAMETER NAME="userName" TYPE="string">
        <JSB_PARAMETER NAME="password" TYPE="string">
        <JSB_PARAMETER NAME="dbName" TYPE="string">
        <JSB_PARAMETER NAME="maxConnections" TYPE="number" VALUESET="1:32767">
        <JSB_PARAMETER NAME="autoCommit" TYPE="string">
    </JSB_METHOD>

    <JSB_METHOD NAME="disconnect" TYPE="void">            </JSB_METHOD>

    <JSB_METHOD NAME="connected" TYPE="boolean">          </JSB_METHOD>

    <JSB_METHOD NAME="connection" TYPE="boolean">
        <JSB_PARAMETER NAME="name" TYPE="string">
        <JSB_PARAMETER NAME="timeout" TYPE="number" VALUESET="1:32767">
    </JSB_METHOD>


    <JSB_CONSTRUCTOR>
function displayErrMsgs(db) {
    write("Error: Unable to connect to database.  Check that your username and password are correct")
    write("and that you have specified the correct name for the database server, database name, and type.")
    write("<P>Major Error Message: " + db.majorErrorMessage() )
    write("<P>Minor Error Message: " + db.minorErrorMessage() )
    write("<P>Major Error Code: " + db.majorErrorCode() )
    write("<P>Minor Error Code: " + db.minorErrorCode() )
}

function netscape_peas_DBPool(params) {
   if  (params.dbName == null)
      params.dbName = ""
   if  (params.password == null)
      params.password = ""
   if (params.dbType.indexOf("ODBC") != -1)
      params.dbType = "ODBC"
   if (params.dbType == "Personal Oracle Lite") //use ODBC to connect to POLite
      params.dbType = "ODBC"

   project.dbType = params.dbType
   project.dbServer = params.dbServer
   project.userName = params.userName
   project.password = params.password
   project.dbName = params.dbName

   this.timeout = params.timeout
   this.id = params.id

   // ----------------- Server 3.0 ----------------------
   if (server.httpdlwVersion.indexOf("3.0") != -1) {
      if (project[params.id] == null) {  //Create db pool if it doesn't already exist
         pool = new DbPool(params.dbType, params.dbServer, params.userName, params.password, params.dbName, params.maxConnections, params.transactionMode)
         project[params.id] = pool
      } else {
	   pool = project[params.id]
	}
      if  ( !pool.connected() )
         displayErrMsgs(pool)
      else
         return pool

   // ----------------- Server 2.0 ----------------------
   } else {
      dbObj = new Object()
      with (params) {
         database.connect(dbType, dbServer, userName, password, dbName)
      }
      if  ( !database.connected() )
         displayErrMsgs(database)
      else
          return dbObj
      }
} // netscape_peas_DBPool

    </JSB_CONSTRUCTOR>
</JSB>