<JSB>
/*
 * ScrollingBanner.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */

   <JSB_DESCRIPTOR NAME="netscape.samples.widgets.ScrollingBanner"
                   ENV="client"
                   DISPLAYNAME="Scrolling Banner"
                   SHORTDESCRIPTION="JavaScript Scrolling Banner"
                   CUSTOMIZER="netscape.samples.widgets.ScrollingBannerCustomizer"
                   HELP_URL="netscape/samples/widgets/ScrollingBanner_jsb.html">

   /**
    * n_s_w_ stands for netscape/samples/simple...
    * allows icon to sit in root of jar while
    * providing reasonable namespace collision-prevention
    */
   <JSB_ICON ICONNAME="n_s_w_scrollingbanner">

   /**
    * Determines the message to be displayed in the status bar
    * @see speed
    * @see position
    */
   <JSB_PROPERTY NAME="msg" TYPE="string"
                 PROPTYPE="JS"
                 DISPLAYNAME="Message"
                 DEFAULT_VALUE="Text message to scroll in status bar">

   /**
    * Determines the speed of scrolling
    */
   <JSB_PROPERTY NAME="speed" TYPE="number"
                 PROPTYPE="JS"
                 DISPLAYNAME="Scroll Speed"
                 SHORTDESCRIPTION="Scrolling Speed"
                 DEFAULT_VALUE="180">

   /**
    * Determines the position of the banner
    * upon initial startup.  This is an advanced
    * feature which is not exposed by the Customizer.
    */
   <JSB_PROPERTY NAME="position"
                 PROPTYPE="JS"
                 DISPLAYNAME="Start Position"
                 SHORTDESCRIPTION="Starting position of message">

   <JSB_METHOD NAME="start" TYPE="void">
   </JSB_METHOD>

   <JSB_METHOD NAME="stop" TYPE="void">
   </JSB_METHOD>

   <JSB_METHOD NAME="reset" TYPE="void">
   </JSB_METHOD>

   <JSB_CONSTRUCTOR>


    /**
     * Main functional portion of the scroller
     * Starts animating a message across the status bar
     */
    function netscape_samples_widgets_ScrollingBanner_start() {
      if (this.currentPos == null) 
         this.currentPos = this.pos;

      for (i = 0; i < this.currentPos; i++) 
         this.out += " ";

      if (this.currentPos >= 0)
         this.out += this.msg;
      else 
         this.out = this.msg.substring(-this.currentPos, this.msg.length);

      window.status = this.out;
      this.out = " ";
      this.currentPos--;
      if (this.currentPos < -(this.msg.length))
         this.reset();

      execStr = this.id + ".start()";
      this.bannerID = setTimeout (execStr, this.speed);
    }

    /**
     * Stops the scroller
     */
    function netscape_samples_widgets_ScrollingBanner_stop() {
       clearTimeout(this.bannerID);
    }

    /**
     * Resets the scroller
     */
    function netscape_samples_widgets_ScrollingBanner_reset() {
      this.currentPos = this.pos
    }

    /**
     * Main constructor for the
     * Scrolling Banner
     */
    function netscape_samples_widgets_ScrollingBanner(params) {
      this.msg = params.msg
      this.speed = params.speed
      if (this.speed==0) this.speed = 0
      this.pos = params.position
      this.out = " "
      this.id = params.id
      this.start = netscape_samples_widgets_ScrollingBanner_start;
      this.stop = netscape_samples_widgets_ScrollingBanner_stop;
      this.reset = netscape_samples_widgets_ScrollingBanner_reset;
    }

    

   </JSB_CONSTRUCTOR>
</JSB>
