<JSB>
/*
 * ValidatedText.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
     <JSB_DESCRIPTOR NAME="netscape.peas.ValidatedText" DISPLAYNAME="Validated Text"
        ISHIDDEN ENV="client"
        SHORTDESCRIPTION="Validated input text form field" VISUAL="netscape.palomar.page.component.HTMLTextField">

    <JSB_PROPERTY NAME="value" DISPLAYNAME="value" PROPTYPE="JS" TYPE="string"
        READMETHOD="getValue" WRITEMETHOD="setValue"
        ISRUNTIME ISBOUND ISDEFAULT SHORTDESCRIPTION="Current value of text">

    <JSB_PROPERTY NAME="type" DISPLAYNAME="type" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD="setCurrentRowNumber"
        SHORTDESCRIPTION="type attribute (type attribute)">

    <JSB_PROPERTY NAME="form" DISPLAYNAME="form" PROPTYPE="JS" TYPE="Object"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="form containing the text object">

    <JSB_PROPERTY NAME="size" DISPLAYNAME="Size" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Size of text field">

    <JSB_PROPERTY NAME="isRequired" DISPLAYNAME="Value is required" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Validation requires a value for this field.">

    <JSB_PROPERTY NAME="expression" DISPLAYNAME="Validation expression" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Validation expression (use 'obj' to refer to JavaScript object corresponding to field.">

    <JSB_PROPERTY NAME="validateOnSubmit" DISPLAYNAME="validateOnSubmit" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Validation is perfomed on form's onSubmit event.">

    <JSB_PROPERTY NAME="validateOnBlur" DISPLAYNAME="validateOnBlur" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Validation is perfomed on onBlur event.">

    <JSB_PROPERTY NAME="validateOnChange" DISPLAYNAME="validateOnChange" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Validation is perfomed on onChange event.">

    <JSB_PROPERTY NAME="errorMessage" DISPLAYNAME="errorMessage" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Custom error message to display if validation fails.">

    <JSB_METHOD NAME="getValue" TYPE="string" ENV="client"></JSB_METHOD>
    <JSB_METHOD NAME="setValue" TYPE="void" ENV="client">
        <JSB_PARAMETER NAME="newValue" TYPE="string">
    </JSB_METHOD>

    <JSB_METHOD NAME="blur" TYPE="void"> </JSB_METHOD>
    <JSB_METHOD NAME="eval" TYPE="void"> </JSB_METHOD>
    <JSB_METHOD NAME="focus" TYPE="void"> </JSB_METHOD>
    <JSB_METHOD NAME="select" TYPE="void"> </JSB_METHOD>
    <JSB_METHOD NAME="toString" TYPE="string"> </JSB_METHOD>
    <JSB_METHOD NAME="valueOf" TYPE="object"> </JSB_METHOD>

    <JSB_METHOD NAME="validate" TYPE="boolean"> </JSB_METHOD>

    <JSB_EVENT NAME="onBlur" LISTENERMETHODS="onBlur" LISTENERTYPE="onBlurListener" EVENTMODEL="JS">
    <JSB_EVENT NAME="onChange" LISTENERMETHODS="onChange" LISTENERTYPE="onChangeListener" EVENTMODEL="JS" ISDEFAULT>
    <JSB_EVENT NAME="onFocus" LISTENERMETHODS="onFocus" LISTENERTYPE="onFocusListener" EVENTMODEL="JS">
    <JSB_EVENT NAME="onSelect" LISTENERMETHODS="onSelect" LISTENERTYPE="onSelectListener" EVENTMODEL="JS">

    <JSB_CONSTRUCTOR>

function validatedText_validate( obj ) {
    sValue = obj.value;
	if ( this.isRequired ) {
		if ( sValue == null || sValue=="" ) {
	        if ( null != this.errorMessage && "" != this.errorMessage ) {
	            alert( this.errorMessage );
	        } else {
	            alert( "Required field not present: " + obj.name );
	        }
			return false;
		}
	}
	if ( this.expression != null && this.expression != "" ) {
	    bFlag = eval( this.expression );
	    if ( ! bFlag ) {
	        if ( null != this.errorMessage && "" != this.errorMessage ) {
	            alert( this.errorMessage );
	        } else {
	            alert( "Validation Expression returned 'false'." );
	        }
			return false;
        }
	}
	return true;
}
function validatedText_setValue( sNewValue ) {
    obj = this.getObj();
    obj.value = sNewValue;
}

function validatedText_getValue() {
    obj = this.getObj();
    return obj.value;
}

function validatedText_getObj() {
    if ( null != this.obj ) {
        return this.obj;
    }
    nForms = document.forms.length;
    for ( nF = 0; nF < nForms; nF++ ) {
        oF = document.forms[nF];
        nElements = oF.elements.length;
        for ( nE = 0; nE < nElements; nE++ ) {
            oE = oF[nE];
            if ( oE.name == this.id ) {
                this.obj = oE;
                return oE;
            }
        }
    }
    return null;
}

function netscape_peas_ValidatedText(p) {
	vi = new Object();

	vi.getValue = validatedText_getValue;
	vi.setValue = validatedText_setValue;
	vi.getObj = validatedText_getObj;
	vi.validate = validatedText_validate;

	vi.isRequired = p.isRequired;
	vi.id = p.id
	vi.errorMessage = p.errorMessage
	vi.expression = p.expression
    vi.validateOnChange = p.validateOnChange
    vi.validateOnSubmit = p.validateOnSubmit
    vi.validateOnBlur = p.validateOnBlur
    vi.type = "input"


	sBlur = " onBlur='return vOnBlur( this )'";
	sFocus = " onFocus='return vOnFocus( this )'";
	sChange = " onChange='return vOnChange( this )'";
	sSelect = " onSelect='return vOnSelect( this )'";
	if ( null != vi.size && vi.size != "" ) {
    	sSize = " size='" + p.size+"'";
    } else {
        sSize = "";
    }
	if ( null != vi.value ) {
	    sValue = " value='"+vi.value+"'";
	} else {
	    sValue = "";
	}
	document.write( "<input type=text name='" + vi.id + "'" + sValue + sSize + sChange + sFocus + sBlur + sSelect + "'>" )
	return vi;
}

function vOnChange( oElement ) {
	v = window[oElement.name];
	if ( v.validateOnChange ) {
	    if ( ! v.validate( oElement ) ) {
	        return false;
	    }
	}
    if ( null != v.onChange ) {
        v.onChange( "value", null, oElement.value );
    }
    return true;
}

function vOnBlur( oElement ) {
	v = window[oElement.name];
	if ( v.validateOnBlur ) {
	    if ( ! v.validate( oElement ) ) {
	        return false;
	    }
	}
    if ( null != v.onBlur ) {
        v.onBlur();
    }
    return true;
}

function vOnFocus( oElement ) {
	v = window[oElement.name];
	if ( null != v.onFocus ) {
        v.onFocus();
    }
    return true;
}
function vOnSelect( oElement ) {
	v = window[oElement.name];
	if ( null != v.onSelect ) {
        v.onSelect();
    }
    return true;
}

    </JSB_CONSTRUCTOR>
