/*
 * TableInfo.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * created: 2/97 cls
 */


package netscape.peas;





/**
 * Basic methods of a Cursor component.  A cursor component is a component which
 * supports the CursorDataProvider and/or the CursorDataReceiver interfaces, both
 * of which have a method for obtaining this interface.
 *
 * Still to do... info about database?
 */
 public interface TableInfo {

    /**
     * Getter method for this cursor's "query" property.
     */
	public String getQuery();

    /**
     * Setter method for this cursor's "query" property.
     */
	public void setQuery( String sNewQuery );

    /**
     * Setter method for this cursor's "bufferSize" property.
     * this specifies the number of rows fetched when the query
     * is executed, and on successive fetchMoreRows() calls.
     *
     * A buffer size of 0 means that all rows are fetched before
     * control is returned from executeQuery.
     */
	public int getFetchBufferSize();

    /**
     * Getter method for this cursor's "bufferSize" property.
     * this specifies the number of rows fetched when the query
     * is executed, and on successive fetchMoreRows() calls.
     */
	public void setFetchBufferSize( int iNewBufferSize );

	/**
	 * Evalutate the query, and fetch the appropriate
	 * amount of rows, based on the "bufferSize" property.
	 * If not all rows have been fetched, the rowsPending
	 * property will have a "true" value.  The numRowsFetched
	 * property will equal the number of rows satisfying the query
	 * only if the numRowsFetched property is "false".
	 */
	public void executeQuery();

    /**
     * Getter for the booelan "rowsPending" property.
     */
	public boolean getRowsPending();

    /**
     * Get more rows, if "rowsPending" property  is true, otherwise does nothing.
     */
    public void fetchMoreRows();

    /**
     * getCurrentRowNumber allows clients of this Table to get the
     * value of its its "currentRowNumber" property.  It ought to be
     * exposed in the beaninfo as the "read" method for this property.
     */
	public int getCurrentRowNumber();

    /**
     * setCurrentRowNumber allows clients of this Table adjust
     * its "currentRowNumber" property.  It ought to be exposed in
     * the beaninfo as the "write" method for this property.
     */
	public boolean setCurrentRowNumber( int iNewRowNumber, boolean bNotify );

    /**
     * Change the position of this cursor to the
     * next row.  Return false if there is none.
     */
	public boolean nextRow();

    /**
     * Change the position of this cursor to the
     * next row.  Return false if there is none.
     */
	public boolean previousRow();

    /**
     * Delete the specified row number.
     */
	public void deleteRow( int iRowNumber, boolean bNotify );

    /**
     * Add a row to the end of the table
     */
	public void addRow();

    /**
     * Method to set this table's value at row# iRow and column# iColumn.
     */
    public void setTableValue( int iRow, int iColumn, Object oNewValue, NotifyList oNotify );




}
