/*
 * StatusBar.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * created: 2/97 cls
 */


package netscape.peas;

//
//  StatusBar.java
//
import java.awt.Graphics;
import java.awt.Font;
import java.awt.Color;

public class StatusBar extends java.applet.Applet
{
    public StatusBar() {
    }

    public void init() {
        super.init();
    }

    public void setPercent(int percent)
    {
        percentSet = percent;
        System.out.println("Percent Done: " + percentSet);
        repaint();
    }

    public int getPercent()
    {
        return percentSet;
    }

    /**
     *
     * This method can be called by another applet when it is done loading.
     * The effect is that the text changes to "RUNNING!!".
     *
     */
    public void done()
    {
        current_string = bl;
    }

    /**
     *
     * This method to draws the current string (Loading... or RUNNING!!)
     * and the status bar...You shouldn't call this directly...If you want to
     * refresh the display call repaint().
     *
     */
    public void paint(Graphics g)
    {
        setBackground(Color.white);
        g.setFont(theFont);
        g.setColor(Color.red);
        g.drawString(current_string + percentSet+"%" ,0,14);
        g.setFont(theSmallFont);
        g.setColor(Color.blue);
        g.fillRect(0,20,percentSet, 17);
    }

    private Font theFont      = new Font("TimesRoman",Font.BOLD,17);
    private Font theSmallFont = new Font("TimesRoman",Font.BOLD,12);
    static final String s1 = "Loading ";
    static final String bl = "RUNNING!!   ";
    private String current_string = s1;
    private int    percentSet = 0;

}







