<JSB>
/*
 * StaticSelect.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
     <JSB_DESCRIPTOR NAME="netscape.peas.StaticSelect" DISPLAYNAME="Static Select" ISHIDDEN ENV="both"
        SHORTDESCRIPTION="Statically populated Select Box" VISUAL="netscape.palomar.page.component.HTMLSelect">

    <JSB_PROPERTY NAME="size" DISPLAYNAME="box size" PROPTYPE="JS-expr" TYPE="number" ENV="server"
        VALUESET="1:256"
        SHORTDESCRIPTION="Size of box: 1 = drop box, more = list box">

    <JSB_PROPERTY NAME="textOptions" DISPLAYNAME="text options" PROPTYPE="JS-expr" TYPE="string" ENV="server"
        SHORTDESCRIPTION="List of strings which are used as displayed choices">

    <JSB_PROPERTY NAME="valueOptions" DISPLAYNAME="value options" PROPTYPE="JS-expr" TYPE="string" ENV="server"
        SHORTDESCRIPTION="List of strings which are used as values on submit">

    <JSB_PROPERTY NAME="defaultValue" DISPLAYNAME="default value" PROPTYPE="JS-expr" TYPE="string" ENV="server"
        SHORTDESCRIPTION="Value of option which is initially selected">

    // client properties
    <JSB_PROPERTY NAME="value" DISPLAYNAME="value" PROPTYPE="JS" TYPE="string" ENV="client"
        READMETHOD="getValue" WRITEMETHOD="setValue"
        ISRUNTIME ISBOUND ISDEFAULT SHORTDESCRIPTION="Current value of text">

    <JSB_EVENT NAME="onChange" LISTENERMETHODS="onChange" LISTENERTYPE="onChangeListener" EVENTMODEL="JS" ISDEFAULT>
    <JSB_EVENT NAME="onBlur" LISTENERMETHODS="onBlur" LISTENERTYPE="onBlurListener" EVENTMODEL="HTML">
    <JSB_EVENT NAME="onFocus" LISTENERMETHODS="onFocus" LISTENERTYPE="onFocusListener" EVENTMODEL="HTML">

    <JSB_METHOD NAME="getValue" TYPE="string" ENV="client"></JSB_METHOD>
    <JSB_METHOD NAME="setValue" TYPE="void" ENV="client">
        <JSB_PARAMETER NAME="newValue" TYPE="string">
    </JSB_METHOD>

    <JSB_CONSTRUCTOR>
function writeln(str) {
  write(str + "\n")
}
writeln("<SCRIPT SRC='cSelectBox.js'></SCRIPT>")


function parseList( sList ) {
    aRes = null;
    if ( null != sList && ""!=sList ) {
        aRes = new Array();
        nStart = 0;
        nIndex = 0;
        do {
            nCommaPos = sList.indexOf( ',', nStart );
            if ( nCommaPos != -1 ) {
                sEntry = sList.substring( nStart, nCommaPos );
                nStart = nCommaPos+1;
            } else {
                sEntry = sList.substring( nStart );
            }
            aRes[nIndex++] = sEntry;
        } while ( nCommaPos != -1 );
    }
    return aRes;
}

function netscape_peas_StaticSelect(params) {

    // now generate the client object
    if ( ""==params.textOptions ) {
        params.textOptions = null;
    }
    if ( ""==params.valueOptions ) {
        params.valueOptions = null;
    }

    writeln( "<SCRIPT>" );
    writeln( "params = new Object();" );
    writeln( "params.id = '" + params.id + "';" );
    writeln( "params.boxSize = " + params.size );
    if ( null!=params.defaultValue && "" != params.defaultValue ) {
        writeln( "params.defaultValue = '" + params.defaultValue + "';" );
    }

    aValues = parseList( params.valueOptions );

    aTexts = parseList( params.textOptions );

    nOptions = 0;
    if ( null != aValues ) {
        writeln( "params.optVal = new Array();" );
        nOptions = aValues.length;
    }

    if ( null != aTexts ) {
        writeln( "params.optText = new Array();" );
        if ( aTexts.length > nOptions ) {
            nOptions = aTexts.length;
        }
    }

    nRow = 0;
    for ( nRow = 0; nRow < nOptions; nRow++ ) {
        if ( null != aValues ) {
            writeln( "params.optVal[" + nRow + "] = '" + aValues[nRow] +"';" );
        }
        if ( null != aTexts ) {
            writeln( "params.optText[" + nRow + "] = '" + aTexts[nRow] +"';" );
        }
    }
    writeln( params.id + " = new netscape_peas_select_client( params );" );
    writeln( "</SCRIPT>" );

} // netscape_peas_StaticSelect



    </JSB_CONSTRUCTOR>

</JSB>

<JSB_LISTENER NAME="onChangeListener">
    <JSB_METHOD NAME="onChange" TYPE="void">
        <JSB_PARAMETER NAME="propertyName" TYPE="string">
        <JSB_PARAMETER NAME="oldValue" TYPE="undefined">
        <JSB_PARAMETER NAME="newValue" TYPE="undefined">
    </JSB_METHOD>
</JSB_LISTENER>
